#ifndef lint
static char *SccsId = "@(#)slant.c 4.4 (TU-Delft) 11/24/92";
#endif /* lint */
/**********************************************************

Name/Version      : space/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/

#define RSPLIT /* */
#include <stdio.h>
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"
#include "scan.h"

#define checkEdge(e) /* nothing */

void testIntersection (e1, e2)
edge_t * e1, * e2;
{
    coor_t d;
    coor_t xi;
    double s1 = (double) e1 -> dy / (double) e1 -> dx;
    double s2 = (double) e2 -> dy / (double) e2 -> dx;

    /* For efficiency reasons, this function assumes that
     * the test for unequal slopes has been done before calling.
     */

    ASSERT (compareSlope (e1, !=, e2));

    if (e1 -> xl == -INF || e2 -> xl == -INF) return;

    d = Round (((e2 -> yl - e1 -> yl) + s2 * (e1 -> xl - e2 -> xl)) / (s1-s2));

    xi = e1 -> xl + d;

    if (xi <= e1 -> xl || xi >= e1 -> xr) return;
    if (xi <= e2 -> xl || xi >= e2 -> xr) return;

    e1 -> xi = Min (xi, e1 -> xi);
    e2 -> xi = Min (xi, e2 -> xi);

    return;
}

int smallerAtX (x, e1, e2)	/* return 1 if e2 <x e1, 0 otherwise */
coor_t x;
edge_t * e1, *e2;
{
    ASSERT ((e1 -> xr > x) || (e1 -> bundle == NULL));
    if (e1 -> xl > x || e1 -> xr < x) return (0);
    if (e2 -> xl > x || e2 -> xr < x) return (0);
    /* e1 and e2 are comparable at x */
    if (Y (e2, x) < Y (e1, x))        return (1);
    if (Y (e2, x) > Y (e1, x))        return (0);
    if (e1 -> xr == x)                return (0); /* !!! */
    if (compareSlope (e2, <, e1))     return (1);
    return (0);
}

edge_t * split (e1)	/* split sublist of intersecting edges */
edge_t * e1;
{
#ifdef RSPLIT
    edge_t * e4 = e1;
#endif /* RSPLIT */
    coor_t xi   = e1 -> xi;
    coor_t yi   = Y (e1, xi);
    edge_t * e2 = e1 -> fwd;
    edge_t * e;
    edge_t * e3 = e1 -> bwd;
    edge_t * createEdge ();
    ASSERT (e2 -> xi == xi);

    /* let e2 point to other end of sublist */
    while (e2 -> fwd -> xi == xi && compareSlope (e2 -> fwd, <, e2))
	e2 = e2 -> fwd;

    /* e2 is other end of sublist */

#ifdef RSPLIT
    e3 = e2;
#endif /* RSPLIT */

    for (;;) {
	/*ASSERT (Y (e1, xi) == yi); /* this is not true when rounding !!!*/
	if (e1 -> xr > xi) {
	    e = createEdge (xi, yi, e1 -> xr, e1 -> yr, e1 -> color);
	    e -> xc = e1 -> xc;
	    e -> bundle = e1 -> bundle, e1 -> bundle = (edge_t *) NULL;

	    /* insert above e3 */
	    e -> fwd = e3 -> fwd, e -> bwd = e3;
	    e3 -> fwd -> bwd = e, e3 -> fwd = e;

	    checkEdge (e);

	    /* chop old edge */
	    e1 -> xr = xi, e1 -> yr = yi;
	    e1 -> xi = INF;
	    checkEdge (e1);
	}
	if (e1 == e2) break;
	e1 = e1 -> fwd;
    }
#ifndef RSPLIT
    ASSERT (e3 -> fwd == e);
    return (e3 -> fwd);
#else /* RSPLIT */
    checkEdge (e4);
    return (e4);
#endif /* RSPLIT */
}
