/* SccsId = "@(#)makegln.h 4.4 (TU-Delft) 11/24/92" */
/**********************************************************

Name/Version      : makegln/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
typedef int slope_t;
typedef int coor_t;
# include "aux/bool.h"
# ifdef DEBUG
# include "aux/debug.h"
# endif

/* The top part of this structure MUST match
 * that of edge_part_t in output.c
 */
typedef struct edge {
    coor_t xl, yl, xr, yr;
    slope_t slope;
    coor_t xi, xc;
    int sign;
    bool_t ready;
    bool_t remain;
    struct edge * fwd, * bwd;
    struct edge * bundle;
    struct edge * next;
    int signLeft;
} edge_t;

#define INF		MAXTYPE (coor_t)

#ifndef MANHATTAN
#define Y(e,x) \
    (e->slope==(slope_t)0?e->yl:(e->yl+(coor_t)(e->slope*(x-e->xl))))
#else
#define Y(e,x) (e->yl)
#endif

typedef struct _edge {
    coor_t xl, yl, xr, yr;
    slope_t slope;
    int sign;
} _edge_t;

/* Compare two edges lexicographically
 *
 * larger (e1, e2) returns true if e1 > e2 
 * smaller(e1, e2) returns true if e1 < e2 
 */

#ifdef MANHATTAN
#define larger(e1, e2) ( \
    ((e1) -> xl > (e2) -> xl) ? ( 1) : ( \
    ((e1) -> xl < (e2) -> xl) ? ( 0) : ( \
    ((e1) -> yl > (e2) -> yl))))
#else
#define larger(e1, e2) ( \
    ((e1) -> xl > (e2) -> xl) ? ( 1) : ( \
    ((e1) -> xl < (e2) -> xl) ? ( 0) : ( \
    ((e1) -> yl > (e2) -> yl) ? ( 1) : ( \
    ((e1) -> yl < (e2) -> yl) ? ( 0) : ( \
    ((e1) -> slope > (e2) -> slope))))))

#endif MANHATTAN

#define smaller(e1, e2) larger(e2, e1)

/* signs of input edges */
#define STOP  -1
#define START  1

extern void sortEdges();

extern void pqInit ();
extern void pqHead ();
extern void pqInsert ();
extern void pqReplaceHead ();

extern char *tempdir ();

# define unpack4D(fp, d0, d1, d2, d3)  \
    _dmUnpack (fp, "DDDD", d0, d1, d2, d3)

# define pack4D(fp, d0, d1, d2, d3) \
    _dmPack (fp, "D D D D\n", d0, d1, d2, d3)
