static char *SccsId = "@(#)nTLink.c 4.2 (TU-Delft) 11/24/92";
/**********************************************************

Name/Version      : space/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"
#include "lump/define.h"
#include "lump/extern.h"

nTLinkNew (type, n, t)
char type;
node_t * n;
transistor_t * t;
{
    nodeTorLink_t * nTL;

    nTL = NEW (nodeTorLink_t, 1);

    nTL -> type = type;
    nTL -> n = n;
    nTL -> t = t;

    Grp (n) -> notReady++;

    nTL -> nextN = n -> ports;
    n -> ports = nTL;
    nTL -> prevN = NULL;
    if (nTL -> nextN != NULL) 
	nTL -> nextN -> prevN = nTL;

    switch (type) {
	case 'g':
	    nTL -> nextT = t -> gate;
	    t -> gate = nTL;
	    break;
	case 'd':
	    nTL -> nextT = t -> drains;
	    t -> drains = nTL;
	    break;
    }
    nTL -> prevT = NULL;
    if (nTL -> nextT != NULL) 
	nTL -> nextT -> prevT = nTL;
}

nTLinkAdd (type, n, t)
char type;
node_t * n;
transistor_t * t;
{
    nodeTorLink_t * nTL;

    switch (type) {
	case 'g':
	    nTL = t -> gate;
	    break;
	case 'd':
	    nTL = t -> drains;
	    break;
    }
    while (nTL != NULL) {

	if (nTL -> n == n)
	    return;  /* link already exists ! */

	nTL = nTL -> nextT;
    }

    /* link not present yet */

    nTLinkNew (type, n, t);
}

nTLinkDel (nTL)
nodeTorLink_t * nTL;
{
    if (nTL -> prevN != NULL)
	nTL -> prevN -> nextN = nTL -> nextN;
    else {
	nTL -> n -> ports = nTL -> nextN;
    }
    if (nTL -> nextN != NULL)
	nTL -> nextN -> prevN = nTL -> prevN;

    if ( -- (Grp (nTL -> n) -> notReady) == 0) {
	readyGroup (nTL -> n);
    }

    if (nTL -> prevT != NULL)
	nTL -> prevT -> nextT = nTL -> nextT;
    else {
	switch (nTL -> type) {
	    case 'g' :
		nTL -> t -> gate = nTL -> nextT;
		break;
	    case 'd' :
		nTL -> t -> drains = nTL -> nextT;
		break;
	}
    }
    if (nTL -> nextT != NULL)
	nTL -> nextT -> prevT = nTL -> prevT;

    DISPOSE (nTL);
}
