static char *SccsId = "@(#)init.c 4.10 (TU-Delft) 06/01/93";
/**********************************************************

Name/Version      : space/4.10

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <dmincl.h>
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"
#include "lump/define.h"
#include "lump/extern.h"

double select_res;
double imp_res_ratio;
double tor_impedance;

int inCap;
int outCap;
int currIntCap;
int maxIntCap;
int maxCapIfKept;
int inRes;
int outRes;
int currIntRes;
int maxIntRes;
int maxResIfKept;
int inNod;
int outNod;
int currIntNod;
int maxIntNod;
int maxIntANod;
int maxNodIfKept;
int inTor;
int outTor;
int currIntTor;
int maxIntTor;
int maxTorIfKept;
int inSubnod;
int currIntSubnod;
int maxIntSubnod;
int inSubtor;
int currIntSubtor;
int maxIntSubtor;
int outGrp;
int currIntGrp;
int maxIntGrp;
int maxIntNodGrp;
int maxIntResGrp;
int maxIntCapGrp;
int outPrePassGrp;
int currNeqv;

int eliNod;
int condemnCnt;

double totOutCap;

int * histogram;
int histoMaxVal;
int histoSize;
int histoBucket;

int omitRes = 0;
int onlyRes = 0;
strRef_t *resNetList = NULL;

node_t *node_list;

initLump (cellCirKey, cellLayKey, scale)
DM_CELL * cellCirKey;
DM_CELL * cellLayKey;
int scale;
{
    int i;
    strRef_t *strR;
    strRef_t *last_strR;
    FILE *fp;
    char buf[132];
    double atof ();
    char * paramLookupS ();

    initOut (cellCirKey, cellLayKey, scale);

    inCap = 0;
    outCap = 0;
    currIntCap = 0;
    maxIntCap = 0;
    maxCapIfKept = 0;
    inRes = 0;
    outRes = 0;
    currIntRes = 0;
    maxIntRes = 0;
    maxResIfKept = 0;
    inNod = 0;
    outNod = 0;
    currIntNod = 0;
    maxIntNod = 0;
    maxIntANod = 0;
    maxNodIfKept = 0;
    inTor = 0;
    outTor = 0;
    currIntTor = 0;
    maxIntTor = 0;
    maxTorIfKept = 0;
    inSubnod = 0;
    currIntSubnod = 0;
    maxIntSubnod = 0;
    inSubtor = 0;
    currIntSubtor = 0;
    maxIntSubtor = 0;
    outGrp = 0;
    currIntGrp = 0;
    maxIntGrp = 0;
    maxIntNodGrp = 0;
    maxIntResGrp = 0;
    maxIntCapGrp = 0;
    outPrePassGrp = 0;
    currNeqv = 0;

    eliNod = 0;
    condemnCnt = 0;

    node_list = NULL;

    totOutCap = 0;

    if (optHisto) {
	histoSize = 1000;
	if (optCoupCap)
	    histoBucket = 5;
	else
	    histoBucket = 1;
	histogram = NEW (int, histoSize);
	for (i = 0; i < histoSize; i++) {
	    histogram[i] = 0;
	}
	histoMaxVal = 0;
    }

    select_res = atof (paramLookupS ("select_res", "-1"));
    imp_res_ratio = atof (paramLookupS ("imp_res_ratio", "-1"));
    tor_impedance = atof (paramLookupS ("tor_impedance", "-1"));

}

endLump ()
{
    int i;
    FILE * fp_info;
    int rest_node_cnt;
    int rest_grp_cnt;
    extern node_t **QN;
    extern int QN_cnt;
    long totalcost;

    /* Because elemAdd does not add coupling capacitances that are
       too small, some nodes might still be in core.
       Therefore, write these nodes to the database.
    */

#ifdef DEBUG_NODES
    debug_nodes_print ();
#endif

    rest_node_cnt = currIntNod;
    rest_grp_cnt = currIntGrp;

    while (node_list) {

	QN_cnt = 0;
	searchGroup (node_list); 

	outGroup (QN, QN_cnt);
    }

    if (optCap) {
	outGndNode ();
    }

    endOut ();

    ASSERT (condemnCnt == 0);

    if (optHisto) {
	if (optCoupCap) {
	    message (" histogram of R ^ 2 + R C \n");
	}
	else {
	    message (" histogram of R \n");
	}
	message ("      ");
	for (i = 0; i < 10; i++) {
	    message ("%6d", i * histoBucket);
	}
	message ("\n      ");
	message ("------------------------------");
	message ("------------------------------");
	totalcost = 0;
	for (i = 0; i <= histoMaxVal / histoBucket && i < histoSize; i++) {
	    if (i % 10 == 0) message ("\n%5d|", i * histoBucket);
	    message (" %5d", histogram[i]);
	    if (optCoupCap)
	        totalcost = totalcost + i * histogram[i];
	    else
	        totalcost = totalcost + (i * (i + 1)) * histogram[i];
	}
	message ("\n");
	message ("max value  : %d\n", histoMaxVal);
	message ("total cost : %ld\n", totalcost);
	message ("\n");
    }

    if (currIntCap > 0 || currIntRes > 0 
    || currIntNod > 0 || currIntTor > 0 || currIntGrp > 0) {
	fprintf (stderr, 
	"\nWARNING: Circuit items left behind in core !\n\n");
    }

    if (currNeqv > 0) {
	fprintf (stderr, 
	"\nWARNING: %d net equivalences left behind in core !\n\n", currNeqv);
    }

    if (optInfo) {
	fp_info = stdout;

	fprintf (fp_info, "\n");
	fprintf (fp_info, "                   in    out  ");
	fprintf (fp_info, "maxIntern IfKept remaining (flushed)\n");
	fprintf (fp_info, "capacitances : %6d %6d %6d %6d %10d\n", 
		 inCap, outCap, maxIntCap, maxCapIfKept, currIntCap);
	fprintf (fp_info, "resistances  : %6d %6d %6d %6d %10d\n", 
		 inRes, outRes, maxIntRes, maxResIfKept, currIntRes);
	fprintf (fp_info, "nodes        : %6d %6d %6d %6d %10d  (%3d)\n", 
		 inNod, outNod, maxIntNod, maxNodIfKept, 
		 currIntNod, rest_node_cnt);
	fprintf (fp_info, "core nodes   :               %6d        %10d\n",
		 maxIntANod, condemnCnt);
	fprintf (fp_info, "transistors  : %6d %6d %6d %6d %10d\n", 
		 inTor, outTor, maxIntTor, maxTorIfKept, currIntTor);
	fprintf (fp_info, "subnodes     : %6d        %6d        %10d  \n", 
		 inSubnod, maxIntSubnod, currIntSubnod);
	fprintf (fp_info, "subtors      : %6d        %6d        %10d  \n", 
		 inSubtor, maxIntSubtor, currIntSubtor);
	/* fprintf (fp_info, "\n"); */
	fprintf (fp_info, "groups       :        %6d %6d        %10d  (%3d)\n", 
		 outGrp, maxIntGrp, currIntGrp, rest_grp_cnt);
	/*
	fprintf (fp_info, "max cap in g :               %6d\n", 
		 maxIntCapGrp);
	fprintf (fp_info, "max res in g :               %6d\n", 
		 maxIntResGrp);
	fprintf (fp_info, "max nod in g :               %6d\n", 
		 maxIntNodGrp);
	*/
	fprintf (fp_info, "\n");
	fprintf (fp_info, "nbr. of nodes eliminated : %d\n", eliNod);
	fprintf (fp_info, "total output capacitance : %e\n", totOutCap);
	fprintf (fp_info, "\n");
    }

    if (prePass2 && (optSelectiveRes || optPrick))
	verbose (
	 "%d (out of %d) interconnects selected for resistance extraction\n", 
		 outPrePassGrp, outGrp);
}
