static char *SccsId = "@(#)mprintf.c 4.3 (TU-Delft) 01/28/93";
/**********************************************************

Name/Version      : aux/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#define BSIZE 1000

/*
 * mprintf - sprintf in static buffer
 *
 * Example:
 *    int i = ...;
 *    ...
 *    fp = cfopen (mprintf ("abc%d", i), "w");
 * 
 * HOWEVER: There is only one internal buffer.
 *          The current implementation is non-portable.
 *          Other arguments than ints and char pointers do
 *          not work.
 */
char * mprintf (f, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
char * f;
{
    static char buf[BSIZE];
    sprintf (buf, f, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
    if (strlen (buf) + 1 >= BSIZE)
	say ("mprintf: string too long"), die ();

    return (buf);
}
