static char *SccsId = "@(#)grow.c 4.5 (TU-Delft) 04/20/93";
/**********************************************************

Name/Version      : aux/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 4-Oct-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "aux.h"

/*
 * Memory reallocation
 *     <buf>  is a pointer to a dynamic array
 *     <size> is the size of the elements (basic objects)
 *     <from> is the current size of the array when counting the elements
 *     <to>   is the number of elements you want.
 *
 * <buf> can == NULL, for starting, but <from> should then be zero, too.
 * <to> can be > or < or == <from>
 *
 * Currently, memory is always re-alloc'd and memcp'd, but don't count
 * on it.
 */ 
char * grow (buf, size, from, to)
char *   buf;
unsigned size;
unsigned from;
unsigned to;
{
    char * p;
    int n;

    from *= size;
    to   *= size;

    p = NEW (char, to);

    if (buf != NULL) {
	n = Min (from, to);
	memcpy (p, buf, n);

	DISPOSE (buf);
    }
    return (p);
}
