static char *SccsId = "@(#)getopt.c 4.3 (TU-Delft) 01/28/93";
/**********************************************************

Name/Version      : aux/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 10-Jun-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/

#include <stdio.h>
#include "aux/aux.h"

#ifdef BSD
#include <strings.h>
#else
#define index strchr
#include <string.h>
#endif

extern char *index();

int	opterr = 1;
int	optind = 1;
int	optopt;
char	*optarg;


/*
 * This version of getopt is based on the AT&T public domain
 * source for getopt(3).
 *
 * However, it is modified it to understand a ? for optional optargs.
 * Such optional arguments should be supplied without a space
 * between the option letter and the option argument:
 * Mandatory option arguments still can have the space.
 * Optarg is set (unset) when there is (is no) option argument.
 *
 * E.g. optstring = -ab:c?
 *      prog -a -b2 -c		   no value for c option -> optarg == NULL;
 *      prog -a -b 2 -c3	   value 3 for c option  -> optarg != NULL;
 *      prog -a -b 2 -c 3	   no value for c option -> optarg == NULL;
 *
 * Error messages using say ().
 */
int getopt (argc, argv, opts)
int     argc;
char  **argv, *opts;
{
    static int  sp = 1;
    register int    c;
    register char  *cp;

    if (sp == 1) {
	if (optind >= argc ||
		argv[optind][0] != '-' || argv[optind][1] == '\0')
	    return (EOF);
	else  if (strcmp (argv[optind], "--") == NULL) {
	    optind++;
	    return (EOF);
	}
    }

    optopt = c = argv[optind][sp];

    if (c == ':' || c == '?' || (cp = index (opts, c)) == NULL) {
	if (opterr)
	    say ("illegal option -- %c", c);
	if (argv[optind][++sp] == '\0') {
	    optind++;
	    sp = 1;
	}
	return ('?');
    }

    if (*++cp == ':') {
	if (argv[optind][sp + 1] != '\0')
	    optarg = &argv[optind++][sp + 1];
	else  if (++optind >= argc) {
	    if (opterr)
		say ("option requires an argument -- %c", c);
	    sp = 1;
	    return ('?');
	} else 
	    optarg = argv[optind++];
	sp = 1;
    }

    else if (*cp == '?') {
	if (argv[optind][sp + 1] != '\0')
	    optarg = &argv[optind][sp + 1];
	else {
	    optarg = NULL;
	}
	optind++;
	sp = 1;
    }

    else  {
	if (argv[optind][++sp] == '\0') {
	    sp = 1;
	    optind++;
	}
	optarg = NULL;
    }
    return (c);
}

#ifdef DRIVER

/* test driver and example */
main (argc, argv)
int argc;
char * argv[];
{
    extern char *optarg;
    int c;
    while ((c = getopt (argc, argv, "ab:c?")) != EOF) {
	switch (c) {
	    case 'a': printf ("a\n"); break;
	    case 'b': printf ("b %s\n", optarg); break;
	    case 'c': printf ("c %s\n", optarg ? optarg : ""); break;
	    default : printf ("%c\n", c); break;
	}
    }
}
#endif /* DRIVER */
