static char *SccsId = "@(#)new.c 4.2 (TU-Delft) 07/27/92";
/**********************************************************

Name/Version      : sls_exp/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "extern.h"

int newstring (s)
char * s;
{
    int i;
    ENTRY item;
    ENTRY * hsearch();
    int slen = strlen (s) + 1;

    while (ST_cnt + slen > ST_size) {
	enlarge (&ST, &ST_size, sizeof (char), 1.5);
	hdestroy ();
	hcreate (NT_size - mcs_NT_cnt);
	for (i = mcs_NT_cnt; i < NT_cnt; i++) {
            item.key = ST + NT[ i ].name;
            item.data = (char *)&NT[ i ];
            hsearch (item, ENTER);
	}
    }
	 
    strcpy (ST + ST_cnt, s);
    ST_cnt += slen;
    return (ST_cnt - slen);
}

int newname (s)
char *s;
{
    int i;
    ENTRY item;
    ENTRY * hsearch();

    if (NT_cnt >= NT_size) {
        enlarge ((char **)&NT, &NT_size, sizeof (NAMETABLE), 1.5);
	hdestroy ();
	hcreate (NT_size - mcs_NT_cnt);
	for (i = mcs_NT_cnt; i < NT_cnt; i++) {
            item.key = ST + NT[ i ].name;
            item.data = (char *)&NT[ i ];
            hsearch (item, ENTER);
	}
    }

    NT[ NT_cnt ].name = newstring (s); 
    NT[ NT_cnt ].xtx = -1;
    NT[ NT_cnt ].x = -1;
    item.key = ST + NT[ NT_cnt ].name;
    item.data = (char *)&NT[ NT_cnt ];
    hsearch (item, ENTER);
    return(NT_cnt++);
}

int newxt () 
{
    if (XT_cnt + 1 > XT_size) {
	enlarge ((char **)&XT, &XT_size, sizeof (int), 1.5 );
    }
    return (XT_cnt++);
}

int newxx (nbr)
int nbr;
{
    while (XX_cnt + nbr > XX_size) {
	enlarge ((char **)&XX, &XX_size, sizeof (int), 1.5 );
    }
    XX_cnt += nbr;
    return (XX_cnt - 1);
}

int newnode ()
{
    if (N_cnt >= N_size) {
        enlarge ((char **)&N, &N_size, sizeof (NODE), 1.5);
    }

    N[ N_cnt ].ntx = -1;
    N[ N_cnt ].cx = 0;
    N[ N_cnt ].dsx = 0;
    N[ N_cnt ].statcap = 0;
    N[ N_cnt ].funcoutp = FALSE;
    N[ N_cnt ].redirect = FALSE;
    N[ N_cnt ].linked = FALSE;
    N[ N_cnt ].flag = FALSE;
    return(N_cnt++);
}

int newds (nbr)
int nbr;
{
    while (DS_cnt + nbr > DS_size) {
	enlarge ((char **)&DS, &DS_size, sizeof (int), 1.5 );
    }
    DS_cnt += nbr;
    return (DS_cnt - 1);
}

int newc (nbr)
int nbr;
{
    while (C_cnt + nbr > C_size) {
	enlarge ((char **)&C, &C_size, sizeof (CONTROL), 1.5 );
    }
    C_cnt += nbr;
    return (C_cnt - 1);
}

int newtransistor ()
{
    if (T_cnt >= T_size) {
        enlarge ((char **)&T, &T_size, sizeof (TRANSISTOR), 1.5);
    }

    T[ T_cnt ].flag = FALSE;
    T[ T_cnt ].gate = -1;
    T[ T_cnt ].source = -1;
    T[ T_cnt ].drain = -1;

    return (T_cnt++);
}

int newfunctional ()
{
    if (F_cnt >= F_size) {
        enlarge ((char **)&F, &F_size, sizeof (FUNCTION), 1.5);
    }
    
    return (F_cnt++);
}

int newintercap ()
{
    if (I_cnt >= I_size) {
        enlarge ((char **)&I, &I_size, sizeof (INTERCAP), 1.5);
    }

    I[ I_cnt ].con1 = -1;
    I[ I_cnt ].con2 = -1;

    return (I_cnt++);
}

int newfi (nbr)
int nbr;
{
    while (FI_cnt + nbr > FI_size) {
	enlarge ((char **)&FI, &FI_size, sizeof (int), 1.5 );
    }
    while (nbr-- > 0)
	FI[ FI_cnt++ ] = -1;
    return (FI_cnt - 1);
}

int newfr (nbr)
int nbr;
{
    while (FR_cnt + nbr > FR_size) {
	enlarge ((char **)&FR, &FR_size, sizeof (int), 1.5 );
    }
    while (nbr-- > 0)
	FR[ FR_cnt++ ] = -1;
    return (FR_cnt - 1);
}

int newfo (nbr)
int nbr;
{
    while (FO_cnt + nbr > FO_size) {
	enlarge ((char **)&FO, &FO_size, sizeof (FUNCOUT), 1.5 );
    }
    while (nbr-- > 0) {
        FO[ FO_cnt ].trise = 0;
        FO[ FO_cnt ].tfall = 0;
        FO[ FO_cnt ].type = NOTYPE;
	FO[ FO_cnt++ ].x = -1;
    }
    return (FO_cnt - 1);
}

int newfs (nbr)
int nbr;
{
    int a_nbr;

    if (nbr % SIZE_PTR_INT == 0)
        a_nbr = nbr;
    else
        a_nbr = nbr + SIZE_PTR_INT - (nbr % SIZE_PTR_INT);  
        /* to be machine independent */

    while (FS_cnt + a_nbr > FS_size) {
	enlarge ((char **)&FS, &FS_size, sizeof (char), 1.5 );
    }
    FS_cnt += a_nbr;
    return (FS_cnt - (a_nbr - nbr) - 1);
}

int newfd ()
{
    if (FD_cnt >= FD_size) {
        enlarge ((char **)&FD, &FD_size, sizeof (FUNCDESCR), 1.9);
    }

    return(FD_cnt++);
}

int newfv ()
{
    if (FV_cnt >= FV_size) {
        enlarge ((char **)&FV, &FV_size, sizeof (FUNCVAR), 1.9);
    }

    return(FV_cnt++);
}

enlarge (A, A_size, sizeofA, m)  /* enlarges array A by multiplication with m */
char ** A;
int * A_size;
int sizeofA;
float m;
{
    char * newarr;
    int i;
    int newsize;
    int oldtotsize = (*A_size) * sizeofA;
    int newtotsize;

    newsize = (int)( (float)(*A_size) * m );
    if (newsize <= *A_size)
	(*A_size)++;
    else
	*A_size = newsize;

    newtotsize = (*A_size) * sizeofA;

    PALLOC (newarr, newtotsize, char);

    for (i = 0; i < oldtotsize; i++) {
	*(newarr + i) = (*((*A) + i));
    }

    CFREE ((*A));

    *A = newarr;
}
