%{
/* SccsId = "@(#)cmd_l.l 4.9 (TU-Delft) 06/22/93" */
/**********************************************************

Name/Version      : sls/4.9

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf, A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/

#ifdef FLEX_SCANNER /* use GNU flex in stead of regular lex */
int yylineno = 0;
#define YYINCR(_count) yylineno += _count /* have to do this ourselves ... */
#else
#define YYINCR(_x)
#endif

%}
E		[DEde][-+]?[0-9]+
%%
"/*"			{
			int thechar;
			loop:
                            while ((thechar = input()) != '*') {
                                if (thechar == EOF) return (0);
                            }
			    switch (input()) {
				case 0 : return (0);
				case '/' : break;
				case '*' : unput ('*');
				default : goto loop;
			    }
			}
"set"			{ return (SET); }
"l"			{ yylval.ival = L_state; return (LEVEL); }
"h"			{ yylval.ival = H_state; return (LEVEL); }
"x"			{ yylval.ival = X_state; return (LEVEL); }
"f"			{ yylval.ival = Free_state; return (LEVEL); }
"~"			{ return (TILDE); }
"from"			{ return (FROM); }
"fill"			{ return (FILL); }
"with"			{ return (WITH); }
"print"			{ return (PRINT); }
"plot"			{ return (PLOT_TOKEN);
/* "PLOT" conflicts with dmincl.h therefore have to use "PLOT_TOKEN" ...: */
                        }
"option"		{ return (OPTION); }
"simperiod"		{ return (SIMPERIOD); }
"disperiod"		{ return (DISPERIOD); }
"dissipation"		{ return (DISSIPATION); }
"level"			{ return (LEVEL); }
"dump"			{ return (DUMP); }
"at"			{ return (AT); }
"initialize"		{ return (INITIALIZE); }
"sigoffset"		{ return (SIGOFFSET); }
"races"			{ return (RACES); }
"devices"		{ return (DEVICES); }
"statistics"		{ return (STATISTICS); }
"only"			{ return (ONLY); }
"changes"		{ return (CHANGES); }
"process"		{ return (SLS_PROCESS); }
"sigunit"		{ return (SIGUNIT); }
"outunit"		{ return (OUTUNIT); }
"outacc"		{ return (OUTACC); }
"maxpagewidth" 		{ return (MAXPAGEWIDTH); }
"maxnvicin"		{ return (MAXNVICIN); }
"maxtvicin"		{ return (MAXTVICIN); }
"maxldepth"		{ return (MAXLDEPTH); }
"vh"			{ return (VH); }
"vmaxl"			{ return (VMAXL); }
"vminh"			{ return (VMINH); }
"tdevmin"		{ return (TDEVMIN); }
"tdevmax"		{ return (TDEVMAX); }
"on"			{ yylval.ival = TRUE; return (TOGGLE); }
"off"			{ yylval.ival = FALSE; return (TOGGLE); }
"step"			{ return (STEP); }
"random"		{ return (RANDOM); }
"full"			{ return (FULL); }
"define"		{ return (DEFINE_TOKEN); }
"sta_file"		{ return (STA_FILE); }
"."			{ return (DOT); }
".."			{ return (DOTDOT); }
"("			{ return (LPS); }
")"			{ return (RPS); }
"["			{ return (LSB); }
"]"			{ return (RSB); }
"{"			{ return (LCB); }
"}"			{ return (RCB); }
"="			{ return (EQL); }
","			{ return (COMMA); }
";"			{ return (SEMICOLON); }
":"			{ return (COLON); }
"*"			{ return (MULT); }
"!"			{ return (EXCLAM); }
"-"			{ return (MINUS); }
"$"			{ return (DOLLAR); }
\"[^"]*\"		{ 
			yytext[yyleng-1] = '\0';
			yylval.sval = (char *)(&yytext[0]) + 1;
			return (STRING); 
			}
[a-zA-Z_][a-zA-Z0-9_]*	{ 
			yylval.sval = (char *)&yytext[0]; 
			return (IDENTIFIER); }
[0-9]+			{ yylval.sval = (char *)&yytext[0]; return (INT); }
[1][0]*[fpnumkMG]?   	{ 
			char c = yytext[yyleng-1];
			if (isdigit(c))
			    yylval.dval = atof (yytext);
			else {
			    yytext[yyleng-1] = '\0';
			    switch (c) {
			  	case 'G': yylval.dval = 1.0e9 * atof (yytext);
					  break;
			  	case 'M': yylval.dval = 1.0e6 * atof (yytext);
					  break;
			  	case 'k': yylval.dval = 1.0e3 * atof (yytext);
					  break;
			  	case 'm': yylval.dval = 1.0e-3 * atof (yytext);
					  break;
			  	case 'u': yylval.dval = 1.0e-6 * atof (yytext);
					  break;
			  	case 'n': yylval.dval = 1.0e-9 * atof (yytext);
					  break;
			  	case 'p': yylval.dval = 1.0e-12 * atof (yytext);
					  break;
			  	case 'f': yylval.dval = 1.0e-15 * atof (yytext);
					  break;
			    }
			}
			return (POWER_TEN);
			}
[0-9]+("."[0-9]+)?({E})?[fpnumkMG]?	{ 
			char c = yytext[ yyleng - 1 ];
			if (isdigit(c))
			    yylval.dval = atof (yytext);
			else {
			    yytext[ yyleng - 1 ] = '\0';
			    switch (c) {
			 	case 'G': yylval.dval = 1e6 * atof (yytext);
					  break;
			 	case 'M': yylval.dval = 1e6 * atof (yytext);
					  break;
			 	case 'k': yylval.dval = 1e3 * atof (yytext);
					  break;
			 	case 'm': yylval.dval = 1e-3 * atof (yytext);
					  break;
			 	case 'u': yylval.dval = 1e-6 * atof (yytext);
					  break;
			 	case 'n': yylval.dval = 1e-9 * atof (yytext);
					  break;
			 	case 'p': yylval.dval = 1e-12 * atof (yytext);
					  break;
			 	case 'f': yylval.dval = 1e-15 * atof (yytext);
					  break;
			    }
			}
			return (F_FLO); 
			}
[\t ]+			;
"\\"[\n]		{YYINCR(1);}
[\n]+			{YYINCR(yyleng); return (NEWLINE); }
