static char *SccsId = "@(#)str_term.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"

/*
** stretchTerm - stretch a term statement
**
** A terminal is stretched differently from a box,
** because a terminal cannot be splitted into two or 
** tree other terminals 
*/

stretchTerm (tp)
TERM * tp;
{
 /* 
  * cumulative increments of xl, xr, yb and yt
  */
    int     dxl = 0,
            dxr = 0,
            dyb = 0,
            dyt = 0;
    int     result = OK;	/* return value */
    STRETCH * sp;		/* addres of STRECTCH node */
    int     i = 0;		/* loop variabele */
    STRETCH * lookup    ();
    void      cant      ();
    void      printTerm ();

 /* 
  * loop through all stretch nodes in X-direction 
  */

    while ((result == OK) && ((sp = lookup (i++, XDIR)) != NULL)) {
	result = doStretch (&dxl, &dxr, tp -> xl, tp -> xr,
		tp -> yb, tp -> yt, tp -> layer, sp);
    }

 /* 
  * loop through all stretch nodes in Y-direction 
  */
    i = 0;

    while ((result == OK) && ((sp = lookup (i++, YDIR)) != NULL)) {
	result = doStretch (&dyb, &dyt, tp -> xl, tp -> xr,
		tp -> yb, tp -> yt, tp -> layer, sp);
    }

    switch (result) {
	case OK: 
	    tp -> xl += dxl;
	    tp -> xr += dxr;
	    tp -> yb += dyb;
	    tp -> yt += dyt;
	    printTerm (tp);
	    break;
	case CANT: 
	    cant (sp);
	    break;
	default: 
	    PANIC ("bad result: %d", result);
	    break;
    }
    return (result);
}
