static char *SccsId = "@(#)str_box.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"

/* stretchBox - stretch a box if needed */

stretchBox (bp)
BOX * bp;
{
 /* 
  * cumulative increments of xl, xr, yb and yt 
  */
    int     dxl = 0,
            dxr = 0,
            dyb = 0,
            dyt = 0;

    BOX new1, new2;		/* two new boxes, to be used by splitBox */
    int          i = 0;		/* loop variabele */
    int     result = OK;	/* return value */
    STRETCH   * sp;		/* addres of STRETCH node, all nodes are
				   processed in loop */
    STRETCH   * lookup ();
    void      printBox ();
    boolean   splitBox ();

    while ((result == OK) && ((sp = lookup (i++, XDIR)) != NULL)) {
	result = doStretch (&dxl, &dxr, bp -> xl, bp -> xr,
		bp -> yb, bp -> yt, bp -> layer, sp);
    }

    i = 0;

    while ((result == OK) && ((sp = lookup (i++, YDIR)) != NULL)) {
	result = doStretch (&dyb, &dyt, bp -> xl, bp -> xr,
		bp -> yb, bp -> yt, bp -> layer, sp);
    }

    switch (result) {
	case OK: 
	    bp -> xl += dxl;
	    bp -> xr += dxr;
	    bp -> yb += dyb;
	    bp -> yt += dyt;
	    printBox (bp);
	    break;
	case CANT: 
	    if (splitBox (bp, sp, &new1, &new2) == TRUE) {
		result = stretchBox (bp);
		if (new1.xl != new1.xr && new1.yb != new1.yt)
		    (void) stretchBox (&new1);
		if (new2.xl != new2.xr && new2.yb != new2.yt)
		    (void) stretchBox (&new2);
	    }
	    break;
	default: 
	    PANIC ("bad result: '%d'", result);
	    return (result);
	    break;
    }

    if (result != OK)
	PANIC ("bad result: '%d'", result);
    return (result);
}

/*
** splitBox - split off pieces of box which can't be stretched now.
** The resulting pieces of the box are processed directly by the
** caller of splitBox (i.e. stretchBox), by calling itself recursively.
**
** Arguments:
**     bp points to the current box,
**     sp points to the current STRETCH line.
**     bp1 and bp2 point to new pieces of the box.
**         storage must be provided by the caller.
*/

static boolean splitBox (bp, sp, bp1, bp2)
STRETCH * sp;
BOX     * bp;
BOX     * bp1, * bp2;
{
    bp1 -> layer = bp2 -> layer = bp -> layer;
    if (sp -> dir == YDIR) {
	bp1 -> xl = bp -> xl;
	bp2 -> xr = bp -> xr;
	bp1 -> xr = bp -> xl = max (sp -> lo, bp -> xl);
	bp2 -> xl = bp -> xr = min (sp -> hi, bp -> xr);
	bp1 -> yb = bp2 -> yb = bp -> yb;
	bp1 -> yt = bp2 -> yt = bp -> yt;
    }
    else  if (sp -> dir == XDIR) {
	bp1 -> yb = bp -> yb;
	bp2 -> yt = bp -> yt;
	bp1 -> yt = bp -> yb = max (sp -> lo, bp -> yb);
	bp2 -> yb = bp -> yt = min (sp -> hi, bp -> yt);
	bp1 -> xl = bp2 -> xl = bp -> xl;
	bp1 -> xr = bp2 -> xr = bp -> xr;
    }
    else  {
	PANIC ("bad direction: %d", sp -> dir);
	return (FALSE);
    }
    bp1 -> dx = bp2 -> dx = bp -> dx;
    bp1 -> nx = bp2 -> nx = bp -> nx;
    bp1 -> dy = bp2 -> dy = bp -> dy;
    bp1 -> ny = bp2 -> ny = bp -> ny;
    bp1 -> layer = bp2 -> layer = bp -> layer;

    return (TRUE);
}
