%{
static char *SccsId = "@(#)lex.l 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"
# include "y.tab.h"

static int PassNo = 0;
static long offset;
static int lineno;

extern  int yydebug;

# ifdef DRIVER
# define YYDEBUG
# define yywrap() 1
# endif DRIVER

# ifdef YYDEBUG
# define RETURN(v)\
if (yydebug) fprintf(yyout,"token: %s \ttext: '%s'\n", "v", yytext); return (v)
# else NOT YYDEBUG
# define RETURN(v) return(v)
# define skip() while(input()!='\n')
# endif YYDEBUG

# define SKIP(no, v) if (no == PassNo) {skip ();} else {RETURN (v);}

#ifdef FLEX_SCANNER
int yylineno = 0;
#define YYINCR(_count) yylineno += _count
#else
#define YYINCR(_x)
#endif

%}

%%

cx                              RETURN (CX);
copyx                           RETURN (CX);
cy                              RETURN (CY);
copyy                           RETURN (CY);
mx                              RETURN (MIRX);
my                              RETURN (MIRY);
ms                              { offset = ftell (yyin);
				  lineno = yylineno;
				  PassNo = 1;
				  RETURN (MS_TOKEN);
				}
me                              { if (PassNo == 1) {
                                    PassNo = 2;
                                    skip ();
                                    fseek(yyin, offset, 0);
				    yylineno = lineno;
                                    skip ();
                                  }
                                  else {
                                    PassNo = 0;
                                    RETURN (ME_TOKEN);
                                  }
                                }
mc                              SKIP (1, MC_TOKEN);
box                             SKIP (1, BOX_TOKEN);
term                            SKIP (1, TERM_TOKEN);
sx                              SKIP (2, SX);
sy                              SKIP (2, SY);
\+                              RETURN (yytext[0]);
\-                              RETURN (yytext[0]);
\=                              RETURN (yytext[0]);
\<                              RETURN (yytext[0]);
\>                              RETURN (yytext[0]);
r3                              RETURN (ROT3);
r6                              RETURN (ROT6);
r9                              RETURN (ROT9);
t                               RETURN (TRANS);
":".*/\n                        {YYINCR(1); SKIP (1, COMMENT);}
[a-zA-Z_][a-zA-Z0-9_]*          RETURN (WORD);
[-+]?[0-9][0-9]*                RETURN (INT);
^[ \t]*\n			{YYINCR(1); /* ignore empty lines */ ;}
[ \t]*                          /*ignore spaces*/ ;
\n                              {YYINCR(1); RETURN (EOL);}

%%


# ifndef skip
skip () {
    int     c;
    if (yydebug) {
	fprintf (yyout, "skip: ");
	while ((c = input ()) != '\n')
	    fprintf (yyout, "'%c',", c);
	fprintf (yyout, "\n");
    }
    else
	while ((c = input ()) != '\n');
}
# endif

# ifdef DRIVER

main (argc, argv)
int     argc;
char   *argv[];
{
    if (argc > 1) {
	yyin = fopen (argv[1], "r");
	if (!yyin) {
	    perror (argv[1]);
	    exit (1);
	}
    }
    while (yylex ());
}
# endif DRIVER
