static char *SccsId = "@(#)ldm.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
#include "sldm.h"

extern FILE *ofp;

extern void printr ();
extern void printc ();


void doBox (lay, xl, xr, yb, yt, dx, nx, dy, ny, comment)
int     lay, xl, xr, yb, yt, dx, nx, dy, ny;
char   *comment;
{
    BOX b;
    b.layer = lay;
    b.xl = xl;
    b.xr = xr;
    b.yb = yb;
    b.yt = yt;
    b.dx = dx;
    b.nx = nx;
    b.dy = dy;
    b.ny = ny;
    (void) stretchBox (&b);
}

void doMs (name, comment)
char   *name,
       *comment;
{
    fprintf (ofp, "ms %s", name);

    if (comment && strlen (comment))
	fprintf (ofp, " %s\n", comment);

    fprintf (ofp, "\n");
}

void doMc (inst, name, mir, rot, tx, ty, dx, nx, dy, ny, comment)
char   *inst,
       *name,
       *comment;
int     mir, rot, tx, ty, dx, nx, dy, ny;
{
    char *strcpy ();
    MC mc;
    mc.mir = mir;
    mc.rot = rot;
    mc.tx = tx;
    mc.ty = ty;
    mc.dx = dx;
    mc.nx = nx;
    mc.dy = dy;
    mc.ny = ny;
    strcpy (mc.name, name);
    strcpy (mc.inst_name, inst);
    (void) stretchMc (&mc);
}

void doTerm (lay, xl, xr, yb, yt, name, dx, nx, dy, ny, comment)
int     lay, xl, xr, yb, yt, dx, nx, dy, ny;
char   *comment,
       *name;
{
    char * strcpy ();
    TERM t;
    t.layer = lay;
    t.xl = xl;
    t.xr = xr;
    t.yb = yb;
    t.yt = yt;
    t.dx = dx;
    t.nx = nx;
    t.dy = dy;
    t.ny = ny;
    strcpy (t.name, name);
    (void) stretchTerm (&t);
}

doMe (comment)
char   *comment;
{
    void deleteStretch ();

    fprintf (ofp, "me");

    if (comment && strlen (comment))
	fprintf (ofp, " %s", comment);

    fprintf (ofp, "\n");

    /*
     * cleanup stretch nodes
     */
    deleteStretch();
}

doComment (comment)
char *comment;
{
    fprintf (ofp, "%s\n", comment);
}

void printBox (bp)
BOX * bp;
{
    if (bp -> xl != bp -> xr && bp -> yb != bp -> yt) {
	fprintf (ofp, "box n%c", bp -> layer);
	printc (ofp, bp -> xl, bp -> xr, bp -> yb, bp -> yt);
	printr (ofp, bp -> dx, bp -> nx, bp -> dy, bp -> ny);
	fprintf (ofp, "\n");
    }
}

void printMc (mp)
MC * mp;
{
    fprintf (ofp, "mc");
    if (strcmp (mp -> inst_name, "."))/* instance name specified */
	fprintf (ofp, " <%s>", mp -> inst_name);
    fprintf (ofp, " %s", mp -> name);
    if (mp -> mir == 'x')
	fprintf (ofp, " mx");
    else  if (mp -> mir == 'y')
	fprintf (ofp, " my");
    else  if (mp -> mir != 0)
	PANIC ("bad mirror: %d", mp -> mir);
    switch (mp -> rot) {
	case 0: 
	    break;
	case R3: 
	    fprintf (ofp, " r3");
	    break;
	case R6: 
	    fprintf (ofp, " r6");
	    break;
	case R9: 
	    fprintf (ofp, " r9");
	    break;
	default: 
	    PANIC ("bad rotate: %d", mp -> rot);
	    break;
    }
    if (mp -> tx != 0 || mp -> ty != 0)
	fprintf (ofp, " t %d %d", mp -> tx, mp -> ty);
    printr (ofp, mp -> dx, mp -> nx, mp -> dy, mp -> ny);
    fprintf (ofp, "\n");
}

void printTerm (tp)
TERM * tp;
{

    if (tp -> xl != tp -> xr && tp -> yb != tp -> yt) {
	fprintf (ofp, "term n%c", tp -> layer);
	printc (ofp, tp -> xl, tp -> xr, tp -> yb, tp -> yt);
	fprintf (ofp, " %s", tp -> name);
	printr (ofp, tp -> dx, tp -> nx, tp -> dy, tp -> ny);
	fprintf (ofp, "\n");
    }
}

/* printr - print repetition parameters */

static void printr (fp, dx, nx, dy, ny)
FILE * fp;
int     dx, nx, dy, ny;
{
    if (nx != 0)
	fprintf (fp, " cx %d %d", dx, nx);
    if (ny != 0)
	fprintf (fp, " cy %d %d", dy, ny);
}

/* printc - print coordinates */

static void printc (fp, xl, xr, yb, yt)
FILE * fp;
int     xl, xr, yb, yt;
{
    int     t;
    if (xl > xr) {
	t = xl;
	xl = xr;
	xr = t;
    }
    if (yb > yt) {
	t = yb;
	yb = yt;
	yt = t;
    }
    fprintf (fp, " %d %d %d %d", xl, xr, yb, yt);
}
