static char *SccsId = "@(#)error.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"

/*
** cant - print messages about bad input 
** The value yylineno - 1 is used, because the parser has
** already read the newline and yylineno is one too high.
*/

void cant (sptr)
STRETCH * sptr;
{
    extern  char * statement;
    extern  char   infile [];
    extern   int   yylineno;
    fprintf (stderr, "sldm: %s (%d): %s %s %d\n",
	    infile, yylineno - 1, statement,
	    "statement incompatible with stretch statement on line",
	    sptr -> line);
}

/* error - report error messages */

/* VARARGS1 */
void error (s1, s2)
char   *s1;
char   *s2;
{
    fprintf (stderr, "sldm: ");
    fprintf (stderr, s1, s2);
    fprintf (stderr, "\n");
}

/* VARARGS3 */
void panic (file, line, s1, s2)
char   *file;
int     line;
char   *s1;
char   *s2;
{
    if (file && line)
	fprintf (stderr, "sldm internal error, %s (%d): \t", file, line);
    else
	fprintf (stderr, "sldm internal error: ");

    fprintf (stderr, s1, s2);
    fprintf (stderr, "\n");
}

/* die - report error and die */

/* VARARGS1 */
void die (s1, s2)
char   *s1,
       *s2;
{
    void exit ();
    error (s1, s2);
    exit (1);
}
