%{
/* SccsId = "@(#)cmd_l.l 4.10 (TU-Delft) 06/22/93" */
/**********************************************************

Name/Version      : simeye/4.10

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 29-May-1990
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1990 , All rights reserved
**********************************************************/

#ifdef FLEX_SCANNER /* use GNU flex in stead of standard lex */
int yylineno = 0;
#define YYINCR(_count) yylineno += _count /* do it yourself */
#else
#define YYINCR(_x)             /* lex already keeps the line count */
#endif

%}
E		[DEde][-+]?[0-9]+
%%
"/*"			{
                        extern int no_edit;

			int thechar;

			loop:
			    while ((thechar = input()) != '*') {
				if (thechar == 'n'
				    && input () == 'o'
				    && input () == '_'
				    && input () == 'e'
				    && input () == 'd'
				    && input () == 'i'
				    && input () == 't')
				    no_edit = 1;
				if (thechar == EOF) return (0);
			    }
			    switch (input()) {
				case 0 : return (0);
				case '/' : break;
				case '*' : unput ('*');
				default : goto loop;
			    }
			}
"set"			{ extern int no_edit;
			  no_edit = 0;
			  return (SET); }
"l"			{ yylval.ival = L_state; return (LEVEL); }
"h"			{ yylval.ival = H_state; return (LEVEL); }
"x"			{ yylval.ival = X_state; return (LEVEL); }
"f"			{ yylval.ival = Free_state; return (LEVEL); }
"~"			{ return (TILDE); }
"from"			{ return (FROM); }
"fill"			{ return (FILL); }
"with"			{ return (WITH); }
"print"			{ return (PRINT); }
"plot"			{ return (PLOT); }
"option"		{ return (OPTION); }
"simperiod"		{ return (SIMPERIOD); }
"disperiod"		{ return (DISPERIOD); }
"dissipation"		{ return (DISSIPATION); }
"level"			{ return (LEVEL); }
"dump"			{ return (DUMP); }
"at"			{ return (AT); }
"initialize"		{ return (INITIALIZE); }
"sigoffset"		{ return (SIGOFFSET); }
"races"			{ return (RACES); }
"devices"		{ return (DEVICES); }
"statistics"		{ return (STATISTICS); }
"only"			{ return (ONLY); }
"changes"		{ return (CHANGES); }
"process"		{ return (SLS_PROCESS); }
"sigunit"		{ return (SIGUNIT); }
"outunit"		{ return (OUTUNIT); }
"outacc"		{ return (OUTACC); }
"maxpagewidth" 		{ return (MAXPAGEWIDTH); }
"maxnvicin"		{ return (MAXNVICIN); }
"maxtvicin"		{ return (MAXTVICIN); }
"maxldepth"		{ return (MAXLDEPTH); }
"vh"			{ return (VH); }
"vmaxl"			{ return (VMAXL); }
"vminh"			{ return (VMINH); }
"tdevmin"		{ return (TDEVMIN); }
"tdevmax"		{ return (TDEVMAX); }
"on"			{ yylval.ival = TRUE; return (TOGGLE); }
"off"			{ yylval.ival = FALSE; return (TOGGLE); }
"step"			{ return (STEP); }
"random"		{ return (RANDOM); }
"full"			{ return (FULL); }
"define"                { return (DEFINE_TOKEN); }
"sta_file"		{ return (STA_FILE); }
"."			{ return (DOT); }
".."			{ return (DOTDOT); }
"("			{ return (LPS); }
")"			{ return (RPS); }
"["			{ return (LSB); }
"]"			{ return (RSB); }
"{"			{ return (LCB); }
"}"			{ return (RCB); }
"="			{ return (EQL); }
","			{ return (COMMA); }
";"			{ return (SEMICOLON); }
":"			{ return (COLON); }
"*"			{ return (MULT); }
"!"			{ return (EXCLAM); }
"-"                     { return (MINUS); }
"$"                     { return (DOLLAR); }
\"[^"]*\"		{ 
			yytext[yyleng-1] = '\0';
			yylval.sval = yytext + 1;
			return (STRING); 
			}
[a-zA-Z_][a-zA-Z0-9_]*	{ yylval.sval = yytext; return (IDENTIFIER); }
[0-9]+			{ yylval.sval = yytext; return (INT); }
[1][0]*[fpnumkMG]?   	{ double slstof ();
			  yylval.dval = slstof (yytext); 
			  return (POWER_TEN); 
			}
[0-9]+("."[0-9]+)?({E})?[fpnumkMG]?	{ 
			  double slstof ();
			  yylval.dval = slstof (yytext); 
			  return (F_FLO); 
			}
[\t ]+			;
"\\"[\n]		{ YYINCR(1); }
[\n]+			{ YYINCR(yyleng); return (NEWLINE); }

