static char *SccsId = "@(#)arrexp.c 4.3 (TU-Delft) 04/21/93";
/**********************************************************

Name/Version      : arrexp/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 3-Dec-1992
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1992 , All rights reserved
**********************************************************/

#include <stdio.h>

#define  TRUE   1
#define  FALSE  0

int main (argc, argv)
int argc;
char **argv;
{
    FILE *fp;
    char fn_cmd[256];
    char namesave[256];
    char *w;
    char left[256];
    char right[256];
    int l;
    int r;
    int i;
    char peek;
    int block = 0;

    char *getword ();

    if (argc != 2) {
	fprintf (stderr, "Usage: arrexp infile\n");
	exit (1);
    }

    strcpy (fn_cmd, argv[1]);

    if ((fp = fopen (fn_cmd, "r")) == NULL) {
	fprintf (stderr, "Cannot open %s\n", fn_cmd);
	exit (1);
    }

    while ((w = getword (fp))) {
	right[0] = '\0';
	if (w[0] == '['
	    && ((w = getword (fp)) && w[0] >= '0' && w[0] <= '9' && 
							    (strcpy (left, w)))
	    && (w = getword (fp)) 
	    && (w[0] == ']'
		|| (w[0] == '.'
		   && ((w = getword (fp)) && w[0] == '.')
		   && ((w = getword (fp)) && w[0] >= '0' && w[0] <= '9' && 
							   (strcpy (right, w)))
		   && ((w = getword (fp)) && w[0] == ']')
		   && lookahead (fp) != '.'))) {

	    l = atoi (left);
	    if (right[0] != '\0')
		r = atoi (right);
	    else
		r = l;

	    if (l < r) {
		for (i = l; i <= r; i++) {
		    if (i > l)
			printf (" %s", namesave);
		    printf ("_%d_", i);
		}
	    }
	    else {
		for (i = l; i >= r; i--) {
		    if (i < l)
			printf (" %s", namesave);
		    printf ("_%d_", i);
		}
	    }

	    do_cancel ();
	}
	else {
	    do_flush ();
	}
	strcpy (namesave, w);
    }

    do_flush ();

    exit(0);
}

int lookahead (fp)
FILE *fp;
{
    char c;

    c = getc (fp);

    if (c != EOF)
	ungetc (c, fp);

    return (c);
}

char outbuf[8000];
int outbuf_cnt = 0;

char *getword (fp) 
FILE *fp;
{
    static char buf[256];
    char c;
    int i;

    while ((c = getc (fp)) != EOF 
	   && (c == ' ' || c == '\t' || c == '\n')) {
	do_write (c);
    }

    if (c == EOF)
	return (NULL);

    do_write (c);

    if (c == '[' || c == ']' || c == '.' || c == ',') {
	sprintf (buf, "%c", c);
	return (buf);
    }

    i = 0;
    buf[i++] = c;
    while ((c = getc (fp)) != EOF 
	   && !(c == '[' || c == ']' || c == '.' || c == ','
		|| c == ' ' || c == '\t' || c == '\n')) {
	buf[i++] = c;
	do_write (c);
    }

    if (c == EOF)
	return (NULL);
    
    ungetc (c, fp);
    buf[i] = '\0';
    return (buf);
}

do_write (c)
{
    outbuf[ outbuf_cnt++ ] = c;
}

do_flush ()
{
    int i;

    for (i = 0; i < outbuf_cnt; i++) 
	putchar (outbuf[i]);

    outbuf_cnt = 0;
}

do_cancel ()
{
    outbuf_cnt = 0;
}
