static char *SccsId = "@(#)ins_nwf.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern int term_layer;
extern struct event_rec *act_event;

ins_nwf (bot, top, pc_sr, p_next_stop_pos)
long    bot, top;
struct sr_field **pc_sr;
long   *p_next_stop_pos;
{
/* Insert a new field in the stateruler after the field pointed
** to by c_sr.  On return let c_sr point to the new field.
*/
    struct sr_field *new_field;

    ALLOCPTR (new_field, sr_field);
    new_field -> yt = top;
    new_field -> yb = bot;
    new_field -> duration = act_event -> xr;
    new_field -> ol_dur = MIN_INTEGER;
    if (term_layer)
	new_field -> checktype = 0;
    else
	new_field -> checktype = act_event -> attr_no;
    if (*p_next_stop_pos > act_event -> xr)
	*p_next_stop_pos = act_event -> xr;
    new_field -> flag.start = 1;
    new_field -> flag.overlap = 0;
    new_field -> next = (*pc_sr) -> next;
    new_field -> prev = *pc_sr;
    (*pc_sr) -> next = new_field;
    new_field -> next -> prev = new_field;
    set_group (new_field);
    *pc_sr = new_field;
}
