static char *SccsId = "@(#)debug.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 11-May-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern struct sr_field *h_sr;

#ifdef DEBUG
pr_event (event)
struct event_rec *event;
{
    printf ("<- %6d %6d %6d %6d %6d\n",
	event -> xl, event -> xr,
	event -> yb, event -> yt,
	event -> attr_no);
}

pr_evt_list (event1, event2)
struct event_rec *event1, *event2;
{
    struct event_rec *event;

    for (event = event1; event <= event2; ++event)
	pr_event (event);
}

pr_prof (c_sr, scan_mode)
struct sr_field *c_sr;
int scan_mode;
{
    if (!c_sr) {
	if (scan_mode)
	    c_sr = h_sr -> next;
	else
	    c_sr = h_sr -> prev;
    }

    while (c_sr != h_sr) {
	printf ("%11d %11d %11d %11d %3d",
		c_sr -> yb, c_sr -> yt, c_sr -> duration,
		c_sr -> ol_dur, c_sr -> checktype);
	if (c_sr -> flag.start   ) printf (" s");
	if (c_sr -> flag.overlap ) printf (" o");
	if (c_sr -> flag.ol_area ) printf (" a");
	if (c_sr -> flag.incident) printf (" i");
	if (c_sr -> flag.ct_zero ) printf (" c");
	printf ("\n");
	if (scan_mode)
	    c_sr = c_sr -> next;
	else
	    c_sr = c_sr -> prev;
    }
}
#endif DEBUG
