static char *SccsId = "@(#)errexit.c 4.4 (TU-Delft) 04/20/93";
/**********************************************************

Name/Version      : makebox/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 22-Apr-1986
Modified by       : S. de Graaf
Modification date : 11-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

char *err_list[] = {
/* 0 */    "%s",
/* 1 */    "no cell specified",
/* 2 */    "incorrect number of arguments",
/* 3 */    "incorrect window specified",
/* 4 */    "cannot create file: %s",
/* 5 */    "too many arguments specified",
/* 6 */    "sorry: cannot allocate core",
/* 7 */    "error: unknown mask name: %s",
/* 8 */    "error: illegal check level",
/* 9 */    "interrupted due to signal: %s",
/* 10 */   "error in ddm interface function",
/* 11 */   "error: illegal number of samples",
/* 12 */   "error: but cannot find error message"
};

errexit (errno, s)
int     errno;
char   *s;
{
    int i;

    i = (errno < 0) ? -errno : errno;
    if (i > 12) i = 12;

    P_E "%s: ", argv0);
    P_E err_list[i], s);
    P_E "\n");

    if (errno >= 0) die ();
}

dmError (s)
char *s;
{
    if (!noErrMes) {
	P_E "%s: ", argv0);
	dmPerror (s);
	errexit (10, "");
    }
}

die ()
{
    extern char * current_cell;
    extern DM_PROJECT * project;

    if (project) dmCloseProject (project, QUIT);
    dmQuit ();

#   if NCF_RELEASE < 400
    if (current_cell) {
	char buf[DM_MAXPATHLEN];
	P_E "cleaning up %s (running dbclean)\n", current_cell);
	sprintf (buf, "%s/exp_dat", project -> dmpath);
	unlink (buf);
#       ifndef ESE
	sprintf (buf, "dbclean -l %s\n", current_cell);
#       else /* ESE */
	sprintf (buf, "cleancell -view layout %s\n", current_cell);
#       endif /* ESE */
	system (buf);
    }
#   endif /* NCF_RELEASE < 400 */

    P_E "%s: -- program aborted --\n", argv0);

    exit (1);
}
