static char *SccsId = "@(#)aux.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makebox/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 11-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

olap (xl, xr, yb, yt, wdw2, owdw)
long    xl, xr, yb, yt;
long   *wdw2, *owdw;
{
/* determine overlap window */

    if (xl < wdw2[0]) owdw[0] = wdw2[0];
    else              owdw[0] = xl;

    if (xr > wdw2[1]) owdw[1] = wdw2[1];
    else              owdw[1] = xr;

    if (yb < wdw2[2]) owdw[2] = wdw2[2];
    else              owdw[2] = yb;

    if (yt > wdw2[3]) owdw[3] = wdw2[3];
    else              owdw[3] = yt;
}

#ifdef DEBUG
pr_mcelmt (ptr) struct mc_elmt *ptr;
{
    P_E "============ struct mc_elmt: %08x ==============\n", ptr);
    P_E "name <inst_name>: %10s <%s>\n",
	ptr -> name, ptr -> inst_name);
    P_E "bbox[0-3]       : %ld, %ld, %ld, %ld\n",
	ptr -> bbox[0], ptr -> bbox[1],
	ptr -> bbox[2], ptr -> bbox[3]);
    P_E "mtx[0-2]        : %ld, %ld, %ld\n",
	ptr -> mtx[0], ptr -> mtx[1], ptr -> mtx[2]);
    P_E "mtx[3-5]        : %ld, %ld, %ld\n",
	ptr -> mtx[3], ptr -> mtx[4], ptr -> mtx[5]);
    P_E "dx, nx, dy, ny  : %ld, %ld, %ld, %ld\n",
	ptr -> dx, ptr -> nx, ptr -> dy, ptr -> ny);
    P_E "act_regl, parent: %08x, %08x\n",
	ptr -> act_regl, ptr -> parent);
    P_E "child, sibling  : %08x, %08x\n",
	ptr -> child, ptr -> sibling);
    P_E "====================================================\n");
}

pr_ctree (ptr) struct ctree *ptr;
{
    P_E "====== struct ctree: %08x ======\n", ptr);
    P_E "name: %s\n", ptr -> name);
    P_E "lchild, rchild: %08x, %08x\n",
	ptr -> lchild, ptr -> rchild);
    P_E "==================================\n");
}

pr_cptrl (ptr) struct cptrl *ptr;
{
    P_E "==== struct cptrl: %08x ====\n", ptr);
    P_E "cell, next: %08x, %08x\n",
	ptr -> cell, ptr -> next);
    P_E "===============================\n");
}

pr_wdwl (ptr, str)
struct wdw *ptr;
char  *str;
{
/* print contents of wdw list */

    P_E ">>>> %s <<<<\n", str);
    while (ptr) {
	pr_wdw (ptr);
	ptr = ptr -> next;
    }
}

pr_wdw (ptr)
struct wdw *ptr;
{
    P_E "===== struct wdw: %08x =====\n", ptr);
    P_E "wdw[0-3]: %ld, %ld, %ld, %ld\n",
	ptr -> wdw[0], ptr -> wdw[1],
	ptr -> wdw[2], ptr -> wdw[3]);
    P_E "next: %08x\n", ptr -> next);
    P_E "================================\n");
}
#endif
