static char *SccsId = "@(#)dmlockpr.c 3.6 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 06-Jan-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988 , All rights reserved
**********************************************************/
#include "dmstd.h"

int     dmlock_flag = 0;

_dmLockProject (project)
char   *project;
{
#ifndef linux /* linux cannot lock thru NFS mounts ... */
    int     fd;
    char    path[MAXLINE];

#ifdef MSDOS
    _dmSprintf (path, "%s/lockpr.dot", project);
#else
    _dmSprintf (path, "%s/.lockpr", project);
#endif

#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "lockpr: dmlock_flag = %d, path = %s\n",
	    dmlock_flag, path);
#endif /* DM_DEBUG */

    if (dmlock_flag || (fd = creat (path, 0444)) < 0) {
	dmerrno = DME_PRLOCK;
	dmError (path);
	return (-1);
    }
    close (fd);
#endif /* not linux */
    dmlock_flag = 1;
    return (0);
}

_dmUnlockProject (project)
char   *project;
{
#ifndef linux /* linux cannot lock thru NFS mounts ... */
    char    path[MAXLINE];

#ifdef MSDOS
    _dmSprintf (path, "%s/lockpr.dot", project);
#else
    _dmSprintf (path, "%s/.lockpr", project);
#endif

#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "unlockpr: dmlock_flag = %d, path = %s\n",
	    dmlock_flag, path);
#endif /* DM_DEBUG */

    chmod (path, 0666);
    if (!dmlock_flag || unlink (path) != 0) {
	perror (path);
	exit (2);
    /* can not use _dmFatal, because it would try dmQuit, and in *
       release 2 (single-user) dmQuit will try _dmUnlockProject again. */
    }
#endif /* not linux */

    dmlock_flag = 0;
    return (0);
}
