static char *SccsId = "@(#)dmifdeb.c 3.6 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 11-Mar-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

#  ifdef __STDC__
static init_debug(FILE *dfp);
static check(char *file, int line);
#  else /* not __STDC__ */
static init_debug();
static check();
#  endif /* else not __STDC__ */

static char *namelist[64];

_dmIfdebug (file, line)
char   *file;
int     line;
{
    static  init = 2;
    static  FILE * dfp = NULL;
    char   *getenv ();

    if (init == 0)
	return (0);
    else
	if (init == 1)
	    return (check (file, line));

    if (getenv ("DM_DEBUG")
	    && (dfp = fopen (getenv ("DM_DEBUG"), "r"))) {
	init = 1;
	init_debug (dfp);
	return (check (file, line));
    }
    init = 0;
    return (0);
}

static  init_debug (dfp)
FILE * dfp;
{
    register int    i = 0;
    char   *_dmStrSave ();
    char    buf[MAXLINE];

    while (fgets (buf, MAXLINE, dfp)) {
	buf[strlen (buf) - 1] = '\0';
	namelist[i++] = _dmStrSave (buf);
	if (i == 64)
	     _dmFatal ("_dmIfdebug", "too many names", NULL);
    }
    namelist[i] = NULL;

    return 0;
}

static  check (file, line)
char   *file;
int     line;
{
    register int    i;

    for (i = 0; namelist[i] != NULL; i++) {
	if (strcmp (namelist[i], file) == 0) {
	    fprintf (stderr, "---%s, %d:\n", file, line);
	    return (1);
	}
    }
    return (0);
}

#ifdef DRIVER
main ()
{
    int     i = 3;
    while (i-- > 0) {
	IFDEBUG
	    fprintf (stderr, "i: %d\n", i);
    }
}
#endif /* DRIVER */
