static char *SccsId = "@(#)dmfproj.c 3.4 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 24-Feb-1987
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/

#include "dmstd.h"

DM_PROJECT * dmFindProjKey (loc_imp, local_name, father_proj, rem_namep, view)
int loc_imp;
char * local_name;
DM_PROJECT * father_proj;
char ** rem_namep;
char * view;
{
    IMPCELL ** imp_p;
    DM_PROJECT * projkey;
    int view_entry;

    if ((view_entry = _dmValidView (view)) == -1) {
	return (NULL);
    }

    if (loc_imp == LOCAL) {
	*rem_namep = local_name;
	return (father_proj);
    }
    else if (loc_imp != IMPORTED) {
	dmerrno = DME_BADARG;
	dmError ("dmFindProjKey");
	return (NULL);
    }

    if ((imp_p = father_proj -> impcelllist[view_entry]) == NULL) {
	/* Obtain (pointer to) imported celllist. */
        if ((imp_p = (IMPCELL **) dmGetMetaDesignData (IMPORTEDCELLLIST,
					father_proj, view)) == NULL) {
	    return (NULL);
        }
    }

    /* Now scan the imported celllist that was just found. */
    /* From this list the project and the remote name can  */
    /* be decoded given the local name.			   */
    for ( ; imp_p && *imp_p; imp_p++) {
	if (strcmp (local_name, (*imp_p) -> alias) == 0) {
	    /* Alias found. Obtain project key. If already */
	    /* present the existing key will be returned.  */
	    if ((projkey = dmOpenProject ((*imp_p) -> dmpath, PROJ_READ))
							== NULL) {
		return (NULL);
	    }
	    *rem_namep = (*imp_p) -> cellname;
	    return (projkey);
	}
    }
    dmerrno = DME_NOCELL;
    dmError ("dmFindProjKey");
    return (NULL);
}
