static char *SccsId = "@(#)dmcstrm.c 3.11 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 21-Jan-1988
Modification date : 10-Feb-1989


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1989, All rights reserved
**********************************************************/
#include "dmstd.h"

static  DM_STREAM * stream_admin[DM_MAXSTREAMS];
static  streamno = -1;

dmCloseStream (dmfile, mode)
DM_STREAM * dmfile;
int mode;
{
     int cs_mode = 0;
     /* should become a new argument of dmCloseStream
	in the near future (PvdW) */

#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "keyno: %d, streamno: %d, fildes: %d\n",
	    dmfile -> dmkey -> keyno,
	    dmfile -> streamno,
	    fileno (dmfile -> dmfp));
#endif /* DM_DEBUG */

    /*** NOT NEEDED FOR THIS FUNCTION, MAYBE FOR _dmCSToDesMan
    if (_dmCh_key (dmfile -> dmkey)) {
	dmError ("dmCloseStream");
	return (EOF);
    }
    ************/

    if (dmfile -> dmfp && fclose (dmfile -> dmfp) == EOF) {
	dmerrno = DME_SYS;
	dmError ("dmCloseStream");
	return (EOF);
    }

    if (_dmCSToDesMan (dmfile, cs_mode) < 0) {
	dmError2 ("dmCloseStream", dmfile -> stream);
	return (EOF);
    }

    _dmRm_streamkey (dmfile);

    return (0);
}

/* 
** This function allocates a structure describing an
** stream which is passed to the user and initializes it.
** Information must still be written to this structure.		 
*/
DM_STREAM * _dmMk_streamkey ()
{
    DM_STREAM * key;

    if (++streamno == DM_MAXSTREAMS) {
	_dmFatal ("_dmMk_streamkey: too many open streams", "", "");
    }

    if ((key = (DM_STREAM *) malloc (sizeof (DM_STREAM))) == NULL) {
	_dmFatal ("_dmMk_streamkey: cannot alloc key", "", "");
    }

    stream_admin[streamno] = key;
    key -> streamno = streamno;

    return (key);
}

/* 
** This function removes the structure which is passed to
** the user at dmOpenStream time and which identificates the
** stream opened.
*/
_dmRm_streamkey (key)
DM_STREAM * key;
{
    if (key -> streamno != streamno) {
	stream_admin[key -> streamno] = stream_admin[streamno];
	stream_admin[streamno] -> streamno = key -> streamno;
    }
    --streamno;
    _dmStrFree (key -> stream);
    _dmStrFree (key -> mode);
    dmFree ((char *) key, sizeof(DM_STREAM));
}

dmCloseCellStreams (cellkey, mode)
DM_CELL * cellkey;
int mode;
{
    int     i;

    for (i = streamno; i >= 0; --i)
	if (stream_admin[i] -> dmkey == cellkey)
	    dmCloseStream (stream_admin[i], mode);
}
