static char *SccsId = "@(#)dmchkin.c 3.10 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 21-Jan-1988
Modification date : 26-Apr-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988, All rights reserved
**********************************************************/
#include "dmstd.h"

dmCheckIn (key, mode)
DM_CELL * key;
int mode;
{
    char    path[MAXLINE];
    FILE * fp;

#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "cell: '%s', keyno: %d mode: %d\n",
	    key -> cell, key -> keyno, mode);
#endif /* DM_DEBUG */

    if (_dmCh_key (key) != 0) {
	dmError ("dmCheckIn");
	return (-1);
    }

    switch (mode) {

	case CONTINUE: 
	case COMPLETE: 
	    if (key -> mode &CREATE) {
		_dmSprintf (path, "%s/%s/celllist", key -> dmproject -> dmpath,
			key -> view);
		if (!(fp = fopen (path, "a"))) {
		    _dmFatal ("dmCheckIn: cannot update celllist for cell: %s",
			    key -> cell, "");
		}
		fprintf (fp, "%s\n", key -> cell);
		fclose (fp);
	    }
	    if (mode == CONTINUE) {
		key -> mode &= ~CREATE;
	    }
	    break;

	case QUIT: 
	    if (key -> mode & CREATE) {
		_dmSprintf (path, "%s/%s/%s", key -> dmproject -> dmpath,
			key -> view, key -> cell);
#ifdef MSDOS
		if (_dmRmCell (key -> dmproject, key -> cell, key -> view) == -1) {
		    dmerrno = DME_SYS;
		    return (-1);
		}
#else
		if (_dmRun ("/bin/rm", "-rf", path, NULL)) {
		    dmerrno = DME_SYS;
		    return (-1);
		}
#endif
	    }
	    break;

	default: 
	    dmerrno = DME_BADARG;
	    dmError ("dmCheckIn");
	    return (-1);
    }

    /* we now inform the design manager of this checkin (PvdW) */
    if (_dmCIToDesMan (key, mode) < 0) {
	dmError2 ("dmCheckIn", key -> cell);
	return (-1);
    }

    dmCloseCellStreams (key, mode);

    if (mode != CONTINUE) {
	_dmRm_cellkey (key);
    }

    return (0);
}
