
: SccsId = "@(#)readgds.sh 4.1 (TU-Delft) 06/09/90"
#
# readgds - read a GDS II tape
#
# created by   : R. Paulussen
# creation date: 08-Feb-1988
#
# All tapedata will be stored as follows:
#	files		: input.gds.<vol>   
# Each file will contain 1 datafile form the tape
#	recordlength=2048
#
USAGE="Usage: readgds maincell [volume]"

if test $# -gt 2
then
    echo ""
    echo "$USAGE"
    echo ""
    exit 1
fi

if test $# -lt 1
then
    echo ""
    echo "$USAGE"
    echo ""
    exit 1
fi

for dev in /dev/rmt12 /dev/rmt/0mn /dev/rmt/1mn no_dev
do
    if test -r $dev
    then break
    fi
done
if test $dev = no_dev
then
    echo "readgds: sorry: no readable tape device exist!"
    exit 1
fi
job=$1

if test $# -eq 2
then
    fileno=$2
else
    fileno=1
fi

echo "**** readgds starting ****"
echo "Reading: $job.gds.$fileno"
echo "Volume: $fileno"

dd if=$dev of="$job.gds.$fileno" bs=2048 conv=noerror

if test ! -s "$job.gds.$fileno"
then
    echo "readgds: empty tape, no file created"
    exit 1
fi

echo "volume $fileno has been read"
echo "**** readgds finished ****"

mt -t $dev rew
mt -t $dev offl
exit 0

# end of script
