/* SccsId = "@(#)func_parse.h 4.2 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : func_mkdb/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : GOULD

Author(s)         : O. Hol
Creation date     : 05-Nov-1987
Modified by       : S. de Graaf
Modification date : 25-Apr-1988
Modified by       : P.E. Menchen
Modification date : 06-Sep-1991



        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1991, All rights reserved
**********************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "dmincl.h"

#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif

#define FUNCTIONAL "functional"

#define	MALLOC(ptr,type) \
{\
    ptr = (type *)malloc( (unsigned) sizeof(type));\
    if (!ptr) die (1, "", "");\
}
#define SIZE_PTR_INT	(sizeof(int *))

#define	NOPOINTER 	0
#define	POINTER 	1

#define	NoType		5
#define	NoPlace		6

#define	OutpTerm	1	/* these defines must be equal to the  */
#define	InoTerm 	2	/* the defines used in futil.c of sls  */
#define	InpTerm 	3
#define	InrTerm 	4

#define	MIN_CAP		5	/* these defines must be equal to the  */
#define	MAX_CAP		6	/* the defines used in futil.c of sls  */

#define	StateChar 	7
#define	StateInt 	8
#define	StateFloat 	9
#define	StateDouble	10

#define	NMBIND 		2      /* terminal arrays may be maximum 2 dimensional*/

#define	FUNNOIND 	11     /* these defines are used for       */
#define	FUNINT 		12     /* evaluating the indexes of        */
#define	FUNVAR 		13     /* terminals of the function block  */

extern	yylineno;
extern	yydebug;

typedef struct term {
	char	name[DM_MAXNAME+1];
	int	type;
	int	ind[NMBIND];
	int	arrind;        /* arrind indicates the index of the terminal */
			       /* in the created array S                     */
	struct term	*next;
} FTERM;


extern FTERM	*trm_buf;	/* list temporarely containing terminals */
extern FTERM	*ftrm_list;     /* list containing all terminals in      */
				/* order they are declared               */

extern char	Func_name[BUFSIZ];
extern char     viewtype[BUFSIZ];
extern char     cmdstr[BUFSIZ];

extern FILE     *yyin, *yyout;
extern char	*infile;

extern DM_CELL  *key, *dkey;
extern DM_STREAM *fdes, *ddes;
extern DM_PROJECT *dmproject;

extern char  	*strcat();
extern char  	*strcpy();
extern char  	*strsav();
extern char  	*malloc();

extern int 	verbose; 		/* variables */
extern int 	cflag;			/* used for  */
extern char 	C_options[BUFSIZ]; 	/* options   */
extern int      dummy;
extern int      cirflag;

extern int 	os_cnt;		/* these variables are used                 */
extern int 	is_cnt;		/* in routines in the files parsefuncs.c    */
extern int 	rs_cnt;		/* and rout_eval.c; they indicate the       */
extern int 	ss_cnt;		/* places in the list of terminals          */
extern int 	ps_cnt;		/* for a certain type of terminal           */

extern int 	adm_bsalloc_flag;	/* bit string allocation administration     */
                                        /* must be done in this block               */

extern void 	rmexec ();
extern void 	addfun_obj ();
extern void 	cppexec ();
extern void 	addfun_term ();
extern void 	usage();
extern void 	lineno();
extern void 	yyerror();
extern void	app_list();
extern void 	build_array();
extern void 	print_decl();
extern void 	check_term();
extern void 	print_func_head();
extern void 	print_func_foot();
extern void 	pr_rtn_arg();
extern void 	delay_eval();
extern void 	capadd_eval();
extern void 	getcap_eval();
