/* SccsId = "@(#)dubcheck.h 4.2 (TU-Delft) 01/23/91" */
/**********************************************************

Name/Version      : DUBCHECK/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Liedorp
Creation date     : 25-Nov-1985
Modified by       : J. Liedorp
Modification date : 05-March-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
*********************************************************/
#include "stdio.h"
#include "errno.h"
#include "signal.h"
#include "dmincl.h"

#define GRP_BUFLEN	1024
#define MODELSIZE	10
#define LAYERSIZE	3
#define MAXGAPTABLE	8
#define MAXLINE		80
#define MAXINT		0x3FFFFFFF
#define MAX_GROUP	1000

#define START_EDGE	1
#define STOP_EDGE	2
#define CHANGE_EDGE	4
#define START_CHG_EDGE	START_EDGE + CHANGE_EDGE
#define STOP_CHG_EDGE 	STOP_EDGE + CHANGE_EDGE
#define START_OV    	8
#define STOP_OV     	16

#define TRUE		1
#define FALSE		0

#define UP          	1
#define DOWN        	2

#define ON	    	1
#define OFF         	0

#define FIRST       	0
#define SECOND      	1
#define THIRD		2

#define LEFT		1
#define RIGHT		2
#define BOTTOM		4
#define TOP		8

#define NOT_PRESENT 	0
#define CHG_TO_PRESENT	1
#define CHG_TO_NOTPRESENT 2
#define PRESENT	 	3

#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))
#define ABS(a)   ((a)<0 ? -(a) : (a))

#define EXPDATA		"exp_dat"

#define ALLOC(ptr,name) {\
if(!(ptr = (struct name *) calloc (1, sizeof (struct name))))\
perror ("calloc"); }

#define NALLOC(ptr,num,name) {\
if(!(ptr = (name *) calloc ((unsigned) (num), sizeof (name))))\
perror ("calloc"); }

#define FREE(ptr) cfree((char*)(ptr))

#define OPEN(ptr,name,mode) {\
if(!(ptr = fopen (name, mode))) { perror (name); die (1); }}

#define CLOSE(ptr) {\
if((fclose (ptr)) == EOF) { perror ("fclose"); die (1); }}

DM_STREAM * pvln[3];
FILE * pexp;
FILE * pdat;
FILE * pout;
FILE * bufil;

char    c;
char    line[MAXLINE];
char    conn_dir[MAX_GROUP];

struct {
    int     e_xi;
    int     e_occ;
    int     e_yb;
    int     e_yt;
    int     e_conn;
    int     e_group;
    int     e_ctype;
} event[3];

struct chk_err {
    char err_type[10];
    int x1, x2, y1, y2;
    struct chk_err *next;
} *head_errlist;

int     zero_flag;
struct {
   int x1;
   int x2;
   int y1;
   int y2;
   int group1;
   int group2;
} buff;

int	kind;
int     exgap;
int     exlength;
int     exgapflag;
int	gapflag;
int     gap;
int     overlap;
int     overlapflag;
int     Errno;
int     MAXINFLUENCE;
int     grow_fact;

int	nr_samples;

struct group {
    struct eq *eq_pntr;
};

struct group *group_arr[GRP_BUFLEN];

struct eq {
   int eq_group;
   struct eq *next;
};

struct err_pos {
    int x1;
    int y1;
    int x2;
    int y2;
    int group1;
    int group2;
    struct err_pos *next;
} *head_err;
 
struct sr_field {
    int     xstart[2];
    int     yb;
    int     yt;
    int     lay_status[2];
    int     group[2];
    int     chk_type[2];
    int	    helplay_status;
    int	    helplay_xstart;
    struct sr_field *next;
    struct sr_field *prev;
} *h_sr, head_sr;

struct table {
    int     dis[MAXGAPTABLE + 1];
} *ptable;

double  sqrt ();
char   *strcpy ();
char   *calloc ();
