static char *SccsId = "@(#)dig_circle.c 4.2 (TU-Delft) 07/30/91";
/**********************************************************

Name/Version      : DUBCHECK/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)	  : T.G.R. van Leuken, J.T. Fokkema
Creation date	  : 15-Jun-1982
Modified by       : J. Liedorp
Modification date : 23-Dec-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
#include "dubcheck.h"

/* This procedure returns the value of the square root	 */
/* of length*length - dx*dx making use of the table made */
/* by ini().						 */
/* If the length is greater then the dimensions of the	 */
/* table, the value is calculated via a square root.	 */
/* If the value has to be calculated such that an	 */
/* overlapping layer holds the distance (rule - overlap) */
/* extra transformations are performed.			 */

dig_circle (length, dx)
int     length,
        dx;
{
    int red_length;
    int red_dx;

    if(grow_fact == 0) {
        if (dx >= length)
	    return (0);
        if (length > MAXGAPTABLE || dx > MAXGAPTABLE)
            return((int) (sqrt((double) (length * length) -
                               (double) (dx * dx)) + 0.99999));
        return (ptable[length].dis[dx]);
    }
    else {
	if(dx <= grow_fact)
	    return(length);
	if(dx >= length)
	    return(0);
	red_length = length - grow_fact;
	red_dx = dx - grow_fact;
	if(red_length > MAXGAPTABLE || red_dx > MAXGAPTABLE)
	    return((int) (sqrt((double) (red_length * red_length) -
			       (double) (red_dx * red_dx)) +
					 grow_fact + 0.99999));
	return(ptable[red_length].dis[red_dx] + grow_fact);
    }
}
