static char *SccsId = "@(#)lscells.c 3.5 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : dblist/3.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 24-Mar-1988
Modified by       : S. de Graaf
Modification date : 26-Apr-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988, All rights reserved
**********************************************************/
#include "stdio.h"
#include "sys/types.h"
#include "sys/stat.h"
#include "dmincl.h"

extern int columns;
extern int view_nr;
extern DM_PROJECT *project;
char  *celllst[DM_MAXCELLS + 1];
char  *fcelllst[DM_MAXCELLS + 1];

lscells (cellName, cl, icl)
char  *cellName;
char **cl;
IMPCELL **icl;
{
	register char **cp0;
	register char **cplast;
	register char **fcp0;
	register char **fcplast;
	struct stat buf;
	DM_CELL *dmcell;

        cplast = cp0 = celllst;
        fcplast = fcp0 = fcelllst;
	for (; *cl != 0; ++cl) {
	    if (gmatch (*cl, cellName)) {
		if (view_nr == 2) { /* circuit */
		    dmcell = dmCheckOut (project, *cl,
				ACTUAL, DONTCARE, CIRCUIT, READONLY);
		    if (dmStat (dmcell, "fterm", &buf) == 0)
			*fcplast++ = *cl;
		    if (dmStat (dmcell, "mc", &buf) == 0)
			*cplast++ = *cl;
		    dmCheckIn (dmcell, COMPLETE);
		}
		else
		    *cplast++ = *cl;
	    }
	}
	if ((cplast - cp0) > 0) {
	    print (cp0, cplast);
	}
	if ((fcplast - fcp0) > 0) {
	    printf ("function:\n");
	    print (fcp0, fcplast);
	}

        cplast = cp0 = celllst;
	for (; *icl != NULL; ++icl) {
	    if (gmatch ((*icl) -> alias, cellName))
		*cplast++ = (*icl) -> alias;
	}
	if ((cplast - cp0) > 0) {
	    printf ("imported:\n");
	    print (cp0, cplast);
	}
}

print (cp0, cplast)
char **cp0;
char **cplast;
{
	char **cp;
	int compare ();
	int nentry;
	int lines, i, j;

	nentry = cplast - cp0;
        qsort (cp0, nentry, sizeof (char *), compare);

	lines = (nentry + columns - 1) / columns;

	for (i = 0; i < lines; i++) {
	    for (j = 0; j < columns; j++) {
		cp = cp0 + j * lines + i;
		if (cp + lines >= cplast) {
		    printf ("%s\n", *cp);
		    break;
		}
		else {
		    printf ("%-*s  ", DM_MAXNAME, *cp);
		}
	    }
	}
}

int compare (s1, s2)
char  **s1, **s2;
{
    return (strcmp (*s1, *s2));
}

/* global matcher of names
**
** "*" in params matches r.e ".*"
** "?" in params matches r.e. "."
** "[...]" in params matches character class
** "[...a-z...]" in params matches a through z.
**
*/
gmatch (s, p)
register char *s, *p;
{
	register int scc;
	int ok, lc;
	char c;

	if (!p) return (1);

	if (scc = *s++) if ((scc &= 0177) == 0) scc = 0200;

	switch (c = *p++) {

	    case '[':
		ok = 0; lc = 077777;
		while (c = *p++) {
			if (c == ']') {
			    return (ok ? gmatch (s, p) : 0);
			}
			else if (c == '-') {
			    if (lc <= scc && scc <= (*p++)) ok++;
			}
			else if (scc == (lc = (c & 0177))) ok++;
		}
		break;

	    default:
		if ((c & 0177) != scc) return (0);

	    case '?':
		return (scc ? gmatch (s, p) : 0);

	    case '*':
		if (*p == 0) return (1);
		--s;
		while (*s) if (gmatch (s++, p)) return (1);
		return (0);

	    case 0:
		return (scc == 0);
	}

	return (0);
}
