static char *SccsId = "@(#)dblist.c 3.15 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : dblist/3.15

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 10-Jan-1986
Modified by       : S. de Graaf
Modification date : 21-Apr-1987
Modified by       : G.W. Sloof
Modification date : 13-Apr-1988
Modified by       : S. de Graaf
Modification date : 28-Apr-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1988, All rights reserved
**********************************************************/
#include "stdio.h"
#include "signal.h"
#include "dmincl.h"
#ifdef ESE
#include "eseOption.h"
#include "tversion.h"
#endif

#define PE fprintf(stderr,

#ifndef ESE
char *argv0 = "dblist";
#else
char *argv0 = "lscell";
#endif

DM_PROJECT *project;
char *cellName = NULL;
int  dflag = 0;
int  hflag = 0;
int  iflag = 0;
int  rflag = 0;
int  sflag = 0;
int  tflag = 0;
int  layout = 0;
int  circuit = 0;
int  floorplan = 0;
int  oneview = 0;
int  columns = 4;
char ** viewlist = NULL;

#ifdef ESE
OptionSpec optionSpecs[] = {
    { "usage", NO, eseHelp, (void *) optionSpecs,
            "-usage:     lscell [options] [cell]\nOptions (may be abbreviated) are:"},
    { "release", NO, esePrintString, (void *) TOOLVERSION,
            "    -release:              print the release number of this tool"},
    { "help", NO, eseHelp, (void *) optionSpecs,
            "    -help:                 print this list" },
    { "%help", NO, eseHelpAll, (void *) optionSpecs,
            "    -%help:                print this list" },
    { "%etext", NO, eseText, (void *) NULL,
            "    -%etext:               print the '(int) & etext' number" },
    { "hierarchy", NO, eseTurnOn, (void *) & hflag,
            "    -hierarchy:            list the hierarchy" },
    /*
    { "imported", NO, eseTurnOn, (void *) & iflag,
            "    -imported:             list imported root cells in a hierarchical listing" },
    */
    { "device", NO, eseTurnOn, (void *) & dflag,
            "    -device:               list device cell and function calls for circuit view" },

    { "roots", NO, eseTurnOn, (void *) & rflag,
            "    -roots:                list only root-cells" },
    { "%firsttime", NO, eseTurnOn, (void *) & sflag,
            "    -%firsttime:           expand only the first time (= default)" },
    { "tree", NO, eseTurnOn, (void *) & tflag,
            "    -tree:                 print the full tree" },
    { "view", YES, eseListArguments, (void *) & viewlist,
            "    -view viewtype(s):     list only cells of specified viewtype(s)"},
    { "%layout", NO, eseTurnOn, (void *) & layout,
            "    -%layout:              list only the layout view" },
    { "%circuit", NO, eseTurnOn, (void *) & circuit,
            "    -%circuit:             list only the circuit view" },
    { "%columns", YES, eseAssignIntArgument, (void *) & columns,
            "    -%columns: number      use 'number' columns for listing" },
    { (char *) 0, (char) 0, (IFP) 0, (void *) 0, (char *) 0 },
};
#endif

main (argc, argv)
int   argc;
char *argv[];
{
    char *s;

    int sig_handler (); /* signal handler */

    if (!isatty (fileno (stdout))) columns = 1;

#ifndef ESE
    while (--argc > 0) {
        if ((*++argv)[0] == '-' ) {
	    for (s = *argv + 1; *s != '\0'; s++) {
	        switch (*s) {
		    case 'h':
			hflag = 1;
			break;
		    case 'i':
			iflag = 1;
			break;
		    case 'd':
			dflag = 1;
			break;
		    case 'r':
			rflag = 1;
			sflag = 0;
			tflag = 0;
			break;
		    case 's':
			rflag = 0;
			sflag = 1;
			tflag = 0;
			break;
		    case 't':
			rflag = 0;
			sflag = 0;
			tflag = 1;
			break;
		    case 'l':
			layout = 1;
			break;
		    case 'c':
			circuit = 1;
			break;
		    case 'f':
			floorplan = 1;
			break;
		    default:
			die (0, argv0);
	        }
	    }
	}
	else {
            if (cellName == NULL) {
		cellName = *argv;
	    }
	    else {
		die (0, argv0);
	    }
	}
    }
#else
    if (eseOptionHandler (argc, argv, optionSpecs, 1, & cellName) > 0)
        exit (1);

    while (viewlist && viewlist[0]) {
        if (strncmp (viewlist[0], "layout", strlen (viewlist[0])) == 0) {
            layout = 1;
        }
        else if (strncmp (viewlist[0], "circuit", strlen (viewlist[0])) == 0) {
            circuit = 1;
        }
        else {
            PE "-view: '%s' does not exist\n", viewlist[0]);
        }
        viewlist++;
    }
#endif

    if (layout) ++oneview;
    if (circuit) ++oneview;
    if (floorplan) ++oneview;

    if (!oneview) {

    if (rflag || sflag || tflag || dflag)
        hflag = 1;
#ifndef ESE
	floorplan = 1;
#endif
	circuit = 1;
	layout = 1;
    }
    else if (oneview > 1) {
	oneview = 0;
    }

#ifndef MSDOS
    signal (SIGHUP,  SIG_IGN); /* ignore hangup signal */
    signal (SIGQUIT, SIG_IGN);
#endif

    if (signal (SIGINT, SIG_IGN) != SIG_IGN)
	signal (SIGINT, sig_handler);
    signal (SIGTERM, sig_handler);

    dmInit (argv0);
    project = dmOpenProject (DEFAULT_PROJECT, PROJ_READ);

    if (layout)
	lview (cellName, LAYOUT, 1);

    if (circuit)
	lview (cellName, CIRCUIT, 2);

#ifndef ESE
    if (floorplan)
	lview (cellName, FLOORPLAN, 3);
#endif

    if (!oneview) printf ("\n");

    dmQuit ();

    return (0);
}

int sig_handler (sig) /* signal handler */
int sig;
{
    static char buf[8];
    signal (sig, SIG_IGN); /* ignore signal */
    sprintf (buf, "%d", sig);
    PE "\n");
    die (1, buf);
}

dmError (s)
char *s;
{
    PE "%s: ", argv0);
    dmPerror (s);
    die (2, "");
}

char *errlist[] = {
#ifndef ESE
/* 0 */  "\nUsage: %s [-lcf] [-d] [-hi] [-rst] [cell]\n\n",
#else
/* 0 */  "\nUsage: %s  [options] [cell]\n\n",
#endif
/* 1 */  "interrupted due to signal: %s",
/* 2 */  "error in DMI function",
/* 3 */  "readcell: %s: cannot alloc core",
/* 4 */  "unknown error"
};

die (nr, s)
int   nr;
char *s;
{
    if (nr < 0 || nr > 4) nr = 4;
    if (nr) PE "%s: ", argv0);
    PE errlist[nr], s);
    if (nr) {
	dmQuit ();
	PE "\n%s: -- program aborted --\n", argv0);
    }
    exit (1);
}
