/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "to_db.cls"
/* <<cpre-2/8/82>> */ static char * SccsId = "@(#)to_db.cls 4.4 (TU-Delft) 10/21/92" ; 
#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 28 "to_db.cls"

#line 1 "./class.h"

#line 1 "./odb.h"

#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 30 "to_db.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 31 "to_db.cls"

#line 1 "./mkdbincl.h"

#line 27 "to_db.cls"
extern int doSimpleNet ; 
extern int genIntNet ; 
extern int externRequired ; 
extern int forbidFirstCapital ; 
extern int noWarnings ; 
extern int sls_errcnt ; 
extern int sls_errno ; 
extern int sls_nerr ; 
extern char * sls_errlist [ ] ; 

extern int yylineno ; 
extern char fn_incl [ ] ; 

extern int int_nbyte , int_maxnbyte ; 
extern int char_nbyte , char_maxnbyte ; 
extern int ntwdef_nbyte , ntwdef_maxnbyte ; 
extern int ntwinst_nbyte , ntwinst_maxnbyte ; 
extern int inst_struct_nbyte , inst_struct_maxnbyte ; 
extern int netelem_nbyte , netelem_maxnbyte ; 
extern int dict_nbyte , dict_maxnbyte ; 
extern int net_ref_nbyte , net_ref_maxnbyte ; 
extern int xelem_nbyte , xelem_maxnbyte ; 
extern int queue_nbyte , queue_maxnbyte ; 
extern int stack_nbyte , stack_maxnbyte ; 
#line 32 "to_db.cls"

extern Netelem * notconnected ; 

DM_STREAM * dsp_net ; 

int fill_lub_cnet ( ) ; 
int fill_lub_ref ( ) ; 
int fill_lub_inst ( ) ; 

int term_to_db ( q ) struct queue * q ; 

{ int * _that ; 
int i ; 
Link * pq ; 

for ( i = 0 , pq = ( struct link * ) ( _19queue_first_elem ( ( struct queue * ) q ) ) ; 
 i < _15queue_length ( ( struct queue * ) q ) ; 
 i ++ , pq = ( struct link * ) ( _20queue_next_elem ( ( struct queue * ) q , ( struct link * ) ( pq ) ) ) ) { 
switch ( pq -> type ) { 
case 0x01 : 
 term_to_db ( ( struct queue * ) pq ) ; 
break ; 

case 0x04 : 
 _16netelem_to_db ( ( struct netelem * ) ( ( struct netelem * ) pq ) ) ; 
break ; } } } /* term_to_db */ 
#line 62 "to_db.cls"
int inst_to_db ( inst ) struct ntwinst * inst ; 

{ int * _that ; 
 _13ntwinst_to_db ( ( struct ntwinst * ) inst ) ; } /* inst_to_db */ 


int net_to_db ( q ) struct queue * q ; 

{ int * _that ; 
int i , 
j ; 
Queue * pq ; 
Netelem * pnet ; 
NetReference * peqv ; 

if ( _17queue_empty ( ( struct queue * ) q ) ) { { _that = ( int * ) 
 q ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } goto _return 
; } 


if ( doSimpleNet ) { 
 outSimple ( q ) ; } 

else { 
for ( i = 0 , pnet = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) q ) ; 
 i < _15queue_length ( ( struct queue * ) q ) ; 
 i ++ , pnet = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) q , ( struct link * ) ( ( struct link * ) pnet ) ) ) { 

if ( pnet == notconnected ) 
continue ; 

strcpy ( cnet . net_name , pnet -> name ) ; 
 fill_lub_cnet ( & cnet , pnet -> xs ) ; 

 pq = ( struct queue * ) ( pnet -> eqv ) ; 
if ( pq ) { 

 cnet . net_neqv = _15queue_length ( ( struct queue * ) pq ) ; 
cnet . net_eqv = ( struct cir_net * ) calloc ( ( unsigned ) ( cnet . net_neqv ) , sizeof ( struct cir_net ) ) ; 

for ( j = 0 ; ! _17queue_empty ( ( struct queue * ) pq ) ; j ++ ) { 
 peqv = ( struct net_ref * ) _13queue_get ( ( struct queue * ) pq ) ; 
if ( peqv -> net == notconnected ) { { _that = ( int * ) 
 peqv ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } 
cnet . net_neqv -- ; 
j -- ; 
continue ; } 

strcpy ( cnet . net_eqv [ j ] . net_name , peqv -> net -> name ) ; 
 fill_lub_cnet ( & ( cnet . net_eqv [ j ] ) , peqv -> net_xs ) ; 
 fill_lub_ref ( & ( cnet . net_eqv [ j ] ) , peqv -> ref_xs ) ; 

if ( peqv -> inst ) 
{ 
strcpy ( cnet . net_eqv [ j ] . inst_name , 
 peqv -> inst -> inst_struct -> inst_name ) ; 
if ( peqv -> inst_xs ) 
 fill_lub_inst ( & cnet . net_eqv [ j ] , peqv -> inst_xs ) ; } { _that = ( int * ) 


 peqv ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } { _that = ( int * ) 

 pq ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } } 


dmPutDesignData ( dsp_net , CIR_NET ) ; 

if ( cnet . net_dim ) 
{ 
#line 133 "to_db.cls"
{ _that = ( int * ) 
 cnet . net_lower ; free ( _that ) ; } { _that = ( int * ) 
 cnet . net_upper ; free ( _that ) ; } 
cnet . net_dim = 0 ; } 


if ( cnet . inst_dim ) 
{ 
#line 143 "to_db.cls"
{ _that = ( int * ) 
 cnet . inst_lower ; free ( _that ) ; } { _that = ( int * ) 
 cnet . inst_upper ; free ( _that ) ; } 
cnet . inst_dim = 0 ; } 


if ( cnet . ref_dim ) 
{ 
#line 153 "to_db.cls"
{ _that = ( int * ) 
 cnet . ref_lower ; free ( _that ) ; } { _that = ( int * ) 
 cnet . ref_upper ; free ( _that ) ; } 
cnet . ref_dim = 0 ; } 


if ( cnet . net_neqv ) 
{ { _that = ( int * ) 
 cnet . net_eqv ; free ( _that ) ; } 
cnet . net_neqv = 0 ; } } 



while ( ! _17queue_empty ( ( struct queue * ) q ) ) { 
 pnet = ( struct netelem * ) _13queue_get ( ( struct queue * ) q ) ; { _that = ( int * ) 
 pnet ; _2netelem_delete ( ( struct netelem * ) _that ) ; free ( _that ) ; } } { _that = ( int * ) 

 q ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } } _return : return ; } /* net_to_db */ 



int fill_lub_cnet ( cnet , xs ) struct cir_net * cnet ; struct stack * xs ; 


{ int * _that ; 
int j ; 
int size = 0 ; 
char * * pxs ; 

if ( xs ) { 
 size = xs ? _21stack_limit ( ( struct stack * ) xs ) - _20stack_base ( ( struct stack * ) xs ) : 0 ; 
cnet -> net_dim = size ; 
#line 188 "to_db.cls"

cnet -> net_lower = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 
#line 193 "to_db.cls"

cnet -> net_upper = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 

for ( j = 0 , pxs = _20stack_base ( ( struct stack * ) xs ) ; pxs < _21stack_limit ( ( struct stack * ) xs ) ; j ++ , pxs ++ ) 
 cnet -> net_lower [ j ] = ( ( struct xelem * ) * pxs ) -> left_bound ; 


for ( j = 0 , pxs = _20stack_base ( ( struct stack * ) xs ) ; pxs < _21stack_limit ( ( struct stack * ) xs ) ; j ++ , pxs ++ ) 
 cnet -> net_upper [ j ] = ( ( struct xelem * ) * pxs ) -> right_bound ; } 

else 
cnet -> net_dim = 0 ; } /* fill_lub_cnet */ 

int fill_lub_ref ( cnet , xs ) struct cir_net * cnet ; struct stack * xs ; 


{ int * _that ; 
int j ; 
int size = 0 ; 
char * * pxs ; 

if ( xs ) { 
 size = xs ? _21stack_limit ( ( struct stack * ) xs ) - _20stack_base ( ( struct stack * ) xs ) : 0 ; 
cnet -> ref_dim = size ; 
#line 220 "to_db.cls"

cnet -> ref_lower = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 
#line 225 "to_db.cls"

cnet -> ref_upper = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 

for ( j = 0 , pxs = _20stack_base ( ( struct stack * ) xs ) ; pxs < _21stack_limit ( ( struct stack * ) xs ) ; j ++ , pxs ++ ) 
 cnet -> ref_lower [ j ] = ( ( struct xelem * ) * pxs ) -> left_bound ; 


for ( j = 0 , pxs = _20stack_base ( ( struct stack * ) xs ) ; pxs < _21stack_limit ( ( struct stack * ) xs ) ; j ++ , pxs ++ ) 
 cnet -> ref_upper [ j ] = ( ( struct xelem * ) * pxs ) -> right_bound ; } 

else 
cnet -> ref_dim = 0 ; } /* fill_lub_ref */ 

int fill_lub_inst ( cnet , xs ) struct cir_net * cnet ; struct stack * xs ; 


{ int * _that ; 
int j ; 
int size = 0 ; 
char * * pxs ; 

if ( xs ) { 
 size = xs ? _21stack_limit ( ( struct stack * ) xs ) - _20stack_base ( ( struct stack * ) xs ) : 0 ; 
cnet -> inst_dim = size ; 
#line 252 "to_db.cls"

cnet -> inst_lower = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 
#line 257 "to_db.cls"

cnet -> inst_upper = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 

for ( j = 0 , pxs = _20stack_base ( ( struct stack * ) xs ) ; pxs < _21stack_limit ( ( struct stack * ) xs ) ; j ++ , pxs ++ ) 
 cnet -> inst_lower [ j ] = ( ( struct xelem * ) * pxs ) -> left_bound ; 


for ( j = 0 , pxs = _20stack_base ( ( struct stack * ) xs ) ; pxs < _21stack_limit ( ( struct stack * ) xs ) ; j ++ , pxs ++ ) 
 cnet -> inst_upper [ j ] = ( ( struct xelem * ) * pxs ) -> right_bound ; } 

else 
cnet -> inst_dim = 0 ; } /* fill_lub_inst */ 
