/* SccsId = "@(#)queue.cls 4.2 (TU-Delft) 06/11/91" */
/**********************************************************

Name/Version      : sls_mkdb/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
void queue.new(char qtype)
{
	link.type =  qtype;
	tail = 0;
	n = 0;
#ifdef DMEM
    queue_nbyte += sizeof(class queue);
    queue_maxnbyte = queue_nbyte > queue_maxnbyte ? queue_nbyte:queue_maxnbyte;
#endif
}

void queue.delete()
{
#ifdef DMEM
    queue_nbyte -= sizeof(class queue);
#endif
}

void queue.reset(void)
{
	n = 0;
}

short queue.length(void)
{
	return n;
}


void queue.put(class link *p)
{
	if(n++) {
		p->next = tail->next;
		tail->next = p;
	}
	else
		p->next = p;
	tail = p;
}

class link *queue.get()
{
	class link *p;

	if(n--) {
		p = tail->next;
		tail->next = p->next;
   		return p;
	}
	else {
		n = 0;
		return 0;
	}
}

void queue.print() {
	class link *cur = tail->next;
	int i;

	printf("QueueB\n");
	printf("ptr: %x\tn: %d\ttail: %x\t", this, n, tail);

	if(tail)
	{
	    do {
		printf("[%d] ptr: %x\t*ptr: %x\n", i, cur, *cur);

		switch(cur -> type) {
	    	  case QueueType : printf("type: QueueType\n");
			  	((Queue *) cur)->print();
			  	break;
	    	  case NetType   : printf("type: NetType\n");
			  	((Netelem *) cur)->print();
			  	break;
	    	  case TermType   : printf("type: TermType\n");
			  	((Netelem *) cur)->print();
			  	break;
		}

		cur = cur->next;
		i++;
	    } while (cur != tail->next);
	}
	printf("QueueE\n");
}

int queue.empty(void)
{
	return (n==0);
}

class link *queue.access(int x)
{
	class link *p = tail->next;
	int i;

	for(i=0; i<x; i++)
		p = p->next;
	return p;
}

class link *queue.first_elem() {
	return tail->next;
}

class link *queue.next_elem(class link *cur_elem) {
	return cur_elem->next;
}

class link *queue.last_elem() {
	return tail;
}

void queue.append(class queue *pq)
{
	while(!pq -> empty())
	    put(pq -> get());
	delete pq;
}
