#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 2 "parse.y"
/* SccsId = "@(#)parse.y 4.16 (TU-Delft) 12/22/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.16

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 24-Nov-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "sys_incl.h"
#class
#include "class.h"
#include "mkdbdefs.h"
#include "mkdbincl.h"

extern char *yytext;
extern Netelem * notconnected;

int resynch();
char *strsav();
double cvt_atof();
Stack *stackcpy();
Stack *xstackcpy();
Network *init_ntw();
Network *read_ntw();
Network *dev_tab[];

int n_net_cnt;
int n_inst_cnt = 0;
int n_term_cnt;

Stack 	*xs, *pxs;
Stack 	*attr_s;
Queue	*pq;
Queue	*netq;
Queue	*pnetq;
extern Dictionary *ntw_dict;
extern Dictionary *sym_dict;
extern Dictionary *dff_dict;

extern char **globNets;
extern int globNets_cnt;

Xelem 	*pxelem;
Netelem	*pnet;
Network *ntw;
Network *pntw;
NetReference *pnref;
NetworkInstance *inst;

char name_buf[BUFSIZ];
char ntw_name[BUFSIZ];
char attr_buf[BUFSIZ];

int fflag = 0;       /* Function flag, set if instantiation is functional    */
int bifflag = 0;     /* Built In Function flag, set for nor, or, etc.        */
int invertbifflag;   /* Inverter built in function flag, set for inv         */
int trunc_warn = 0;  /* Set if name trunc. warning given, prevents multiple  */
int externspec = 0;  /* Set if network is specified as extern                */
char mc_type = 'i';  /* Indicates what type of model call is being parsed.
                        Used for write to sim_mc stream. */
int almost_eos = 0;  /* Indicates almost end of statement */

Network *curr_ntw;

#line 86 "parse.y"
typedef union {
	int   ival;
	char *sval;
	char cval;
	int *pival;
	float fval;
	double dval;
	} YYSTYPE;
#line 98 "y.tab.c"
#define INTEGER 257
#define IDENTIFIER 258
#define FLOAT 259
#define TERMINAL 260
#define NETWORK 261
#define EXTERNSPEC 262
#define NET 263
#define NENH 264
#define PENH 265
#define NDEP 266
#define RES 267
#define CAP 268
#define SEMICOLON 269
#define COLON 270
#define COMMA 271
#define PERIOD 272
#define LPS 273
#define RPS 274
#define LCB 275
#define RCB 276
#define LSB 277
#define RSB 278
#define T_WIDTH 279
#define T_LENGTH 280
#define T_RISE 281
#define T_FALL 282
#define ATSIGN 283
#define ASSIGN 284
#define DOTDOT 285
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,   47,   49,   47,   23,    5,    5,   48,    6,
    6,    7,   19,   19,   20,    8,    8,   50,   50,   51,
   51,   51,   51,   24,   26,   26,   27,   28,   29,   29,
   29,   29,   29,   30,   31,   32,   33,   25,   53,   34,
   22,   22,   22,   35,   35,   39,   40,   40,   40,   40,
   37,   38,   38,   36,   14,   14,   15,   15,   16,   16,
   16,   54,   17,   18,   52,    9,    9,   10,   10,   11,
   12,   12,   13,   13,    1,    1,    2,    2,    3,    3,
    4,   21,   43,   43,   41,   41,   41,   41,   42,   42,
   42,   44,   45,   46,   55,   55,   55,   55,   55,   55,
   55,   55,   55,   56,   56,   56,   56,
};
short yylen[] = {                                         2,
    1,    2,    3,    0,    4,    2,    3,    2,    3,    1,
    3,    2,    1,    3,    2,    1,    1,    0,    2,    2,
    2,    1,    1,    2,    1,    1,    4,    1,    1,    1,
    1,    1,    1,    2,    2,    2,    2,    2,    0,    3,
    1,    1,    1,    0,    2,    3,    1,    1,    1,    1,
    1,    1,    1,    1,    3,    3,    1,    3,    1,    1,
    0,    0,    4,    2,    4,    1,    1,    1,    3,    3,
    1,    3,    2,    1,    0,    3,    1,    3,    1,    1,
    3,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,
};
short yydefred[] = {                                      0,
    0,    4,    0,    0,    1,   92,   97,   95,   96,   98,
   99,  100,  101,  102,  103,    6,   83,   84,   93,    0,
    2,    0,    0,    0,   17,   16,    8,    0,   10,    0,
   18,    3,    5,    0,    7,  107,  104,  105,  106,    0,
   13,    0,   89,   90,   91,   94,    0,   11,    0,    0,
   15,   23,    0,   41,   42,   43,    0,    0,   22,    0,
    9,   39,   44,    0,    0,   25,   26,   28,   29,   30,
   31,   32,   33,   44,   19,    0,   14,   82,    0,   77,
   80,    0,    0,   54,   52,   53,   35,   36,   88,    0,
    0,   85,   86,   87,    0,    0,   21,    0,    0,   24,
    0,   20,    0,   76,    0,   74,    0,    0,    0,   68,
    0,   71,    0,    0,   38,   40,   47,   48,   49,   50,
   45,    0,   62,   60,    0,   57,   59,    0,   78,   81,
    0,   65,    0,    0,   73,   27,    0,    0,    0,   56,
   55,   70,   69,   72,   46,   51,    0,   58,   63,    0,
   64,
};
short yydgoto[] = {                                       3,
  123,   79,   80,   81,   23,   28,   29,   30,  108,  109,
  110,  111,  124,  100,  125,  126,  127,  149,   40,   41,
   85,   63,    4,   64,   90,   65,   66,   67,   68,   69,
   70,   71,   72,   73,   96,   86,  145,   87,  121,  122,
   91,  113,   74,   43,   44,   45,    5,   32,   20,   47,
   75,   76,   95,  138,   19,   46,
};
short yysindex[] = {                                   -160,
  -21,    0, -160, -241,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -195,
    0, -243, -229, -241,    0,    0,    0, -171,    0,  -37,
    0,    0,    0, -248,    0,    0,    0,    0,    0, -216,
    0, -157,    0,    0,    0,    0, -240,    0,  -37, -151,
    0,    0, -144,    0,    0,    0, -125, -125,    0,  -62,
    0,    0,    0, -133, -188,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -130,    0,    0, -264,    0,
    0, -128, -187,    0,    0,    0,    0,    0,    0, -116,
 -157,    0,    0,    0,  -21, -168,    0, -139, -139,    0,
 -168,    0, -151,    0, -151,    0, -113, -115, -112,    0,
 -109,    0, -157,  -88,    0,    0,    0,    0,    0,    0,
    0, -121,    0,    0, -215,    0,    0, -172,    0,    0,
 -141,    0, -127, -113,    0,    0, -125, -108, -139,    0,
    0,    0,    0,    0,    0,    0,  -37,    0,    0, -157,
    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -169,
    0, -206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -228, -191,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -234,    0,    0,    0,    0,    0,    0,    0,    0,
 -111,    0,    0,    0,    0, -138,    0, -164, -238,    0,
 -117,    0,    0,    0,    0,    0,    0,    0, -105,    0,
 -101,    0, -207,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -263,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -207,
    0,
};
short yygindex[] = {                                      0,
  -41,    0,   78,    0,  158,    0,  149,    0,    0,    0,
   51,   79,  -77,    0,   86,   48,    0,    0,    0,  139,
  -45,    0,  169,    0,    0,    0,    0,    0,   76,    0,
    0,    0,  102,    0,  133,    0,    0,  -54,    0,    0,
    0,  -30,  207,    1,    2,  151,  206,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 261
short yytable[] = {                                      42,
   51,   17,   18,   88,   82,  112,  103,   61,   75,   25,
   61,   26,   61,  104,   25,   52,   26,    6,   42,    7,
    8,    9,   53,   54,   55,   56,   57,   58,   59,  112,
   27,   22,   61,   75,   60,   61,   79,   61,   12,   13,
   14,   15,   62,   79,   98,   31,   98,   17,   18,  115,
   98,   98,   98,   98,   49,  139,  144,   82,  140,  130,
   92,   93,   75,   75,   75,    1,   75,   75,   75,  106,
    6,  135,    7,    8,    9,   36,   37,   38,   39,   10,
   11,   99,  146,   99,   98,  107,   99,   99,   99,   99,
   99,   12,   13,   14,   15,   17,   18,   34,  139,   12,
    1,    2,   35,  141,   12,   78,   61,   75,  151,   61,
  117,  118,  119,  120,   17,   18,  150,  106,    6,   50,
    7,    8,    9,   36,   37,   38,   39,   10,   11,  134,
   83,   78,  142,   84,   34,   97,   34,   50,  102,   12,
   13,   14,   15,  106,    6,  107,    7,    8,    9,   36,
   37,   38,   39,   10,   11,   37,  105,   37,  133,  114,
  132,  134,  137,  147,   75,   12,   13,   14,   15,    6,
   66,    7,    8,    9,   67,   54,   55,   56,   57,   58,
  129,   33,   48,  143,  128,  131,  148,   77,   24,  136,
   12,   13,   14,   15,   62,    6,  116,    7,    8,    9,
   36,   37,   38,   39,   10,   11,  101,   16,   21,   89,
   94,    0,    0,    0,    0,    0,   12,   13,   14,   15,
    6,    0,    7,    8,    9,   36,   37,   38,   39,   10,
   11,    0,    0,    0,    0,    0,    6,    0,    7,    8,
    9,   12,   13,   14,   15,   10,   11,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   12,   13,   14,
   15,
};
short yycheck[] = {                                      30,
   42,    1,    1,   58,   50,   83,  271,  271,  272,  258,
  274,  260,  276,  278,  258,  256,  260,  258,   49,  260,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  107,
  274,  273,  271,  272,  275,  276,  271,  276,  279,  280,
  281,  282,  283,  278,  273,  275,  275,   47,   47,   91,
  279,  280,  281,  282,  271,  271,  134,  103,  274,  105,
   60,   60,  269,  271,  271,  261,  274,  274,  276,  257,
  258,  113,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  273,  137,  275,  273,  273,  275,  279,  280,  281,
  282,  279,  280,  281,  282,   95,   95,  269,  271,  269,
  261,  262,  274,  276,  274,  257,  271,  272,  150,  274,
  279,  280,  281,  282,  114,  114,  147,  257,  258,  277,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  271,
  275,  257,  274,  259,  273,  269,  275,  277,  269,  279,
  280,  281,  282,  257,  258,  273,  260,  261,  262,  263,
  264,  265,  266,  267,  268,  273,  285,  275,  271,  276,
  276,  271,  284,  272,  276,  279,  280,  281,  282,  258,
  276,  260,  261,  262,  276,  264,  265,  266,  267,  268,
  103,   24,   34,  133,   99,  107,  139,   49,   20,  114,
  279,  280,  281,  282,  283,  258,   95,  260,  261,  262,
  263,  264,  265,  266,  267,  268,   74,    1,    3,  272,
   60,   -1,   -1,   -1,   -1,   -1,  279,  280,  281,  282,
  258,   -1,  260,  261,  262,  263,  264,  265,  266,  267,
  268,   -1,   -1,   -1,   -1,   -1,  258,   -1,  260,  261,
  262,  279,  280,  281,  282,  267,  268,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  280,  281,
  282,
};
#define YYFINAL 3
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 285
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"INTEGER","IDENTIFIER","FLOAT",
"TERMINAL","NETWORK","EXTERNSPEC","NET","NENH","PENH","NDEP","RES","CAP",
"SEMICOLON","COLON","COMMA","PERIOD","LPS","RPS","LCB","RCB","LSB","RSB",
"T_WIDTH","T_LENGTH","T_RISE","T_FALL","ATSIGN","ASSIGN","DOTDOT",
};
char *yyrule[] = {
"$accept : sls_descr",
"sls_descr : netw_descr",
"sls_descr : sls_descr netw_descr",
"netw_descr : netw_head decl_part netw_body",
"$$1 :",
"netw_descr : EXTERNSPEC $$1 netw_head decl_part",
"netw_head : NETWORK ntw_name",
"decl_part : LPS type_decl_list RPS",
"decl_part : LPS RPS",
"netw_body : LCB stmt_list RCB",
"type_decl_list : type_decl",
"type_decl_list : type_decl_list SEMICOLON type_decl",
"type_decl : type terminal_list",
"terminal_list : terminal",
"terminal_list : terminal_list COMMA terminal",
"terminal : net_name sb_index_list",
"type : TERMINAL",
"type : IDENTIFIER",
"stmt_list :",
"stmt_list : stmt_list statement",
"statement : net_stmt SEMICOLON",
"statement : inst_stmt SEMICOLON",
"statement : SEMICOLON",
"statement : error",
"inst_stmt : inst_def type_con_list",
"inst_def : named_instance",
"inst_def : unnamed_instance",
"named_instance : LCB inst_struct RCB instance",
"unnamed_instance : instance",
"instance : tor_instance",
"instance : res_instance",
"instance : cap_instance",
"instance : ntw_instance",
"instance : fun_instance",
"tor_instance : ttype attr_list",
"res_instance : RES real",
"cap_instance : CAP real",
"ntw_instance : ntw_name attr_list",
"inst_struct : i_name sb_index_list",
"$$2 :",
"fun_instance : ATSIGN $$2 ntw_instance",
"ttype : NENH",
"ttype : PENH",
"ttype : NDEP",
"attr_list :",
"attr_list : attr_list attribute",
"attribute : attr_spec ASSIGN attr_val",
"attr_spec : T_WIDTH",
"attr_spec : T_LENGTH",
"attr_spec : T_RISE",
"attr_spec : T_FALL",
"attr_val : real",
"real : i_val",
"real : f_val",
"f_val : FLOAT",
"type_con_list : LCB connect_list RCB",
"type_con_list : LPS connect_list RPS",
"connect_list : connect",
"connect_list : connect_list COMMA connect",
"connect : internal_ref",
"connect : net_ref",
"connect :",
"$$3 :",
"internal_ref : sb_index_list $$3 PERIOD inst_net_ref",
"inst_net_ref : net_name sb_index_list",
"net_stmt : NET LCB type_net_list RCB",
"type_net_list : net_grp_list",
"type_net_list : net_list",
"net_grp_list : net_grp",
"net_grp_list : net_grp_list COMMA net_grp",
"net_grp : LPS net_list RPS",
"net_list : net_ref",
"net_list : net_list COMMA net_ref",
"net_ref : net_name sb_index_list",
"net_ref : INTEGER",
"sb_index_list :",
"sb_index_list : LSB index_list RSB",
"index_list : index",
"index_list : index_list COMMA index",
"index : i_val",
"index : range",
"range : i_val DOTDOT i_val",
"i_val : INTEGER",
"ntw_name : ident",
"ntw_name : keyw1",
"i_name : ident",
"i_name : keyw1",
"i_name : keyw2",
"i_name : PERIOD",
"net_name : ident",
"net_name : keyw1",
"net_name : keyw2",
"ident : IDENTIFIER",
"keyw1 : keyword1",
"keyw2 : keyword2",
"keyword1 : NETWORK",
"keyword1 : EXTERNSPEC",
"keyword1 : TERMINAL",
"keyword1 : RES",
"keyword1 : CAP",
"keyword1 : T_WIDTH",
"keyword1 : T_LENGTH",
"keyword1 : T_RISE",
"keyword1 : T_FALL",
"keyword2 : NENH",
"keyword2 : PENH",
"keyword2 : NDEP",
"keyword2 : NET",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 1159 "parse.y"

void yyerror(s)
char * s;
{
    sls_error(yylineno,SYNTAX,NULL);
}

int resynch(c)
char c;
{
    int c1,
	newline = 0;

    if (almost_eos) {
	fprintf (stderr, "   \";\" expected");
	if (yytext) fprintf (stderr, ", found \"%s\"\n", yytext);
	else fprintf (stderr, "\n");
	while((c1 = Input()) != c && c1 != 0);
    }
    else {
	fprintf(stderr," \"");
	if (yytext)
	   fprintf(stderr, "%s", yytext);
	while((c1 = Input()) != c && c1 != 0)
	{
	    if(!(newline = (newline || ((c1=='\n')?1:0))))
	    fprintf(stderr,"%c",c1);
	}

	fprintf(stderr,"\"\n");
    }

    return(c1);
}

void stackfree(xs, type)
Stack *xs;
int type;
{
    char *p;

    if(xs)
    {
         while(! xs->empty())
         {
	     p = xs -> pop();
	     switch (type) {
	         case XELEM:
		     if(p)
		         delete (Xelem *) p;
		     break;
	         case STRING:
		     if(p)
		     {
#ifdef DMEM
    char_nbyte -=  strlen(p) + 1;
#endif
		         delete p;
		     }
		     break;
	     }
         }
    }
}

Netelem *findterm(inst, term_name)
NetworkInstance *inst;
char *term_name;
{
    Queue *termq;
    int termq_len;
    Netelem *pterm;
    int i;

    if (inst)
	termq = inst -> ntw -> termq;
    else
	termq = ntw -> termq;

    termq_len = termq -> length ();

    for(i=0, pterm = (Netelem *) termq -> first_elem ();
	i < termq_len;
	i++, pterm = (Netelem *) termq -> next_elem ((Link *) pterm))
    {
	if(strcmp(pterm->name, term_name) == 0)
	    return(pterm);
    }

    return(0);
}

int gettermcnt (netw)
Network *netw;
{
    Queue *termq;
    int termq_len;
    Netelem *pterm;
    int i;
    int term_cnt;

    termq = netw -> termq;
    termq_len = termq -> length ();
    term_cnt = 0;

    for(i=0, pterm = (Netelem *) termq -> first_elem ();
	i < termq_len;
	i++, pterm = (Netelem *) termq -> next_elem ((Link *) pterm))
    {
	term_cnt += getxslength (pterm -> xs);
    }

    return (term_cnt);
}

void prxs(xs)
Stack *xs;
{

    int i;
    int xs_len = xs -> length();

    fprintf(stderr,"stack: %x, length: %d\n", xs, xs_len);
    if(xs)
    {
        for(i=0; i<xs_len; i++)
        {
	    pxelem = (Xelem *) xs -> access(i);
	    fprintf(stderr,"lb: %d, rb: %d\n", pxelem -> left_bound,
					       pxelem -> right_bound);
        }
    }
}
#line 572 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 3:
#line 129 "parse.y"
{
			if(end_ntw(yyvsp[-2].ival, externspec, COMPLETE))
			{
			    sls_error(yylineno, sls_errno, NULL); 
			    die();
			}
		}
break;
case 4:
#line 137 "parse.y"
{
			externspec = 1;
		}
break;
case 5:
#line 141 "parse.y"
{
			void finalCheckDbTerm ();

			finalCheckDbTerm ();

			if(end_ntw(yyvsp[-1].ival, externspec, COMPLETE))
			{
			    sls_error(yylineno, sls_errno, NULL); 
			    die();
			}

			externspec = 0;
		}
break;
case 6:
#line 157 "parse.y"
{
			if (!externspec && forbidFirstCapital && yyvsp[0].sval 
			    && yyvsp[0].sval[0] >= 'A' && yyvsp[0].sval[0] <= 'Z') {
			    sls_errno = USENONCAP;
			    sls_error (yylineno, sls_errno, yyvsp[0].sval);
			    die ();
			}

		     /* If network is not already referenced, initialze and set
		        it up. If not extern, dmCheckOut called and term, mc,
			and net streams opened. */

			if(ntw = (Network *)init_ntw(yyvsp[0].sval, externspec)) {
			    curr_ntw = ntw;
			    yyval.ival = (int) ntw;
			}
			else
			{
			    /* Network already referenced */
			    sls_errno = NTWAREF;
			    sls_error(yylineno, sls_errno, yyvsp[0].sval);
			    die();
			}
		}
break;
case 7:
#line 184 "parse.y"
{
			int i;

			yyval.ival = 1;

			if (yyvsp[-1].ival && globNets_cnt > 0) {
			    pnetq = NULL;
			    for (i = 0; i < globNets_cnt; i++) {

				if (externspec && !isDefGlobalNet (globNets[i]))
				    continue;

				if (!(pnet = sym_dict->fetch(globNets[i]))) {

                                    /* add net 'globNets[i]' as an extra
				       terminal to the current network */

                                    if (!pnetq) {
					pnetq = new Queue (QueueType);
				    }

				    xs -> reset ();
				    pnet = new Netelem (globNets[i], 
							stackcpy((Stack *) xs),
							TermType);
				    pnet -> type = pnet -> type | N_GLOBADDED;
				    pnetq -> put ((Link *) pnet);
				    pnet = new Netelem (globNets[i], 
							stackcpy((Stack *) xs),
							TermType);
				    pnet -> type = pnet -> type | N_GLOBADDED;
				    sym_dict->store (pnet->name, (char *) pnet);
				    ntw -> netq -> put ((Link *) pnet);
				}
				else if (pnet -> xs) {
				    sls_errno = ILLRANGE;
				    sls_error (yylineno, sls_errno, 
							 globNets[i]);
				    yyval.ival = 0;
				    break;
				}
			    }

			    if (pnetq) {
				if(ntw->termq)
				    ntw ->termq->append((Queue *) pnetq);
				else
				    ntw -> termq = (Queue *) pnetq;
			    }
			}

			if (yyval.ival) {
			    if (yyvsp[-1].ival && !externspec)
				term_to_db((Queue *) yyvsp[-1].ival);
			    yyval.ival = yyvsp[-1].ival;
			}
		}
break;
case 8:
#line 242 "parse.y"
{
			int i;

			yyval.ival = 0;
			pnetq = NULL;
			for (i = 0; i < globNets_cnt; i++) {

			    if (externspec && !isDefGlobalNet (globNets[i]))
				continue;

			    /* add net 'globNets[i]' as an extra
			       terminal to the current network */

			    if (!pnetq) {
				pnetq = new Queue (QueueType);
			    }

			    xs -> reset ();
			    pnet = new Netelem (globNets[i], 
						stackcpy((Stack *) xs),
						TermType);
			    pnet -> type = pnet -> type | N_GLOBADDED;
			    pnetq -> put ((Link *) pnet);
			    pnet = new Netelem (globNets[i], 
						stackcpy((Stack *) xs),
						TermType);
			    pnet -> type = pnet -> type | N_GLOBADDED;
			    sym_dict->store (pnet->name, (char *) pnet);
			    ntw -> netq -> put ((Link *) pnet);
			    yyval.ival = 1;
			}

			if (pnetq) {
			    if (ntw -> termq)
				ntw -> termq -> append((Queue *) pnetq);
			    else
				ntw -> termq = (Queue *) pnetq;
			}

			if (yyval.ival) {
			    if (!externspec)
				term_to_db ((Queue *) (ntw -> termq));
			    yyval.ival = (int)(ntw -> termq);
			}
		}
break;
case 10:
#line 293 "parse.y"
{
			yyval.ival = yyvsp[0].ival;
		}
break;
case 11:
#line 297 "parse.y"
{
			yyval.ival = yyvsp[-2].ival;
		}
break;
case 12:
#line 303 "parse.y"
{
			if(yyvsp[-1].ival == TermType && yyvsp[0].ival)
			{
			    if(ntw->termq)
				ntw->termq->append((Queue *) yyvsp[0].ival);
			    else
			    	ntw -> termq = (Queue *) yyvsp[0].ival;
			    yyval.ival = (int) yyvsp[0].ival;
			}
			else if (yyvsp[-1].ival == 0 || yyvsp[0].ival == 0) {
			    yyval.ival = 0;
			}
			else {
			    yyval.ival = (int) yyvsp[0].ival;
			}
		}
break;
case 13:
#line 322 "parse.y"
{
			if (yyvsp[0].ival) {
			    pnetq = new Queue (QueueType);
			    pnetq->put((Link *) yyvsp[0].ival);
			    yyval.ival = (int) pnetq;
			}
                        else
			    yyval.ival = 0;
		}
break;
case 14:
#line 332 "parse.y"
{
			if (yyvsp[-2].ival && yyvsp[0].ival)
			    ((Queue *) yyvsp[-2].ival)->put((Link *) yyvsp[0].ival);
			yyval.ival = yyvsp[-2].ival;
		}
break;
case 15:
#line 340 "parse.y"
{
			if(sym_dict->fetch(yyvsp[-1].sval))
			{
			    /* terminal already defined */
			    sls_errno = TERMADEF;
			    sls_error(yylineno, sls_errno, yyvsp[-1].sval);
			    yyval.ival = 0;
			}
			else
			{
			    pnet = new Netelem (yyvsp[-1].sval, stackcpy((Stack *) yyvsp[0].ival),
				       		TermType);
			    if (externspec && checkDbTerm (pnet) != 0)
				yyval.ival = 0;
			    else {
				yyval.ival = (int) pnet;
				pnet = new Netelem (yyvsp[-1].sval, stackcpy((Stack *) yyvsp[0].ival),
						    TermType);
				sym_dict->store(pnet->name, (char *) pnet);
				ntw -> netq -> put ((Link *) pnet);
			    }
			}
		}
break;
case 16:
#line 366 "parse.y"
{
			yyval.ival = TermType;
		}
break;
case 17:
#line 370 "parse.y"
{
			/* unknown type. Occurs if keyword terminal omitted. */
			sls_errno = UNKTYPE;
			sls_error(yylineno, sls_errno, yyvsp[0].sval);
			yyval.ival = 0;
		}
break;
case 20:
#line 383 "parse.y"
{ 
			almost_eos = 0; 
		}
break;
case 21:
#line 387 "parse.y"
{
			if(inst)
			{
			    if(ntw->mcq == NULL)
				ntw -> mcq = new Queue (QueueType);
			    
			    ntw -> mcq -> put ((Link *) inst);
			    inst_to_db((NetworkInstance *) inst);
			}

			almost_eos = 0;
		}
break;
case 23:
#line 401 "parse.y"
{
		    	if(resynch(';'))
			{
		    	    yyerrok;
		    	    yyclearin;
			}
			else
			    die();
		}
break;
case 24:
#line 413 "parse.y"
{
		    int net_cnt;
		    int inst_cnt;
		    Stack * inst_xs;
		    inst = (NetworkInstance *) yyvsp[-1].ival;

		    if (yyvsp[-1].ival && yyvsp[0].ival) {
                        if (((Link *) yyvsp[-1].ival) -> type == FunctionType) {
				mc_type = 'f';   /* model call is functional */
			        sprintf(attr_buf, "f");
			        attr_s -> push (strsav(attr_buf));
		        }

		        if (bifflag)
			{
				mc_type = 'b'; /* model call - built in func */
			        inst_xs = inst -> inst_struct -> inst_construct;
			        net_cnt = getnetcnt((Queue *) yyvsp[0].ival);
			        if(inst_xs)
			        {
				    inst_cnt = getxslength(inst_xs);
				    net_cnt = net_cnt / inst_cnt;
			        }
			    	
				pnet = 
			       (Netelem *) inst -> ntw -> termq -> first_elem();
				pxs = new Stack (1);
				pxelem = new Xelem (0, net_cnt - 2);
				pxs -> push ((char *) pxelem);
				pnet -> xs = pxs;

/*
				pxs = (Stack *) pnet -> xs;
				pxelem = (Xelem *) *pxs -> base();
				pxelem -> right_bound = net_cnt - 2;
*/
			        sprintf(attr_buf, "n=%d", net_cnt - 1);
			        attr_s -> push (strsav(attr_buf));
				bifflag = 0;

				if (invertbifflag) {
				    if (net_cnt < 2)
					sls_error(yylineno, ATERM_LT_FTERM,
						  NULL);
				    else if (net_cnt > 2)
					sls_error(yylineno, ATERM_GT_FTERM,
						  NULL);
				}
			}

                        /* set n_*_cnt for possibly adding extra global nets 
			   in match_net() */

                        if (((Link *) yyvsp[-1].ival) -> type == NetworkType) {
			    inst_xs = inst -> inst_struct -> inst_construct;
			    if(inst_xs)
				n_inst_cnt = getxslength (inst_xs);
			    else
				n_inst_cnt = 1;
			    n_net_cnt = getnetcnt((Queue *) yyvsp[0].ival);
			    n_term_cnt = gettermcnt (inst -> ntw);
			    if (n_net_cnt % n_inst_cnt != 0)
				n_inst_cnt = 0;
		        }
			else
			    n_inst_cnt = 0;

			inst -> ntw_attr = stackcpy(attr_s);
			if(inst_net_eqv(inst, (Queue *) yyvsp[0].ival))
			{
			    sls_error(yylineno, sls_errno, NULL);
			}
			n_inst_cnt = 0;
		    }

		    almost_eos = 1;
		}
break;
case 25:
#line 493 "parse.y"
{
			yyval.ival = yyvsp[0].ival;
		}
break;
case 26:
#line 497 "parse.y"
{
			yyval.ival = yyvsp[0].ival;
		}
break;
case 27:
#line 503 "parse.y"
{
			if (yyvsp[-2].ival && yyvsp[0].ival) {
			    inst = (NetworkInstance *) yyvsp[0].ival;

			    inst->inst_struct = (InstanceStruct *) yyvsp[-2].ival;
			    sym_dict->store(inst->inst_struct->inst_name,
					    (char *) inst);
			    yyval.ival = yyvsp[0].ival;
			}
			else
			    yyval.ival = 0;
		}
break;
case 28:
#line 518 "parse.y"
{
			inst = (NetworkInstance *) yyvsp[0].ival;

			inst->inst_struct = new InstanceStruct 
				((char *) ntw->genname(InstanceType), NULL);
			sym_dict->store(inst->inst_struct->inst_name,
					(char *) inst);
			yyval.ival = yyvsp[0].ival;
		}
break;
case 29:
#line 530 "parse.y"
{
			((Link *) yyvsp[0].ival) -> type = TransistorType;
			yyval.ival = yyvsp[0].ival;
		}
break;
case 30:
#line 535 "parse.y"
{
			((Link *) yyvsp[0].ival) -> type = ResistorType;
			yyval.ival = yyvsp[0].ival;
		}
break;
case 31:
#line 540 "parse.y"
{
			((Link *) yyvsp[0].ival) -> type = CapacitorType;
			yyval.ival = yyvsp[0].ival;
		}
break;
case 32:
#line 545 "parse.y"
{
		        mc_type = 'c';            /* model call is a circuit */
			((Link *) yyvsp[0].ival) -> type = NetworkType;
			yyval.ival = yyvsp[0].ival;
		}
break;
case 33:
#line 551 "parse.y"
{
			((Link *) yyvsp[0].ival) -> type = FunctionType;
			yyval.ival = yyvsp[0].ival;
		}
break;
case 34:
#line 558 "parse.y"
{
			yyval.ival = (int) new NetworkInstance((Network *)yyvsp[-1].ival, NULL);
		}
break;
case 35:
#line 564 "parse.y"
{
			attr_s -> reset();
			sprintf(attr_buf,"v=%g", yyvsp[0].dval);
 			attr_s -> push(strsav(attr_buf));

			yyval.ival = (int) new NetworkInstance(dev_tab[DevRes], NULL);
		}
break;
case 36:
#line 574 "parse.y"
{
			attr_s -> reset();
			sprintf(attr_buf,"v=%g", yyvsp[0].dval);
 			attr_s -> push(strsav(attr_buf));

			yyval.ival = (int) new NetworkInstance(dev_tab[DevCap], NULL);
		}
break;
case 37:
#line 584 "parse.y"
{
		    if(fflag)
		    {
			if(!(pntw = is_bifunc(yyvsp[-1].sval)))
			{
		            if ((pntw = (Network *) dff_dict -> fetch(yyvsp[-1].sval)) 
			         == NULL)
			    {
		                if ((pntw = read_dff (yyvsp[-1].sval)) == NULL) 
			        {
			            sls_errno = UNKFUNC;
			            sls_error(yylineno, sls_errno, yyvsp[-1].sval);
			            die();
			        }
		            }
			}
			else {
		            bifflag = 1;

			    if (yyvsp[-1].sval[0] == 'i' 
				&& strcmp (yyvsp[-1].sval, "invert") == 0)
				invertbifflag = 1;
			    else
				invertbifflag = 0;
			}
		    }
		    else
		    {
		        if ((pntw = (Network *) ntw_dict -> fetch(yyvsp[-1].sval)) == NULL)
			{
			    if (externRequired) {
			        sls_errno = NOEXTERNDEF;
			        sls_error(yylineno, sls_errno, yyvsp[-1].sval);
			        die();
			    }

		            if ((pntw = read_ntw (yyvsp[-1].sval)) == NULL) 
			    {
			        sls_errno = UNKNETWORK;
			        sls_error(yylineno, sls_errno, yyvsp[-1].sval);
			        die();
			    }
			}
		    }

		    yyval.ival = (int) new NetworkInstance(pntw, NULL);
		}
break;
case 38:
#line 634 "parse.y"
{
			if(sym_dict->fetch(yyvsp[-1].sval))
			{
			    sls_errno = INSTADEF;
			    sls_error(yylineno, sls_errno, yyvsp[-1].sval);
			    yyval.ival = 0;
			}
			else
			{
			    yyval.ival = (int) new InstanceStruct (strsav(yyvsp[-1].sval),
				           stackcpy((Stack *) yyvsp[0].ival));
			}
		}
break;
case 39:
#line 650 "parse.y"
{
			fflag++;
		}
break;
case 40:
#line 654 "parse.y"
{
			fflag = 0;
			yyval.ival = yyvsp[0].ival;
		}
break;
case 41:
#line 661 "parse.y"
{
			yyval.ival = (int) dev_tab[DevNenh];
		}
break;
case 42:
#line 665 "parse.y"
{
			yyval.ival = (int) dev_tab[DevPenh];
		}
break;
case 43:
#line 669 "parse.y"
{
			yyval.ival = (int) dev_tab[DevNdep];
		}
break;
case 44:
#line 675 "parse.y"
{
			attr_s->reset();
			yyval.ival = (int) attr_s;
		}
break;
case 45:
#line 680 "parse.y"
{
			((Stack *) yyvsp[-1].ival) -> push((char *) strsav(yyvsp[0].sval) );
			yyval.ival = yyvsp[-1].ival;
		}
break;
case 46:
#line 687 "parse.y"
{
		    	sprintf(attr_buf, "%s=%g", yyvsp[-2].sval, yyvsp[0].dval);
			yyval.sval = attr_buf;
		}
break;
case 47:
#line 694 "parse.y"
{
			yyval.sval = "w";
		}
break;
case 48:
#line 698 "parse.y"
{
			yyval.sval = "l";
		}
break;
case 49:
#line 702 "parse.y"
{
			yyval.sval = "tr";
		}
break;
case 50:
#line 706 "parse.y"
{
			yyval.sval = "tf";
		}
break;
case 51:
#line 712 "parse.y"
{
			yyval.dval = yyvsp[0].dval;
		}
break;
case 52:
#line 718 "parse.y"
{
			yyval.dval = (double) yyvsp[0].ival;
		}
break;
case 53:
#line 722 "parse.y"
{
			yyval.dval = yyvsp[0].dval;
		}
break;
case 54:
#line 728 "parse.y"
{
			yyval.dval = cvt_atof(yyvsp[0].sval);
		}
break;
case 55:
#line 734 "parse.y"
{
			((Queue *) yyvsp[-1].ival)->type = PmQueue;
			yyval.ival = yyvsp[-1].ival;
		}
break;
case 56:
#line 739 "parse.y"
{
			((Queue *) yyvsp[-1].ival)->type = ImQueue;
			yyval.ival = yyvsp[-1].ival;
		}
break;
case 57:
#line 746 "parse.y"
{
		    pnetq = new Queue (QueueType);

		    if(yyvsp[0].ival)
		    {
			pnetq->put((Link *) yyvsp[0].ival);
		    }

		    yyval.ival = (int) pnetq;
		}
break;
case 58:
#line 757 "parse.y"
{
		    if(yyvsp[0].ival)
		    {
			((Queue *) yyvsp[-2].ival)->put((Link *) yyvsp[0].ival);
		    }

		    yyval.ival = yyvsp[-2].ival;
		}
break;
case 59:
#line 768 "parse.y"
{
			yyval.ival = yyvsp[0].ival;
		}
break;
case 60:
#line 772 "parse.y"
{
			yyval.ival = yyvsp[0].ival;
		}
break;
case 61:
#line 776 "parse.y"
{
			yyval.ival = (int) new NetReference (notconnected, NULL);
		}
break;
case 62:
#line 782 "parse.y"
{
		    pxs = stackcpy((Stack *) yyvsp[0].ival);
		}
break;
case 63:
#line 786 "parse.y"
{
		    int inst_xs_len = 0;
		    int net_xs_len = 0;
		    int net_len = 0;

		    pnref = (NetReference *) yyvsp[0].ival;

		    if(pnref)
		    {
			pnref -> inst = inst;
			if(chk_bounds(pnref->inst->inst_struct->inst_construct, pxs))
			{
			    sls_errno = ILLRANGE;
			    sls_error(yylineno, sls_errno,
			    	      "range not within declared bounds");
			    yyval.ival = 0;
			}
			else
			{
			    pnref -> inst_xs = pxs;

		            inst_xs_len = getxslength(pxs);
		            net_xs_len = getxslength(pnref->net_xs);
			    net_len = (inst_xs_len ? inst_xs_len : 1) *
			    	      (net_xs_len ? net_xs_len : 1);
			    xs -> reset();
			    if(net_len)
			    {
			        pxelem = new Xelem (0, net_len - 1);
			        xs -> push ((char *) pxelem);
			    }

			    pxs = stackcpy(xs);
			    pnref -> ref_xs = stackcpy(xs);

			    pnet = new Netelem ((char *) ntw->genname(NetType),
					        pxs, NetType);

			    sym_dict -> store(pnet -> name, (char *) pnet);
			    ntw -> netq -> put((Link*) pnet);

			    yyval.ival = (int) new NetReference (pnet,
							 stackcpy(pnet->xs)); 
                            if (doSimpleNet) {
				joinSimple (pnet, pnref -> ref_xs,
					    pnref -> inst, pnref -> inst_xs,
					    pnref -> net, pnref -> net_xs);
				delete pnref;
			    }
			    else {
				if(!pnet->eqv)
				    pnet->eqv = new Queue (QueueType);

				pnet -> eqv -> put ((Link*) pnref);
			    }
			}
		    }
		    else
			yyval.ival = 0;
		}
break;
case 64:
#line 849 "parse.y"
{
		    Netelem * pterm;
		    Stack *pxs1;

		    pxs1 = stackcpy((Stack *) yyvsp[0].ival);

		    if(pterm = findterm(inst, yyvsp[-1].sval))
		    {
			if(chk_bounds(pterm->xs, pxs1))
			{
			    sls_errno = ILLRANGE;
			    sls_error(yylineno, sls_errno,
			    	      "range not within declared bounds");
			    yyval.ival = 0;
			}
			else
			    yyval.ival = (int) new NetReference (pterm, pxs1);
		    }
		    else
		    {
			sls_errno = UNKTERM;
			sls_error(yylineno, sls_errno, yyvsp[-1].sval);
			yyval.ival = 0;
		    }
		}
break;
case 65:
#line 877 "parse.y"
{
		    if(yyvsp[-1].ival)
		    {
			if(neteqv((Queue *) yyvsp[-1].ival))
			{
			    sls_error(yylineno, sls_errno, NULL);
			}
	 	    }

		    almost_eos = 1;
		}
break;
case 66:
#line 891 "parse.y"
{
		    yyval.ival = yyvsp[0].ival;
		}
break;
case 67:
#line 895 "parse.y"
{
		    yyval.ival = yyvsp[0].ival;
		}
break;
case 68:
#line 901 "parse.y"
{
		    if(yyvsp[0].ival)
		    {
			pnetq = new Queue (QueueType);
			pnetq->put((Link *) yyvsp[0].ival);
			yyval.ival = (int) pnetq;
		    }
		    else
			yyval.ival = yyvsp[0].ival;
		}
break;
case 69:
#line 912 "parse.y"
{
		    if(yyvsp[-2].ival && yyvsp[0].ival)
		    {
			((Queue *) yyvsp[-2].ival)->put((Link *) yyvsp[0].ival);
			yyval.ival = yyvsp[-2].ival;
		    }
		    else
			yyval.ival = 0;
		}
break;
case 70:
#line 924 "parse.y"
{
			yyval.ival = yyvsp[-1].ival;
		}
break;
case 71:
#line 930 "parse.y"
{
		    if(yyvsp[0].ival)
		    {
			pnetq = new Queue (QueueType);
			pnetq->put((Link *) yyvsp[0].ival);
			yyval.ival = (int) pnetq;
		    }
		    else
			yyval.ival = yyvsp[0].ival;
		}
break;
case 72:
#line 941 "parse.y"
{
		    if(yyvsp[-2].ival && yyvsp[0].ival)
		    {
			    ((Queue *) yyvsp[-2].ival)->put((Link *) yyvsp[0].ival);
			    yyval.ival = yyvsp[-2].ival;
		    }
		    else
			yyval.ival = 0;
		}
break;
case 73:
#line 953 "parse.y"
{
		    /* If net not defined: Define the net */
			pxs = stackcpy((Stack *) yyvsp[0].ival);

			if((pnet = sym_dict->fetch(yyvsp[-1].sval)) == NULL)
			{
			        pnet = new Netelem (yyvsp[-1].sval, pxs, NetType);
			        sym_dict->store(pnet->name, (char *) pnet);
				ntw -> netq -> put((Link*) pnet);
				yyval.ival = (int) new NetReference (pnet, pxs);
			}
			else
			{
			    if(chk_bounds(pnet->xs, pxs))
			    {
			        sls_errno = ILLRANGE;
			        sls_error(yylineno, sls_errno,
				          "range not within declared bounds");
			        yyval.ival = 0;
			    }
			    else	
				yyval.ival = (int) new NetReference (pnet, pxs);
			}
		}
break;
case 74:
#line 978 "parse.y"
{
			/* If net yet not defined, a new net will be defined
			   and stored in the symbol table and put in the
			   network net queue. Additionally a net reference
			   is defined and returned by this action	    */

			if((pnet = sym_dict->fetch(yyvsp[0].sval)) == NULL)
			{
			    pnet = new Netelem (yyvsp[0].sval, NULL, NetType);
			    sym_dict->store(pnet->name, (char *) pnet);
			    ntw -> netq -> put((Link*) pnet);
			}
			yyval.ival = (int) new NetReference (pnet,NULL);
		}
break;
case 75:
#line 996 "parse.y"
{
			xs->reset();
			yyval.ival = (int)xs;
		}
break;
case 76:
#line 1001 "parse.y"
{
		    	yyval.ival = yyvsp[-1].ival;
		}
break;
case 77:
#line 1007 "parse.y"
{
			xs->reset();
			if(xs->push((char *)yyvsp[0].ival) == STACK_OVERFLOW) {
			    fprintf(stderr,"xstack overflow\n");
		            die ();
		        }
			yyval.ival = (int)xs;
			
		}
break;
case 78:
#line 1017 "parse.y"
{
			if(((Stack *)yyvsp[-2].ival)->push((char *)yyvsp[0].ival) == STACK_OVERFLOW) {
			    fprintf(stderr,"xstack overflow\n");
		            die ();
		        }
			yyval.ival = yyvsp[-2].ival;
		}
break;
case 79:
#line 1027 "parse.y"
{
			yyval.ival = (int) new Xelem (yyvsp[0].ival, yyvsp[0].ival);
		}
break;
case 80:
#line 1031 "parse.y"
{
		    	yyval.ival = yyvsp[0].ival;
		}
break;
case 81:
#line 1037 "parse.y"
{
			if(yyvsp[-2].ival > yyvsp[0].ival)
			{
			    sls_errno = ILLRANGE;
			    sls_error(yylineno, sls_errno, 
				      "left bound > right bound");
			    yyval.ival = (int) new Xelem (yyvsp[0].ival, yyvsp[-2].ival);
			}
			else
			    yyval.ival = (int) new Xelem (yyvsp[-2].ival, yyvsp[0].ival);
		}
break;
case 82:
#line 1051 "parse.y"
{
		    yyval.ival = atoi(yyvsp[0].sval);
		}
break;
case 83:
#line 1057 "parse.y"
{
			strcpy(ntw_name, yyvsp[0].sval);
			yyval.sval = ntw_name;
		}
break;
case 84:
#line 1062 "parse.y"
{
			strcpy(ntw_name, yyvsp[0].sval);
			yyval.sval = ntw_name;
		}
break;
case 88:
#line 1072 "parse.y"
{
			yyval.sval = ntw->genname(InstanceType);
		}
break;
case 89:
#line 1078 "parse.y"
{
			strcpy(ntw_name, yyvsp[0].sval);
			yyval.sval = ntw_name;
		}
break;
case 90:
#line 1083 "parse.y"
{
			strcpy(ntw_name, yyvsp[0].sval);
			yyval.sval = ntw_name;
		}
break;
case 91:
#line 1088 "parse.y"
{
			strcpy(ntw_name, yyvsp[0].sval);
			yyval.sval = ntw_name;
		}
break;
case 92:
#line 1095 "parse.y"
{
			strcpy (name_buf, yyvsp[0].sval);

			if (dmTestname (name_buf) == 1) {
			    if (!trunc_warn && !noWarnings) {
			        fprintf (stderr, 
			        "Warning: name(s) truncated to %d characters\n",
			        DM_MAXNAME);
			        trunc_warn = 1;
			    }
			}
			yyval.sval = name_buf;
		}
break;
case 93:
#line 1111 "parse.y"
{
			strcpy (name_buf, yytext);

			if (dmTestname (name_buf) == 1) {
			    if (!trunc_warn && !noWarnings) {
			        fprintf (stderr, 
			        "Warning: name(s) truncated to %d characters\n",
			        DM_MAXNAME);
			        trunc_warn = 1;
			    }
			}
			yyval.sval = name_buf;
		}
break;
case 94:
#line 1127 "parse.y"
{
			strcpy (name_buf, yytext);

			if (dmTestname (name_buf) == 1) {
			    if (!trunc_warn && !noWarnings) {
			        fprintf (stderr, 
			        "Warning: name(s) truncated to %d characters\n",
			        DM_MAXNAME);
			        trunc_warn = 1;
			    }
			}
			yyval.sval = name_buf;
		}
break;
#line 1786 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
