/* SccsId = "@(#)ntwdefs.cls 4.4 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/

extern char mc_type;
extern int cirflag;

void ntwdef.new(char *name) {
    ntw_name = (char *)strsav(name);
    inst_gen_cnt = 0;
    net_gen_cnt = 0;
#ifdef DMEM
    ntwdef_nbyte += sizeof(class ntwdef);
    ntwdef_maxnbyte = ntwdef_nbyte > ntwdef_maxnbyte ? ntwdef_nbyte :
						       ntwdef_maxnbyte;
#endif
}

void ntwdef.delete() {
#ifdef DMEM
    ntwdef_nbyte -= sizeof(class ntwdef);
#endif
}

char *ntwdef.genname(char tname) {
    char name[20];
	
    switch(tname)
    {
	case InstanceType: sprintf(name, "_I%x", inst_gen_cnt);
    			   inst_gen_cnt++;
			   break;

	case NetType: sprintf(name, "_N%x", net_gen_cnt);
    		      net_gen_cnt++;
		      break;
    }
    return((char *)strsav(name));
}

void ntwinst.new(Network *pntw, Stack *attr) {
    link.type = InstanceType;
    ntw = pntw;
    ntw_attr = attr;
#ifdef DMEM
    ntwinst_nbyte += sizeof(class ntwinst);
    ntwinst_maxnbyte = ntwinst_nbyte > ntwinst_maxnbyte ? ntwinst_nbyte :
							  ntwinst_maxnbyte;
#endif
}

void ntwinst.delete() {
    stackfree(ntw_attr, STRING);
    if(ntw_attr)
        delete ntw_attr;
    delete inst_struct;
#ifdef DMEM
    ntwinst_nbyte -= sizeof(class ntwinst);
#endif
}

void ntwinst.to_db() {
	Stack *pattr_s = ntw_attr;
	Stack *pinst_s = inst_struct->inst_construct;
	char **pxs;
	char **pattr;
	char attr_buf[BUFSIZ];
	char *ps = attr_buf;
	int i;
	int size = pinst_s ? pinst_s -> limit() - pinst_s->base() : 0;
	char *new_name;

	strcpy(cmc.cell_name, ntw -> ntw_name);
	strcpy(cmc.inst_name, inst_struct->inst_name);
	if (ntw -> local)
	    cmc.imported = LOCAL;
	else
	    cmc.imported = IMPORTED;

	if(pattr_s)
	{
	    for(i=0, pattr=pattr_s->base(); pattr<pattr_s->limit(); i++,pattr++)
	    {
		strcpy(ps, *pattr);
		ps += strlen(*pattr);
		*ps++ = ';';
	    }

	    *--ps = 0;

	    cmc.inst_attribute = attr_buf;
	}
	else
	    cmc.inst_attribute = 0;

	cmc.inst_dim = size;

	if(pinst_s)
	{
	
	    /* lower _boundaries */
	    cmc.inst_lower = new long [size];
#ifdef DMEM
    int_nbyte += size * sizeof(long);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte : int_maxnbyte;
#endif
	    for(i=0, pxs=pinst_s->base(); pxs < pinst_s->limit(); i++, pxs++)
		cmc.inst_lower[i] = ((Xelem *) *pxs)->left_bound;

	    /* upper _boundaries */
	    cmc.inst_upper = new long [size];
#ifdef DMEM
    int_nbyte += size * sizeof(long);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte : int_maxnbyte;
#endif
	    for(i=0, pxs=pinst_s->base(); pxs < pinst_s->limit(); i++, pxs++)
		cmc.inst_upper[i] = ((Xelem *) *pxs)->right_bound;
	}

	dmPutDesignData(dsp_mc, CIR_MC);

#ifdef FUNCVIEW
        if (!cirflag) {
	    strcpy(csim.cell_name,cmc.cell_name);
	    strcpy(csim.inst_name,cmc.inst_name);
	    csim.flag = mc_type;
	    mc_type = 'i';            /* reset to default value for next use */
	    dmPutDesignData(dsp_sim_mc, CIR_SIM);
	}
#endif

	if(cmc.inst_dim)
	{
#ifdef DMEM
    int_nbyte -= 2 * size * sizeof(long);
#endif
	    delete cmc.inst_lower;
	    delete cmc.inst_upper;
	}
}

void instancestruct.new(char *name, Stack *construct) {
    inst_name = name;
    inst_construct = construct;
#ifdef DMEM
    inst_struct_nbyte += sizeof(class instancestruct);
    inst_struct_maxnbyte = inst_struct_nbyte > inst_struct_maxnbyte ?
			   inst_struct_nbyte : inst_struct_maxnbyte;
#endif
}

void instancestruct.delete() {
    delete inst_name;
    stackfree(inst_construct, XELEM);
    if(inst_construct)
        delete inst_construct;
#ifdef DMEM
    inst_struct_nbyte -= sizeof(class instancestruct);
#endif
}
