/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "neteqv.cls"
/* <<cpre-2/8/82>> */ static char * SccsId = "@(#)neteqv.cls 4.10 (TU-Delft) 10/21/92" ; 
#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 28 "neteqv.cls"

#line 1 "./class.h"

#line 1 "./odb.h"

#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 30 "neteqv.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 31 "neteqv.cls"

#line 1 "./mkdbincl.h"

#line 27 "neteqv.cls"
extern int doSimpleNet ; 
extern int genIntNet ; 
extern int externRequired ; 
extern int forbidFirstCapital ; 
extern int noWarnings ; 
extern int sls_errcnt ; 
extern int sls_errno ; 
extern int sls_nerr ; 
extern char * sls_errlist [ ] ; 

extern int yylineno ; 
extern char fn_incl [ ] ; 

extern int int_nbyte , int_maxnbyte ; 
extern int char_nbyte , char_maxnbyte ; 
extern int ntwdef_nbyte , ntwdef_maxnbyte ; 
extern int ntwinst_nbyte , ntwinst_maxnbyte ; 
extern int inst_struct_nbyte , inst_struct_maxnbyte ; 
extern int netelem_nbyte , netelem_maxnbyte ; 
extern int dict_nbyte , dict_maxnbyte ; 
extern int net_ref_nbyte , net_ref_maxnbyte ; 
extern int xelem_nbyte , xelem_maxnbyte ; 
extern int queue_nbyte , queue_maxnbyte ; 
extern int stack_nbyte , stack_maxnbyte ; 
#line 32 "neteqv.cls"

extern Dictionary * ntw_dict ; 
extern Dictionary * sym_dict ; 
extern Network * ntw ; 

extern Netelem * notconnected ; 

extern int n_net_cnt ; 
extern int n_inst_cnt ; 
extern int n_term_cnt ; 

Stack * stackcpy ( ) ; 
Stack * xstackcpy ( ) ; 
int net_eqv ( ) ; 

Stack * flatten_xs ( xs ) struct stack * xs ; 

{ int * _that ; struct stack * _result ; 
int i , j , k , l , n ; 
int * m , * x , * y ; 
int * lb , * rb ; 
char * * px ; 
Xelem * pxelem ; 
Stack * newxs , * pxs ; 

 n = _22stack_length ( ( struct stack * ) xs ) ; 
x = ( int * ) calloc ( ( unsigned ) ( n ) , sizeof ( int ) ) ; 
y = ( int * ) calloc ( ( unsigned ) ( n ) , sizeof ( int ) ) ; 
m = ( int * ) calloc ( ( unsigned ) ( n ) , sizeof ( int ) ) ; 
lb = ( int * ) calloc ( ( unsigned ) ( n ) , sizeof ( int ) ) ; 
rb = ( int * ) calloc ( ( unsigned ) ( n ) , sizeof ( int ) ) ; 


for ( i = 0 , px = _20stack_base ( ( struct stack * ) xs ) ; px != _21stack_limit ( ( struct stack * ) xs ) ; i ++ , px ++ ) { 
 lb [ i ] = ( ( struct xelem * ) * px ) -> left_bound ; 
 rb [ i ] = ( ( struct xelem * ) * px ) -> right_bound ; 
y [ i ] = rb [ i ] - lb [ i ] + 1 ; } 


m [ n - 1 ] = 1 ; 
for ( i = n - 2 ; i >= 0 ; i -- ) 
m [ i ] = y [ i + 1 ] * m [ i + 1 ] ; 
k = y [ 0 ] * m [ 0 ] ; 

 newxs = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( k ) ) , ( struct stack * ) _that ) ; 

for ( i = 1 ; i <= k ; i ++ ) { 

 pxs = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( n ) ) , ( struct stack * ) _that ) ; 

for ( l = 0 ; l < n ; l ++ ) { 
 pxelem = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) ( * ( x + l ) + lb [ l ] ) , ( short ) ( * ( x + l ) + lb [ l ] ) ) , ( struct xelem * ) _that ) ; 
 _14stack_push ( ( struct stack * ) pxs , ( char * ) ( ( char * ) pxelem ) ) ; } 


 _14stack_push ( ( struct stack * ) newxs , ( char * ) ( ( char * ) pxs ) ) ; 

for ( j = n - 1 ; j >= 0 ; j -- ) { 
if ( ( i % m [ j ] ) == 0 ) { 
( * ( x + j ) ) ++ ; 
* ( x + j ) %= y [ j ] ; } } } { _that = ( int * ) 
#line 97 "neteqv.cls"
 x ; free ( _that ) ; } { _that = ( int * ) 
 y ; free ( _that ) ; } { _that = ( int * ) 
 m ; free ( _that ) ; } { _that = ( int * ) 
 lb ; free ( _that ) ; } { _that = ( int * ) 
 rb ; free ( _that ) ; } { _result = 

 ( newxs ) ; goto _return ; } _return : return _result ; } /* flatten_xs */ 


int flatten ( netref , flat_inst , flat_net , que ) struct net_ref * netref ; int flat_inst ; int flat_net ; struct queue * que ; 
#line 111 "neteqv.cls"
{ int * _that ; int _result ; 
int i , j ; 
int inst_xs_len ; 
int net_xs_len ; 
NetReference * newnref ; 
Stack * inst_xs ; 
Stack * net_xs ; 

if ( flat_inst && ( inst_xs = ( struct stack * ) ( netref -> inst_xs ) ) ) { 
 inst_xs = ( struct stack * ) ( flatten_xs ( inst_xs ) ) ; 
 inst_xs_len = _22stack_length ( ( struct stack * ) inst_xs ) ; } 

else 
inst_xs_len = 0 ; 

if ( flat_net && ( net_xs = ( struct stack * ) ( netref -> net_xs ) ) ) { 
 net_xs = ( struct stack * ) ( flatten_xs ( net_xs ) ) ; 
 net_xs_len = _22stack_length ( ( struct stack * ) net_xs ) ; } 

else 
net_xs_len = 0 ; 

if ( inst_xs_len > 0 ) { 
for ( i = 0 ; i < inst_xs_len ; i ++ ) { 
if ( net_xs_len > 0 ) { 
for ( j = 0 ; j < net_xs_len ; j ++ ) { 

 newnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( netref -> net ) , ( struct stack * ) ( ( struct stack * ) _16stack_access ( ( struct stack * ) net_xs , ( int ) ( j ) ) ) ) , ( struct net_ref * ) _that ) ; 
 newnref -> inst = ( struct ntwinst * ) ( netref -> inst ) ; 
 newnref -> inst_xs = ( struct stack * ) _16stack_access ( ( struct stack * ) inst_xs , ( int ) ( i ) ) ; 
 _14queue_put ( ( struct queue * ) que , ( struct link * ) ( ( struct link * ) newnref ) ) ; } } 


else { 
 newnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( netref -> net ) , ( struct stack * ) ( netref -> net_xs ) ) , ( struct net_ref * ) _that ) ; 
 newnref -> inst = ( struct ntwinst * ) ( netref -> inst ) ; 
 newnref -> inst_xs = ( struct stack * ) _16stack_access ( ( struct stack * ) inst_xs , ( int ) ( i ) ) ; 
 _14queue_put ( ( struct queue * ) que , ( struct link * ) ( ( struct link * ) newnref ) ) ; } } } 



else { 
if ( net_xs_len > 0 ) { 
for ( j = 0 ; j < net_xs_len ; j ++ ) { 

 newnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( netref -> net ) , ( struct stack * ) ( ( struct stack * ) _16stack_access ( ( struct stack * ) net_xs , ( int ) ( j ) ) ) ) , ( struct net_ref * ) _that ) ; 
 newnref -> inst = ( struct ntwinst * ) ( netref -> inst ) ; 
 newnref -> inst_xs = ( struct stack * ) ( netref -> inst_xs ) ; 
 _14queue_put ( ( struct queue * ) que , ( struct link * ) ( ( struct link * ) newnref ) ) ; } } 


else { 
 newnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( netref -> net ) , ( struct stack * ) ( netref -> net_xs ) ) , ( struct net_ref * ) _that ) ; 
 newnref -> inst = ( struct ntwinst * ) ( netref -> inst ) ; 
 newnref -> inst_xs = ( struct stack * ) ( netref -> inst_xs ) ; 
 _14queue_put ( ( struct queue * ) que , ( struct link * ) ( ( struct link * ) newnref ) ) ; } } { _that = ( int * ) 



 netref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } 

if ( inst_xs_len == 0 ) 
inst_xs_len = 1 ; 
if ( net_xs_len == 0 ) 
net_xs_len = 1 ; { _result = 

 ( inst_xs_len * net_xs_len ) ; goto _return ; } _return : return _result ; } /* flatten */ 


int match_net ( pdstq , psrcq , nettype ) struct queue * * pdstq ; struct queue * * psrcq ; char nettype ; 



{ int * _that ; int _result ; 
int i , j ; 
int j_max ; 
int inst_xs_len ; 
int net_xs_len ; 
Xelem * px ; 
Stack * net_xs ; 
Stack * ref_xs ; 
Stack * inst_xs ; 
Netelem * pnet ; 
NetReference * pnref ; 
NetReference * psrc ; 
NetReference * pdst ; 
Queue * srcq ; 
Queue * dstq ; 
Queue * new_srcq ; 
Queue * new_dstq ; 
char * isGlobalNet ( ) ; 

int src_len ; 
int dst_len ; 
int newsrc_cnt = 0 ; 
int newdst_cnt = 0 ; 
int src_action ; 
int dst_action ; 
int flag ; 

 srcq = ( struct queue * ) ( * psrcq ) ; 
 dstq = ( struct queue * ) ( * pdstq ) ; 

 new_srcq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
 new_dstq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
 * psrcq = ( struct queue * ) ( new_srcq ) ; 
 * pdstq = ( struct queue * ) ( new_dstq ) ; 

 psrc = ( struct net_ref * ) _13queue_get ( ( struct queue * ) srcq ) ; 
 pdst = ( struct net_ref * ) _13queue_get ( ( struct queue * ) dstq ) ; 

if ( 
 ( psrc == 0 || isGlobalNet ( psrc -> net -> name ) ) && pdst -> net == notconnected && _15queue_length ( ( struct queue * ) dstq ) == 0 ) { 
 pdst = ( struct net_ref * ) ( 0 ) ; 
n_net_cnt = 0 ; } 


 src_len = getnetlength ( psrc ) ; 
 dst_len = getnetlength ( pdst ) ; 

if ( psrc == 0 && pdst ) { _result = 
 ( 1 ) ; goto _return ; } 
else if ( psrc && ! isGlobalNet ( psrc -> net -> name ) && pdst == 0 ) { _result = 
 ( - 1 ) ; goto _return ; } 

while ( psrc || pdst ) { 

if ( n_inst_cnt > 0 ) { 

flag = 0 ; 

while ( ( nettype == 'i' 
&& ( ( newsrc_cnt % n_term_cnt ) >= ( n_net_cnt / n_inst_cnt ) ) ) 
|| ( ( nettype == 'p' 
&& ( newsrc_cnt + 1 ) > n_net_cnt ) ) ) { 

if ( 
 psrc && psrc -> net_xs == 0 && isGlobalNet ( psrc -> net -> name ) ) { 



flag = 1 ; 

if ( nettype == 'p' && pdst ) { 

 _14queue_put ( ( struct queue * ) new_dstq , ( struct link * ) ( ( struct link * ) pdst ) ) ; 
newdst_cnt += dst_len ; 
 pdst = ( struct net_ref * ) _13queue_get ( ( struct queue * ) dstq ) ; 
 dst_len = getnetlength ( pdst ) ; } 


 pnet = ( struct netelem * ) ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( psrc -> net -> name ) ) ) ; 
if ( ! pnet ) { 
 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( psrc -> net -> name ) , ( struct stack * ) 0 , ( char ) ( 0x05 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } 

else if ( pnet -> xs ) { 
sls_errno = 7 ; { _result = 
 ( - 999 ) ; goto _return ; } } 

if ( psrc -> inst_xs ) 
 j_max = getxslength ( psrc -> inst_xs ) ; 
else 
j_max = 1 ; 
for ( j = 0 ; j < j_max ; j ++ ) { 
 pnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pnet ) , ( struct stack * ) 0 ) , ( struct net_ref * ) _that ) ; 
 _14queue_put ( ( struct queue * ) new_dstq , ( struct link * ) ( ( struct link * ) pnref ) ) ; 
newdst_cnt ++ ; } 


if ( j_max > 1 ) { 
 src_len = flatten ( psrc , 1 , 1 , new_srcq ) ; 
newsrc_cnt += src_len ; } 

else { 
 _14queue_put ( ( struct queue * ) new_srcq , ( struct link * ) ( ( struct link * ) psrc ) ) ; 
newsrc_cnt += src_len ; } 

 psrc = ( struct net_ref * ) _13queue_get ( ( struct queue * ) srcq ) ; 
 src_len = getnetlength ( psrc ) ; } 

else 
break ; } 


if ( 
#line 304 "neteqv.cls"
 flag == 0 && ( nettype == 'i' || nettype == 'p' ) && newdst_cnt == newsrc_cnt && psrc && psrc -> net_xs == 0 && isGlobalNet ( psrc -> net -> name ) && pdst && ! isGlobalNet ( pdst -> net -> name ) && pdst -> net != notconnected ) { 
#line 310 "neteqv.cls"
 pnet = ( struct netelem * ) ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( psrc -> net -> name ) ) ) ; 
if ( ! pnet ) { 
 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( psrc -> net -> name ) , ( struct stack * ) 0 , ( char ) ( 0x05 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } 

else if ( pnet -> xs ) { 
sls_errno = 7 ; { _result = 
 ( - 999 ) ; goto _return ; } } 


if ( psrc -> inst_xs ) 
 j_max = getxslength ( psrc -> inst_xs ) ; 
else 
j_max = 1 ; 
for ( j = 0 ; j < j_max ; j ++ ) { 
 pnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pnet ) , ( struct stack * ) 0 ) , ( struct net_ref * ) _that ) ; 
 _14queue_put ( ( struct queue * ) new_dstq , ( struct link * ) ( ( struct link * ) pnref ) ) ; 

if ( ! pdst -> net_xs ) { 
 pnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pdst -> net ) , ( struct stack * ) 0 ) , ( struct net_ref * ) _that ) ; 
 _14queue_put ( ( struct queue * ) new_srcq , ( struct link * ) ( ( struct link * ) pnref ) ) ; } } 


if ( pdst -> net_xs ) { 
 pnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pdst -> net ) , ( struct stack * ) ( pdst -> net_xs ) ) , ( struct net_ref * ) _that ) ; 
 j = flatten ( pnref , 1 , 1 , new_srcq ) ; } } } 
#line 341 "neteqv.cls"
if ( ( psrc == 0 && pdst == 0 ) ) 
break ; 

if ( newsrc_cnt > newdst_cnt ) { 
src_action = 0 ; } 

else if ( newsrc_cnt == newdst_cnt && src_len == dst_len ) { 
src_action = 1 ; } 

else { 
src_action = 2 ; } 


if ( newdst_cnt > newsrc_cnt ) { 
dst_action = 0 ; } 

else if ( newdst_cnt == newsrc_cnt && dst_len == src_len ) { 
dst_action = 1 ; } 

else { 
dst_action = 2 ; } 


if ( src_action == 1 ) { 
if ( psrc == 0 ) { _result = 
 ( 1 ) ; goto _return ; } 
 _14queue_put ( ( struct queue * ) new_srcq , ( struct link * ) ( ( struct link * ) psrc ) ) ; 
newsrc_cnt += src_len ; 
 psrc = ( struct net_ref * ) _13queue_get ( ( struct queue * ) srcq ) ; 
 src_len = getnetlength ( psrc ) ; } 

else if ( src_action == 2 ) { 
if ( psrc == 0 ) { _result = 
 ( 1 ) ; goto _return ; } 

 src_len = flatten ( psrc , 1 , 1 , new_srcq ) ; 

newsrc_cnt += src_len ; 
 psrc = ( struct net_ref * ) _13queue_get ( ( struct queue * ) srcq ) ; 
 src_len = getnetlength ( psrc ) ; } 


if ( dst_action == 1 ) { 
if ( pdst == 0 ) { _result = 
 ( - 1 ) ; goto _return ; } 
 _14queue_put ( ( struct queue * ) new_dstq , ( struct link * ) ( ( struct link * ) pdst ) ) ; 
newdst_cnt += dst_len ; 
 pdst = ( struct net_ref * ) _13queue_get ( ( struct queue * ) dstq ) ; 
 dst_len = getnetlength ( pdst ) ; } 

else if ( dst_action == 2 ) { 
if ( pdst == 0 ) { _result = 
 ( - 1 ) ; goto _return ; } 

 dst_len = flatten ( pdst , 1 , 1 , new_dstq ) ; 

newdst_cnt += dst_len ; 
 pdst = ( struct net_ref * ) _13queue_get ( ( struct queue * ) dstq ) ; 
 dst_len = getnetlength ( pdst ) ; } } { _that = ( int * ) 



 srcq ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } { _that = ( int * ) 
 dstq ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } 

if ( newsrc_cnt < newdst_cnt ) { _result = 
 ( 1 ) ; goto _return ; } 
else if ( newsrc_cnt > newdst_cnt ) { _result = 
 ( - 1 ) ; goto _return ; } 
else { _result = 
 ( 0 ) ; goto _return ; } _return : return _result ; } /* match_net */ 


int getnetlength ( net ) struct net_ref * net ; 

{ int * _that ; int _result ; 
int n ; 
int i ; 
int lb ; 
int rb ; 
int len = 1 ; 

if ( ! net ) { { _result = 
 ( 0 ) ; goto _return ; } } 


if ( net -> net_xs ) 
 n = _22stack_length ( ( struct stack * ) net -> net_xs ) ; 
else 
n = 0 ; 

for ( i = 0 ; i < n ; i ++ ) { 
 lb = ( ( struct xelem * ) _16stack_access ( ( struct stack * ) net -> net_xs , ( int ) ( i ) ) ) -> left_bound ; 
 rb = ( ( struct xelem * ) _16stack_access ( ( struct stack * ) net -> net_xs , ( int ) ( i ) ) ) -> right_bound ; 
len = len * ( 1 + abs ( lb - rb ) ) ; } 


if ( net -> inst_xs ) 
 n = _22stack_length ( ( struct stack * ) net -> inst_xs ) ; 
else 
n = 0 ; 

for ( i = 0 ; i < n ; i ++ ) { 
 lb = ( ( struct xelem * ) _16stack_access ( ( struct stack * ) net -> inst_xs , ( int ) ( i ) ) ) -> left_bound ; 
 rb = ( ( struct xelem * ) _16stack_access ( ( struct stack * ) net -> inst_xs , ( int ) ( i ) ) ) -> right_bound ; 
len = len * ( 1 + abs ( lb - rb ) ) ; } { _result = 


 ( len ) ; goto _return ; } _return : return _result ; } /* getnetlength */ chk_bounds 


( xs1 , xs2 ) struct stack * xs1 ; struct stack * xs2 ; 

{ int * _that ; int _result ; 
int i ; 
int xs1_dim , 
xs2_dim ; 
int lb1 , 
rb1 ; 
int lb2 , 
rb2 ; 
char * * px1 ; 
char * * px2 ; 

if ( xs1 && xs2 ) { 

 xs1_dim = _22stack_length ( ( struct stack * ) xs1 ) ; 
 xs2_dim = _22stack_length ( ( struct stack * ) xs2 ) ; 
if ( xs1_dim != xs2_dim ) { { _result = 
 1 ; goto _return ; } } 

for ( i = 0 , px1 = _20stack_base ( ( struct stack * ) xs1 ) , px2 = _20stack_base ( ( struct stack * ) xs2 ) ; 
i < xs1_dim ; i ++ , px1 ++ , px2 ++ ) { 
 lb1 = ( ( struct xelem * ) * px1 ) -> left_bound ; 
 rb1 = ( ( struct xelem * ) * px1 ) -> right_bound ; 
 lb2 = ( ( struct xelem * ) * px2 ) -> left_bound ; 
 rb2 = ( ( struct xelem * ) * px2 ) -> right_bound ; 
if ( lb1 > lb2 || rb1 < rb2 ) { _result = 

 1 ; goto _return ; } } } 


else { 
if ( xs1 || xs2 ) { _result = 
 1 ; goto _return ; } } { _result = 


 0 ; goto _return ; } _return : return _result ; } /* chk_bounds */ 


int inst_net_eqv ( inst , cons ) struct ntwinst * inst ; struct queue * cons ; 


{ int * _that ; int _result ; 
int i ; 
Network * pntw ; 
Netelem * pterm ; 
Netelem * pnet ; 
Netelem * peqv ; 
NetReference * nref1 , * nref2 ; 

switch ( ( ( struct link * ) cons ) -> type ) { 
case 0x08 : { _result = 
 ( pm_net_eqv ( inst , cons ) ) ; goto _return ; } 
case 0x09 : { _result = 
 ( im_net_eqv ( inst , cons ) ) ; goto _return ; } 
default : 
fprintf ( stderr , "inst_net_eqv: Illegal Queue type %x\n" , 
 ( ( struct link * ) cons ) -> type ) ; 
die ( ) ; } _return : return _result ; } /* inst_net_eqv */ 



int pm_net_eqv ( inst , netq ) struct ntwinst * inst ; struct queue * netq ; 


{ int * _that ; int _result ; 
int i , j , k ; 
Stack * pxs ; 
Stack * net_xs ; 
Netelem * pterm ; 
NetReference * net_ref , * term_ref ; 

Queue * term_refq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
Stack * inst_xs = stackcpy ( inst -> inst_struct -> inst_construct ) ; 
Queue * termq = inst -> ntw -> termq ; 
int termq_len = _15queue_length ( ( struct queue * ) termq ) ; 

for ( j = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
j < termq_len ; 
 j ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) { 

if ( ( net_xs = ( struct stack * ) ( stackcpy ( pterm -> xs ) ) ) ) { 
 net_xs = ( struct stack * ) ( flatten_xs ( net_xs ) ) ; 
 k = _22stack_length ( ( struct stack * ) net_xs ) ; } 

else 
k = 1 ; 

for ( i = 0 ; i < k ; i ++ ) { 

 pxs = ( struct stack * ) ( net_xs ? ( struct stack * ) _16stack_access ( ( struct stack * ) net_xs , ( int ) ( i ) ) : 0 ) ; 
 term_ref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pterm ) , ( struct stack * ) ( pxs ) ) , ( struct net_ref * ) _that ) ; 
 term_ref -> inst = ( struct ntwinst * ) ( inst ) ; 
 term_ref -> inst_xs = ( struct stack * ) ( inst_xs ) ; 
 _14queue_put ( ( struct queue * ) term_refq , ( struct link * ) ( ( struct link * ) term_ref ) ) ; } } 



 k = match_net ( & netq , & term_refq , 'p' ) ; 

if ( k < - 900 ) { _result = 
 ( 1 ) ; goto _return ; } 

if ( k > 0 ) 
{ 
sls_errno = 3 ; { _result = 
 ( 1 ) ; goto _return ; } } 

else if ( k < 0 ) 
{ 
sls_errno = 2 ; { _result = 
 ( 1 ) ; goto _return ; } } 

else 
 net_eqv ( netq , term_refq ) ; { _result = 

 ( 0 ) ; goto _return ; } _return : return _result ; } /* pm_net_eqv */ 


int im_net_eqv ( inst , netq ) struct ntwinst * inst ; struct queue * netq ; 


{ int * _that ; int _result ; 
int i , j , k ; 
Stack * pxs ; 
Netelem * pterm ; 
NetReference * net_ref , * term_ref ; 

Queue * termq = inst -> ntw -> termq ; 
Stack * inst_xs = inst -> inst_struct -> inst_construct ; 
Queue * term_refq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
int termq_len = _15queue_length ( ( struct queue * ) termq ) ; 

if ( inst_xs ) { 
 inst_xs = ( struct stack * ) ( flatten_xs ( inst_xs ) ) ; 
 k = _22stack_length ( ( struct stack * ) inst_xs ) ; } 

else 
k = 1 ; 

for ( i = 0 ; i < k ; i ++ ) { 
 pxs = ( struct stack * ) ( inst_xs ? ( struct stack * ) _16stack_access ( ( struct stack * ) inst_xs , ( int ) ( i ) ) : 0 ) ; 
for ( j = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
j < termq_len ; 
 j ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) { 

 term_ref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pterm ) , ( struct stack * ) ( stackcpy ( pterm -> xs ) ) ) , ( struct net_ref * ) _that ) ; 
 term_ref -> inst = ( struct ntwinst * ) ( inst ) ; 
 term_ref -> inst_xs = ( struct stack * ) ( pxs ) ; 
 _14queue_put ( ( struct queue * ) term_refq , ( struct link * ) ( ( struct link * ) term_ref ) ) ; } } 



 k = match_net ( & netq , & term_refq , 'i' ) ; 

if ( k < - 900 ) { _result = 
 ( 1 ) ; goto _return ; } 

if ( k > 0 ) 
{ 
sls_errno = 3 ; { _result = 
 ( 1 ) ; goto _return ; } } 

else if ( k < 0 ) 
{ 
sls_errno = 2 ; { _result = 
 ( 1 ) ; goto _return ; } } 

else 
 net_eqv ( netq , term_refq ) ; { _result = 

 ( 0 ) ; goto _return ; } _return : return _result ; } /* im_net_eqv */ 


int net_eqv ( dst , src ) struct queue * dst ; struct queue * src ; 


{ int * _that ; 
Netelem * pnet ; 
NetReference * dst_ref , * src_ref ; 

while ( ! _17queue_empty ( ( struct queue * ) dst ) ) 
{ 
 dst_ref = ( struct net_ref * ) _13queue_get ( ( struct queue * ) dst ) ; 
 src_ref = ( struct net_ref * ) _13queue_get ( ( struct queue * ) src ) ; 
 src_ref -> ref_xs = ( struct stack * ) ( stackcpy ( dst_ref -> net_xs ) ) ; 

 pnet = ( struct netelem * ) ( dst_ref -> net ) ; 
if ( doSimpleNet ) { 


 joinSimple ( pnet , src_ref -> ref_xs , src_ref -> inst , src_ref -> inst_xs , src_ref -> net , src_ref -> net_xs ) ; { _that = ( int * ) 
 src_ref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } 

else { 
if ( pnet -> eqv == 0 ) 
 pnet -> eqv = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

 _14queue_put ( ( struct queue * ) pnet -> eqv , ( struct link * ) ( src_ref ) ) ; } { _that = ( int * ) 

 dst_ref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } { _that = ( int * ) 

 dst ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } { _that = ( int * ) 
 src ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } } /* net_eqv */ 


int neteqv ( netq ) struct queue * netq ; 

{ int * _that ; int _result ; 
int i , k ; 
Link * psrc ; 
Stack * dst_net_xs ; 
Stack * src_net_xs ; 
Netelem * dst_net ; 
NetReference * pnref ; 
NetReference * src_ref , * dst_ref ; 

Link * pdst = _13queue_get ( ( struct queue * ) netq ) ; 

switch ( pdst -> type ) 
{ 
case 0x01 : 
while ( ! _17queue_empty ( ( struct queue * ) netq ) ) { 
 psrc = ( struct link * ) ( _13queue_get ( ( struct queue * ) netq ) ) ; 

 k = match_net ( ( ( struct queue * * ) & pdst ) , ( ( struct queue * * ) & psrc ) , '\0' ) ; 

if ( k < - 900 ) { _result = 
 ( 1 ) ; goto _return ; } 

if ( k > 0 ) 
{ 
sls_errno = 5 ; { _result = 
 ( 1 ) ; goto _return ; } } 

else if ( k < 0 ) 
{ 
sls_errno = 4 ; { _result = 
 ( 1 ) ; goto _return ; } } 

else 
 net_eqv ( ( struct queue * ) ( ( struct queue * ) pdst ) , ( struct queue * ) ( ( struct queue * ) psrc ) ) ; } { _that = ( int * ) 

 netq ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } 
break ; 
case 0x06 : 
 dst_ref = ( struct net_ref * ) pdst ; 
 dst_net = ( struct netelem * ) ( dst_ref -> net ) ; 
if ( dst_net -> eqv == 0 && ! doSimpleNet ) 
 dst_net -> eqv = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

if ( dst_ref -> net_xs ) { 
 dst_net_xs = ( struct stack * ) ( flatten_xs ( dst_ref -> net_xs ) ) ; 

for ( i = 0 ; i < _22stack_length ( ( struct stack * ) dst_net_xs ) ; i ++ ) { 

 pnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( dst_ref -> net ) , ( struct stack * ) ( ( struct stack * ) _16stack_access ( ( struct stack * ) dst_net_xs , ( int ) ( i ) ) ) ) , ( struct net_ref * ) _that ) ; 
 pnref -> ref_xs = ( struct stack * ) ( stackcpy ( _16stack_access ( ( struct stack * ) dst_net_xs , ( int ) 0 ) ) ) ; 
 pnref -> inst = ( struct ntwinst * ) ( dst_ref -> inst ) ; 
 pnref -> inst_xs = ( struct stack * ) ( dst_ref -> inst_xs ) ; 
if ( doSimpleNet ) { 


 joinSimple ( dst_net , pnref -> ref_xs , pnref -> inst , pnref -> inst_xs , pnref -> net , pnref -> net_xs ) ; { _that = ( int * ) 
 pnref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } 

else 
 _14queue_put ( ( struct queue * ) dst_net -> eqv , ( struct link * ) ( pnref ) ) ; } } 



while ( ! _17queue_empty ( ( struct queue * ) netq ) ) { 
 psrc = ( struct link * ) ( _13queue_get ( ( struct queue * ) netq ) ) ; 
 src_ref = ( struct net_ref * ) psrc ; 

if ( src_ref -> net_xs ) { 
 src_net_xs = ( struct stack * ) ( flatten_xs ( src_ref -> net_xs ) ) ; 
for ( i = 0 ; i < _22stack_length ( ( struct stack * ) src_net_xs ) ; i ++ ) { 

 pnref = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( src_ref -> net ) , ( struct stack * ) ( ( struct stack * ) _16stack_access ( ( struct stack * ) src_net_xs , ( int ) ( i ) ) ) ) , ( struct net_ref * ) _that ) ; 
if ( dst_ref -> net_xs ) 
 pnref -> ref_xs = ( struct stack * ) ( stackcpy ( _16stack_access ( ( struct stack * ) dst_net_xs , ( int ) 0 ) ) ) ; 
 pnref -> inst = ( struct ntwinst * ) ( src_ref -> inst ) ; 
 pnref -> inst_xs = ( struct stack * ) ( src_ref -> inst_xs ) ; 
if ( doSimpleNet ) { 


 joinSimple ( dst_net , pnref -> ref_xs , pnref -> inst , pnref -> inst_xs , pnref -> net , pnref -> net_xs ) ; { _that = ( int * ) 
 pnref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } 

else 
 _14queue_put ( ( struct queue * ) dst_net -> eqv , ( struct link * ) ( pnref ) ) ; } { _that = ( int * ) 

 src_ref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } 

else { 
if ( dst_ref -> net_xs ) 
 src_ref -> ref_xs = ( struct stack * ) ( stackcpy ( _16stack_access ( ( struct stack * ) dst_net_xs , ( int ) 0 ) ) ) ; 
if ( doSimpleNet ) { 


 joinSimple ( dst_net , src_ref -> ref_xs , src_ref -> inst , src_ref -> inst_xs , src_ref -> net , src_ref -> net_xs ) ; { _that = ( int * ) 
 src_ref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } 

else 
 _14queue_put ( ( struct queue * ) dst_net -> eqv , ( struct link * ) ( src_ref ) ) ; } } { _that = ( int * ) 


 dst_ref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } { _that = ( int * ) 
 netq ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } 
break ; } { _result = 

 ( 0 ) ; goto _return ; } _return : return _result ; } /* neteqv */ 


int getxslength ( xs ) struct stack * xs ; 

{ int * _that ; int _result ; 
int n ; 
int i ; 
int lb ; 
int rb ; 
int len = 1 ; 
Xelem * pxelem ; 

if ( xs ) 
 n = _22stack_length ( ( struct stack * ) xs ) ; 
else 
n = 0 ; 

for ( i = 0 ; i < n ; i ++ ) { 
 pxelem = ( struct xelem * ) _16stack_access ( ( struct stack * ) xs , ( int ) ( i ) ) ; 
 lb = pxelem -> left_bound ; 
 rb = pxelem -> right_bound ; 
len = len * ( 1 + abs ( lb - rb ) ) ; } { _result = 


 ( len ) ; goto _return ; } _return : return _result ; } /* getxslength */ 


int getnetcnt ( netq ) struct queue * netq ; 

{ int * _that ; int _result ; 
int i ; 
int net_cnt = 0 ; 
int netq_len = _15queue_length ( ( struct queue * ) netq ) ; 
NetReference * pq ; 

for ( i = 0 , pq = ( struct net_ref * ) _19queue_first_elem ( ( struct queue * ) netq ) ; 
i < netq_len ; 
 i ++ , pq = ( struct net_ref * ) _20queue_next_elem ( ( struct queue * ) netq , ( struct link * ) ( ( struct link * ) pq ) ) ) 
{ 
 net_cnt += getnetlength ( pq ) ; } { _result = 


 ( net_cnt ) ; goto _return ; } _return : return _result ; } /* getnetcnt */ 
