/* SccsId = "@(#)netelem.cls 4.3 (TU-Delft) 11/25/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/

void netelem.new(char *s, Stack *stack, char ntype) {
    link.type = ntype;
    name = (char *) strsav(s);
    strcpy(name, s);
    xs = stack;
    nmem = NULL;
    if (ntype == TermType)
	type = N_TERMINAL;
    else
	type = N_NET;
    printf("type = %d, N_TERMINAL = %d, N_NET = %d, name = %s\n",
           type,N_TERMINAL,N_NET,s);
#ifdef DMEM
    netelem_nbyte += sizeof(class netelem);
    netelem_maxnbyte = netelem_nbyte > netelem_maxnbyte?
		    netelem_nbyte : netelem_maxnbyte;
#endif
}

void netelem.delete() {
    delete name;
#ifdef DMEM
    char_nbyte -= strlen(name) + 1;
#endif
    if(link.type == NetType)
    {
        if(xs)
        {
	    stackfree(xs, XELEM);
            delete xs;
        }
    }
#ifdef DMEM
    netelem_nbyte -= sizeof(class netelem);
#endif
}

void netelem.print() {
    fprintf(stderr,"[ Netelem ] ptr = %x {\n",this);
    fprintf(stderr,"\tname =\t%s\n",name);
    fprintf(stderr,"\txs   =\t%x\n",xs);
    fprintf(stderr,"}\n");
}

void netelem.to_db() {
	char **pxs;
	int i;
	int size = xs ? xs -> limit() - xs->base() : 0;

	strcpy(cterm.term_name, name);
	cterm.term_dim = size;
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte?
		    int_nbyte : int_maxnbyte;
#endif
	cterm.term_lower = new long [size];
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte?
		    int_nbyte : int_maxnbyte;
#endif
	cterm.term_upper = new long [size];

	if(xs)
	{
	    /* lower _boundaries */
	    for(i=0, pxs=xs->base(); pxs < xs->limit(); i++, pxs++)
		cterm.term_lower[i] = ((Xelem *) *pxs)->left_bound;

	    /* upper _boundaries */
	    for(i=0, pxs=xs->base(); pxs < xs->limit(); i++, pxs++)
		cterm.term_upper[i] = ((Xelem *) *pxs)->right_bound;
	}

	dmPutDesignData(dsp_term, CIR_TERM);
 	if(cterm.term_dim)
	{
#ifdef DMEM
    int_nbyte -= size * sizeof(int);
#endif
	    delete cterm.term_lower;
#ifdef DMEM
    int_nbyte -= size * sizeof(int);
#endif
	    delete cterm.term_upper;
	}
}

void net_ref.new(pnet, xs)
class netelem *pnet;
Stack *xs;
{
    link.type = NetRefType;
    net = pnet;
    net_xs = xs;
#ifdef DMEM
    net_ref_nbyte += sizeof(class net_ref);
    net_ref_maxnbyte = net_ref_nbyte > net_ref_maxnbyte?
		    net_ref_nbyte : net_ref_maxnbyte;
#endif
}

void net_ref.delete() {
#ifdef DMEM
    net_ref_nbyte -= sizeof(class net_ref);
#endif
    if(net_xs)
    {
/*
	if(((Link *) net)->type == NetType)
	    stackfree(net_xs, XELEM);
        delete net_xs;
*/
    }

    if(ref_xs)
    {
        delete ref_xs;
    }
}
