/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "main.cls"
/* <<cpre-2/8/82>> */ static char * SccsId = "@(#)main.cls 4.20 (TU-Delft) 12/16/92" ; 
#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 30 "main.cls"

#line 1 "./class.h"

#line 1 "./odb.h"

#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 32 "main.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 33 "main.cls"

#line 37 "main.cls"


int doSimpleNet = 1 ; 
int genIntNet = 0 ; 
int sflag = 0 ; 
int externRequired = 0 ; 
int forbidFirstCapital = 0 ; 
int noWarnings = 0 ; 
int interact = 0 ; 
int cirflag = 0 ; 
int dummy = 0 ; 
int runCpp = 0 ; 
char f_view [ BUFSIZ ] ; 
char fn_incl [ 128 ] ; 
char fn_cppout [ 80 ] ; 
char * cpp_options ; 
char * defaultInclude ; 

char * * globNets ; 
int * globNetsCheck ; 
char * * globConA ; 
char * * globConB ; 
int globNets_cnt ; 
char * * defGlobNets ; 
int defGlobNets_cnt ; 
#line 68 "main.cls"

#line 77 "main.cls"


Stack * xs ; 
Stack * attr_s ; 
Dictionary * ntw_dict = 0 ; 
Dictionary * dff_dict = 0 ; 
Dictionary * sym_dict = 0 ; 
Network * dev_tab [ 10 ] ; 
Netelem * notconnected ; 

int dict_nbyte , dict_maxnbyte ; 
int queue_nbyte , queue_maxnbyte ; 
int stack_nbyte , stack_maxnbyte ; 
int int_nbyte , int_maxnbyte ; 
int char_nbyte , char_maxnbyte ; 
int ntwdef_nbyte , ntwdef_maxnbyte ; 
int ntwinst_nbyte , ntwinst_maxnbyte ; 
int inst_struct_nbyte , inst_struct_maxnbyte ; 
int netelem_nbyte , netelem_maxnbyte ; 
int net_ref_nbyte , net_ref_maxnbyte ; 
int xelem_nbyte , xelem_maxnbyte ; 
#line 107 "main.cls"

char * argv0 = "sls_mkdb" ; 
#line 111 "main.cls"

char * use_msg = "Usage: sls_mkdb [-psw] file_1 ... file_n" ; 
#line 123 "main.cls"

DM_PROJECT * dmproject = 0 ; 

FILE * yyin ; 
FILE * fpstat ; 

extern DM_STREAM * dsp_term ; 
extern int externspec ; 
extern Network * curr_ntw ; 
extern int yylineno ; 
#line 168 "main.cls"
main 

( argc , argv ) int argc ; char * * argv ; 


{ int * _that ; int _result ; 
FILE * fopen ( ) ; 
int i , 
iarg ; 
int die ( ) ; 
int init_devs ( ) ; 
int readGlobalNets ( ) ; 
int readrcFile ( ) ; 
char * doCpp ( ) ; 
char * fn ; 
struct stat statBuf ; 
char * * filelist = 0 ; 
int eseIndex = 0 ; 
#line 190 "main.cls"

strcpy ( f_view , CIRCUIT ) ; 



for ( iarg = 1 ; iarg < argc && argv [ iarg ] [ 0 ] == '-' ; iarg ++ ) { 
switch ( argv [ iarg ] [ 1 ] ) { 
case 'd' : 
dummy = 1 ; 
break ; 
case 'w' : 
noWarnings = 1 ; 
break ; 
case 'I' : 
interact = 1 ; 
break ; 
case 'p' : 
runCpp ++ ; 
break ; 
case 's' : 
sflag ++ ; 
break ; 
case 'o' : 
doSimpleNet = 0 ; 
break ; 
case 'i' : 
genIntNet = 1 ; 
break ; 
default : 
printf ( "%s: -%s: Unknown option\n" , argv [ 0 ] , & argv [ iarg ] [ 1 ] ) ; } } 



if ( iarg >= argc ) { 
fprintf ( stderr , "\n%s\n\n" , use_msg ) ; 
exit ( 0 ) ; 
#line 237 "main.cls"
} 

signal_init ( ) ; 
fn_cppout [ 0 ] = '\0' ; 
cpp_options = 0 ; 
defaultInclude = 0 ; 

dmInit ( argv0 ) ; 
dmproject = dmOpenProject ( DEFAULT_PROJECT , DEFAULT_MODE ) ; 



readrcFile ( ) ; 
#line 277 "main.cls"


readGlobalNets ( ) ; 

 attr_s = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( 10 ) ) , ( struct stack * ) _that ) ; 
 xs = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( 10 ) ) , ( struct stack * ) _that ) ; 
 ntw_dict = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct dictionary ) ) , _1dictionary_new ( ( struct dictionary * ) _that ) , ( struct dictionary * ) _that ) ; 
 dff_dict = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct dictionary ) ) , _1dictionary_new ( ( struct dictionary * ) _that ) , ( struct dictionary * ) _that ) ; 
init_devs ( ) ; 
init_bifs ( ) ; 

strcpy ( fn_incl , "" ) ; 


for ( ; iarg < argc ; iarg ++ ) { 
if ( stat ( argv [ iarg ] , & statBuf ) == 0 ) { 
if ( ! sflag ) { 
fprintf ( stderr , "File %s:\n" , argv [ iarg ] ) ; } 

if ( runCpp ) 
fn = doCpp ( argv [ iarg ] ) ; 
else 
fn = argv [ iarg ] ; 
if ( ( yyin = fopen ( fn , "r" ) ) != 0 ) 
{ 
yyparse ( ) ; 
if ( sym_dict ) { 
 end_ntw ( curr_ntw , externspec , COMPLETE ) ; } 


fclose ( yyin ) ; } 

else { 
fprintf ( stderr , "Cannot open %s\n" , argv [ iarg ] ) ; } } 


else { 
fprintf ( stderr , "Cannot open %s\n" , argv [ iarg ] ) ; } 


if ( fn_cppout [ 0 ] ) { 
unlink ( fn_cppout ) ; 
fn_cppout [ 0 ] = '\0' ; } 
#line 353 "main.cls"
} { _that = ( int * ) 

 ntw_dict ; _2dictionary_delete ( ( struct dictionary * ) _that ) ; free ( _that ) ; } 
 ntw_dict = ( struct dictionary * ) ( 0 ) ; { _that = ( int * ) 
 dff_dict ; _2dictionary_delete ( ( struct dictionary * ) _that ) ; free ( _that ) ; } 
 dff_dict = ( struct dictionary * ) ( 0 ) ; 

if ( dmproject ) { 
dmCloseProject ( dmproject , COMPLETE ) ; } 

dmQuit ( ) ; 
#line 370 "main.cls"
{ _result = 
 ( 0 ) ; goto _return ; } _return : return _result ; } /* main */ 


int die ( ) { int * _that ; 
#line 381 "main.cls"
if ( sym_dict ) { 
 end_ntw ( curr_ntw , externspec , QUIT ) ; } 


if ( dmproject ) { 
dmCloseProject ( dmproject , QUIT ) ; } 


dmQuit ( ) ; 

if ( sym_dict ) { { _that = ( int * ) 
 sym_dict ; _2dictionary_delete ( ( struct dictionary * ) _that ) ; free ( _that ) ; } 
 sym_dict = ( struct dictionary * ) ( 0 ) ; } 

if ( ntw_dict ) { { _that = ( int * ) 
 ntw_dict ; _2dictionary_delete ( ( struct dictionary * ) _that ) ; free ( _that ) ; } 
 ntw_dict = ( struct dictionary * ) ( 0 ) ; } 

if ( dff_dict ) { { _that = ( int * ) 
 dff_dict ; _2dictionary_delete ( ( struct dictionary * ) _that ) ; free ( _that ) ; } 
 dff_dict = ( struct dictionary * ) ( 0 ) ; } 


if ( fn_cppout [ 0 ] ) { 
unlink ( fn_cppout ) ; 
fn_cppout [ 0 ] = '\0' ; } 


exit ( 1 ) ; } /* die */ 


int init_devs ( ) { int * _that ; 
Network * ntw ; 
Queue * termq ; 
Netelem * pterm ; 
int existCell ( ) ; 

 termq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
#line 428 "main.cls"

 pterm = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( "g" ) , ( struct stack * ) 0 , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 _14queue_put ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ; 
 pterm = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( "d" ) , ( struct stack * ) 0 , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 _14queue_put ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ; 
 pterm = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( "s" ) , ( struct stack * ) 0 , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 _14queue_put ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ; 


 dev_tab [ 0 ] = ( struct ntwdef * ) ( ntw = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwdef ) ) , _1ntwdef_new ( ( struct ntwdef * ) _that , ( char * ) ( "nenh" ) ) , ( struct ntwdef * ) _that ) ) ; 
 ntw -> termq = ( struct queue * ) ( termq ) ; 
 ntw -> local = ( existCell ( "nenh" , CIRCUIT ) != 2 ) ; 
 _13dictionary_store ( ( struct dictionary * ) ntw_dict , ( char * ) ( ntw -> ntw_name ) , ( char * ) ( ( char * ) ntw ) ) ; 

 dev_tab [ 1 ] = ( struct ntwdef * ) ( ntw = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwdef ) ) , _1ntwdef_new ( ( struct ntwdef * ) _that , ( char * ) ( "penh" ) ) , ( struct ntwdef * ) _that ) ) ; 
 ntw -> termq = ( struct queue * ) ( termq ) ; 
 ntw -> local = ( existCell ( "penh" , CIRCUIT ) != 2 ) ; 
 _13dictionary_store ( ( struct dictionary * ) ntw_dict , ( char * ) ( ntw -> ntw_name ) , ( char * ) ( ( char * ) ntw ) ) ; 

 dev_tab [ 2 ] = ( struct ntwdef * ) ( ntw = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwdef ) ) , _1ntwdef_new ( ( struct ntwdef * ) _that , ( char * ) ( "ndep" ) ) , ( struct ntwdef * ) _that ) ) ; 
 ntw -> termq = ( struct queue * ) ( termq ) ; 
 ntw -> local = ( existCell ( "ndep" , CIRCUIT ) != 2 ) ; 
 _13dictionary_store ( ( struct dictionary * ) ntw_dict , ( char * ) ( ntw -> ntw_name ) , ( char * ) ( ( char * ) ntw ) ) ; 

 termq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
 pterm = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( "p" ) , ( struct stack * ) 0 , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 _14queue_put ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ; 
 pterm = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( "n" ) , ( struct stack * ) 0 , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 _14queue_put ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ; 

 dev_tab [ 4 ] = ( struct ntwdef * ) ( ntw = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwdef ) ) , _1ntwdef_new ( ( struct ntwdef * ) _that , ( char * ) ( "cap" ) ) , ( struct ntwdef * ) _that ) ) ; 
 ntw -> termq = ( struct queue * ) ( termq ) ; 
 ntw -> local = ( existCell ( "cap" , CIRCUIT ) != 2 ) ; 
 _13dictionary_store ( ( struct dictionary * ) ntw_dict , ( char * ) ( ntw -> ntw_name ) , ( char * ) ( ( char * ) ntw ) ) ; 

 dev_tab [ 3 ] = ( struct ntwdef * ) ( ntw = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwdef ) ) , _1ntwdef_new ( ( struct ntwdef * ) _that , ( char * ) ( "res" ) ) , ( struct ntwdef * ) _that ) ) ; 
 ntw -> termq = ( struct queue * ) ( termq ) ; 
 ntw -> local = ( existCell ( "res" , CIRCUIT ) != 2 ) ; 
 _13dictionary_store ( ( struct dictionary * ) ntw_dict , ( char * ) ( ntw -> ntw_name ) , ( char * ) ( ( char * ) ntw ) ) ; 
#line 524 "main.cls"
} /* init_devs */ 

double cvt_atof ( s ) char * s ; 

{ int * _that ; double _result ; 
double atof ( ) ; 
double d ; 
char c = s [ strlen ( s ) - 1 ] ; 

if ( isdigit ( c ) ) 
d = ( float ) atof ( s ) ; 
else { 
s [ strlen ( s ) - 1 ] = '\0' ; 
switch ( c ) { 
case 'G' : 
d = 1e9 * atof ( s ) ; 
break ; 
case 'M' : 
d = 1e6 * atof ( s ) ; 
break ; 
case 'k' : 
d = 1e3 * atof ( s ) ; 
break ; 
case 'm' : 
d = 1e-3 * atof ( s ) ; 
break ; 
case 'u' : 
d = 1e-6 * atof ( s ) ; 
break ; 
case 'n' : 
d = 1e-9 * atof ( s ) ; 
break ; 
case 'p' : 
d = 1e-12 * atof ( s ) ; 
break ; 
case 'f' : 
d = 1e-15 * atof ( s ) ; 
break ; 
default : 
d = atof ( s ) ; } } { _result = 


 ( d ) ; goto _return ; } _return : return _result ; } /* cvt_atof */ 
#line 571 "main.cls"
int readGlobalNets ( ) 
{ int * _that ; 
FILE * fp ; 
int cnt ; 
int i ; 
char * fn ; 
char buf [ 128 ] ; 

fp = fopen ( "global_nets" , "r" ) ; 
if ( fp == 0 ) { 
fn = ( char * ) dmGetMetaDesignData ( PROCPATH , dmproject , "global_nets" ) ; 
fp = fopen ( fn , "r" ) ; } 


if ( fp ) { 

cnt = 0 ; 
while ( fscanf ( fp , "%s" , buf ) > 0 ) { 
cnt ++ ; } 

rewind ( fp ) ; 

globNets = ( char * * ) calloc ( ( unsigned ) ( cnt ) , sizeof ( char * ) ) ; 
globNetsCheck = ( int * ) calloc ( ( unsigned ) ( cnt ) , sizeof ( int ) ) ; 
globConA = ( char * * ) calloc ( ( unsigned ) ( cnt ) , sizeof ( char * ) ) ; 
globConB = ( char * * ) calloc ( ( unsigned ) ( cnt ) , sizeof ( char * ) ) ; 
defGlobNets = ( char * * ) calloc ( ( unsigned ) ( cnt ) , sizeof ( char * ) ) ; 

cnt = 0 ; 
while ( fscanf ( fp , "%s" , buf ) > 0 ) { 
for ( i = 0 ; i < globNets_cnt ; i ++ ) { 
if ( strcmp ( globNets [ i ] , buf ) == 0 ) 
break ; } 

if ( i == globNets_cnt ) { 
globNets [ cnt ] = ( char * ) calloc ( ( unsigned ) ( strlen ( buf ) + 1 ) , sizeof ( char ) ) ; 
strcpy ( globNets [ cnt ] , buf ) ; 
cnt ++ ; } } 


globNets_cnt = cnt ; 

fclose ( fp ) ; } 

else { 
globNets_cnt = 0 ; } } /* readGlobalNets */ 



char * isGlobalNet ( s ) char * s ; 

{ int * _that ; char * _result ; 
int i ; 

for ( i = 0 ; i < globNets_cnt ; i ++ ) { 
if ( strcmp ( s , globNets [ i ] ) == 0 ) { { _result = 
 ( globNets [ i ] ) ; goto _return ; } } } { _result = 



 ( 0 ) ; goto _return ; } _return : return _result ; } /* isGlobalNet */ 


char * isDefGlobalNet ( s ) char * s ; 

{ int * _that ; char * _result ; 
int i ; 

for ( i = 0 ; i < defGlobNets_cnt ; i ++ ) { 
if ( strcmp ( s , defGlobNets [ i ] ) == 0 ) { { _result = 
 ( defGlobNets [ i ] ) ; goto _return ; } } } { _result = 



 ( 0 ) ; goto _return ; } _return : return _result ; } /* isDefGlobalNet */ 


int readrcFile ( ) 
{ int * _that ; 
char buf [ 256 ] ; 
char c ; 
FILE * fp ; 
char * fn ; 
char * home ; 
char * getenv ( ) ; 
int rcReadError ( ) ; 
int myscanf ( ) ; 

if ( ( fp = fopen ( ".sls_mkdbrc" , "r" ) ) == 0 ) { 

if ( home = getenv ( "HOME" ) ) { 
fn = ( char * ) calloc ( ( unsigned ) ( strlen ( home ) + strlen ( ".sls_mkdbrc" ) + 2 ) , sizeof ( char ) ) ; 
if ( fn ) { 
sprintf ( fn , "%s/%s" , home , ".sls_mkdbrc" ) ; 
fp = fopen ( fn , "r" ) ; } } 



if ( fp == 0 && dmproject ) { 
if ( fn = ( char * ) dmGetMetaDesignData ( PROCPATH , dmproject , ".sls_mkdbrc" ) ) 
fp = fopen ( fn , "r" ) ; } } 


else 
fn = ".sls_mkdbrc" ; 

if ( ! fp ) { goto _return 
; } 


while ( fscanf ( fp , "%s" , buf ) > 0 ) { 

if ( buf [ 0 ] == '#' ) { } 


else if ( strcmp ( buf , "CPP_OPTIONS:" ) == 0 ) { 
if ( myscanf ( ( int * ) fp , buf ) > 0 ) { 
cpp_options = ( char * ) calloc ( ( unsigned ) ( strlen ( buf ) + 1 ) , sizeof ( char ) ) ; 
strcpy ( cpp_options , buf ) ; } 

else { 
rcReadError ( fn , "CPP_OPTIONS:" ) ; } } 


else if ( strcmp ( buf , "DEFAULT_INCLUDE:" ) == 0 ) { 
if ( myscanf ( ( int * ) fp , buf ) > 0 ) { 
defaultInclude = ( char * ) calloc ( ( unsigned ) ( strlen ( buf ) + 1 ) , sizeof ( char ) ) ; 
strcpy ( defaultInclude , buf ) ; } 

else { 
rcReadError ( fn , "DEFAULT_INCLUDE:" ) ; } } 


else if ( strcmp ( buf , "EXTERN_OBLIGATORY" ) == 0 ) { 
externRequired = 1 ; } 

else if ( strcmp ( buf , "EXTERN_OBLIGATORY_ON" ) == 0 ) { 
externRequired = 1 ; } 

else if ( strcmp ( buf , "RUN_CPP" ) == 0 ) { 
runCpp = 1 ; } 

else if ( strcmp ( buf , "RUN_CPP_ON" ) == 0 ) { 
runCpp = 1 ; } 

else if ( strcmp ( buf , "FORBID_FIRST_CAPITAL_ON" ) == 0 ) { 
forbidFirstCapital = 1 ; } 

else { 
rcReadError ( fn , buf ) ; } 


while ( ( c = getc ( fp ) ) != '\n' && c != EOF ) ; 
if ( c == EOF ) break ; } 
#line 729 "main.cls"
fclose ( fp ) ; _return : return ; } /* readrcFile */ 


int myscanf ( fp_i , s ) int * fp_i ; char * s ; 


{ int * _that ; int _result ; 
FILE * fp = ( FILE * ) fp_i ; 


int i ; 
int nonspace ; 
char c ; 

while ( ( c = getc ( fp ) ) == ' ' || c == '\t' ) ; 

i = 0 ; 
nonspace = - 1 ; 
if ( c != EOF && c != '\n' ) { 
while ( c != EOF && c != '\n' ) { 
s [ i ] = c ; 
if ( c != ' ' && c != '\t' ) 
nonspace = i ; 
c = getc ( fp ) ; 
i ++ ; } } 



s [ nonspace + 1 ] = '\0' ; 

ungetc ( c , fp ) ; 

if ( i > 0 ) { _result = 
 ( 1 ) ; goto _return ; } 
else if ( c == EOF ) { _result = 
 ( - 1 ) ; goto _return ; } 
else { _result = 
 ( 0 ) ; goto _return ; } _return : return _result ; } /* myscanf */ 


int rcReadError ( fn , s ) char * fn ; char * s ; 


{ int * _that ; 
fprintf ( stderr , "Error in file '%s' for '%s'\n" , fn , s ) ; 
 die ( ) ; } /* rcReadError */ 


char * doCpp ( fn ) char * fn ; 

{ int * _that ; char * _result ; 
FILE * fp ; 
FILE * fp2 ; 
char c ; 
struct stat statBuf ; 
char cmdstr [ 128 ] ; 
char fn_cppin [ 128 ] ; 

sprintf ( fn_cppin , "x%d.c" , getpid ( ) ) ; 
sprintf ( fn_cppout , "x%d.s" , getpid ( ) ) ; 

if ( ( fp = fopen ( fn_cppin , "w" ) ) == 0 ) { 
fprintf ( stderr , "Cannot open %s\n" , fn_cppin ) ; { _result = 
 ( fn ) ; goto _return ; } } 


if ( defaultInclude ) { 
fprintf ( fp , "#include \"%s\"\n" , defaultInclude ) ; } 


fprintf ( fp , "#line 1 \"%s\"\n" , fn ) ; 

if ( ( fp2 = fopen ( fn , "r" ) ) == 0 ) { { _result = 

 ( fn ) ; goto _return ; } } 

while ( ( c = getc ( fp2 ) ) != EOF ) 
putc ( c , fp ) ; 
fclose ( fp2 ) ; 

fclose ( fp ) ; 

if ( stat ( "/usr/lib/cpp" , & statBuf ) == 0 ) 
sprintf ( cmdstr , "/usr/lib/cpp %s %s > %s" , 
cpp_options , fn_cppin , fn_cppout ) ; 
else if ( stat ( "/lib/cpp" , & statBuf ) == 0 ) 
sprintf ( cmdstr , "/lib/cpp %s %s > %s" , 
cpp_options , fn_cppin , fn_cppout ) ; 
else 
sprintf ( cmdstr , "cc -E %s %s > %s" , cpp_options , fn_cppin , fn_cppout ) ; 

if ( system ( cmdstr ) == 0 ) { 
unlink ( fn_cppin ) ; { _result = 
 ( fn_cppout ) ; goto _return ; } } 

else { 
unlink ( fn_cppin ) ; { _result = 
 ( fn ) ; goto _return ; } } _return : return _result ; } /* doCpp */ 



int parseLineStmt ( s ) char * s ; 

{ int * _that ; 
char * p ; 
int i ; 
extern char fn_incl [ ] ; 
#line 843 "main.cls"
for ( p = s + 1 ; * p && ( * p == ' ' || * p == '\t' ) ; p ++ ) ; 
if ( ( * p >= '0' && * p <= '9' ) 
|| ( * p == 'l' && * ( p + 1 ) == 'i' 
&& * ( p + 2 ) == 'n' && * ( p + 3 ) == 'e' 
&& ( * ( p + 4 ) == ' ' || * ( p + 5 ) == '\t' ) ) ) { 

if ( * p == 'l' ) { 
p = p + 4 ; 
while ( * p && ( * p == ' ' || * p == '\t' ) ) p ++ ; } 


if ( sscanf ( p , "%d" , & yylineno ) == 1 ) { 

while ( * p && ! ( * p == ' ' || * p == '\t' ) ) p ++ ; 
while ( * p && ( * p == ' ' || * p == '\t' ) ) p ++ ; 
if ( * p == '"' ) p ++ ; 
if ( * p ) { 
i = 0 ; 
while ( * p && * p != '"' 
&& ! ( * p == ' ' || * p == '\t' ) ) { 
 fn_incl [ i ++ ] = * p ++ ; } 

 fn_incl [ i ] = '\0' ; } } 


else { 
yylineno -- ; 
yyerror ( 0 ) ; } } 


else { 
yylineno -- ; 
yyerror ( 0 ) ; } } /* parseLineStmt */ 



int dmError ( s ) char * s ; 

{ int * _that ; int _result ; 
dmPerror ( s ) ; 
 die ( ) ; { _result = 
 ( 0 ) ; goto _return ; } 
#line 981 "main.cls"
_return : return _result ; } /* dmError */ 
