%{
/* SccsId = "@(#)lex.l 4.4 (TU-Delft) 12/09/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "parse.h"

#define INCR_LINENO

#ifdef FLEX_SCANNER
int yylineno = 1;
#undef INCR_LINENO
#define INCR_LINENO ++yylineno
#endif

%}

D	[0-9]
E	[DEde][-+]?{D}+

%%
"/*"			{ int thechar;
                          loop:
				while((thechar = input()) != '*')
				{
				    if(thechar == EOF) return(0);
				}
				switch(input())
				{
				    case 0: return(0);
				    case '/': break;
				    case '*': unput('*');
				    default : goto loop;
				}
			}
"#"[^\n]*\n 		{ void parseLineStmt ();
			  parseLineStmt ((char *) yytext);
			}
"network"		{ return(NETWORK); }
"extern"		{ return(EXTERNSPEC); }
"terminal"		{ return(TERMINAL); }
"net"			{ return(NET)     ; }
"nenh"			{ return(NENH); }
"penh"			{ return(PENH); }
"ndep"			{ return(NDEP); }
"res"			{ return(RES)     ; }
"cap"			{ return(CAP)     ; }
"w"			{ return(T_WIDTH) ; }
"l"			{ return(T_LENGTH); }
"tr"			{ return(T_RISE); }
"tf"			{ return(T_FALL); }
".."			{ return(DOTDOT)  ; }
"="			{ return(ASSIGN)  ; }
"("			{ return(LPS)     ; }
")"			{ return(RPS)     ; }
"["			{ return(LSB)     ; }
"]"			{ return(RSB)     ; }
"{"			{ return(LCB)     ; }
"}"			{ return(RCB)     ; }
","			{ return(COMMA)   ; }
";"			{ return(SEMICOLON); }
"."			{ return(PERIOD); }
"@"			{ return(ATSIGN); }
[a-zA-Z][a-zA-Z0-9_]*		{ yylval.sval = (char *) yytext;
			  return(IDENTIFIER); }
{D}+			{ yylval.sval = (char *) yytext;
			  return(INTEGER); }
{D}+("."{D}+)?({E})?[fpnumkM]? { yylval.sval = (char *) yytext;
			  return(FLOAT); }
[\t ]+		        ;
[\n]                    {INCR_LINENO;}
%%

int Input ()
{
    return (input ());
}
