/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "init_ntw.cls"
/* <<cpre-2/8/82>> */ static char * SccsId = "@(#)init_ntw.cls 4.14 (TU-Delft) 12/15/92" ; 
#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 30 "init_ntw.cls"

#line 1 "./class.h"

#line 1 "./odb.h"

#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 32 "init_ntw.cls"

#line 1 "./mkdbincl.h"

#line 27 "init_ntw.cls"
extern int doSimpleNet ; 
extern int genIntNet ; 
extern int externRequired ; 
extern int forbidFirstCapital ; 
extern int noWarnings ; 
extern int sls_errcnt ; 
extern int sls_errno ; 
extern int sls_nerr ; 
extern char * sls_errlist [ ] ; 

extern int yylineno ; 
extern char fn_incl [ ] ; 

extern int int_nbyte , int_maxnbyte ; 
extern int char_nbyte , char_maxnbyte ; 
extern int ntwdef_nbyte , ntwdef_maxnbyte ; 
extern int ntwinst_nbyte , ntwinst_maxnbyte ; 
extern int inst_struct_nbyte , inst_struct_maxnbyte ; 
extern int netelem_nbyte , netelem_maxnbyte ; 
extern int dict_nbyte , dict_maxnbyte ; 
extern int net_ref_nbyte , net_ref_maxnbyte ; 
extern int xelem_nbyte , xelem_maxnbyte ; 
extern int queue_nbyte , queue_maxnbyte ; 
extern int stack_nbyte , stack_maxnbyte ; 
#line 33 "init_ntw.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 34 "init_ntw.cls"

extern Dictionary * ntw_dict ; 
extern Dictionary * sym_dict ; 

extern Network * curr_ntw ; 

extern Netelem * notconnected ; 

extern int sflag ; 
extern int noWarnings ; 

DM_CELL * dmkey ; 
extern DM_STREAM * dsp_term ; 
extern DM_STREAM * dsp_mc ; 
extern DM_STREAM * dsp_net ; 
extern DM_STREAM * dsp_sim_mc ; 
extern int cirflag ; 

extern char * * defGlobNets ; 
extern int defGlobNets_cnt ; 

int doExternTermCheck ; 
int * orig_term_check = 0 ; 

Stack * xs_rn = 0 ; 

extern DM_PROJECT * dmproject ; 

Network * init_ntw ( name , ext ) char * name ; int ext ; 


{ int * _that ; struct ntwdef * _result ; 
char * s ; 
char * new_name ; 
Network * ntw ; 
DM_PROJECT * projkey ; 
int exist ; 
int i ; 
Xelem * stkelem ; 
int t_cnt ; 
int existCell ( ) ; 
char * isGlobalNet ( ) ; 

dsp_term = 0 ; 
dsp_mc = 0 ; 
dsp_net = 0 ; 
#line 82 "init_ntw.cls"


 sym_dict = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct dictionary ) ) , _1dictionary_new ( ( struct dictionary * ) _that ) , ( struct dictionary * ) _that ) ; 
 ntw = ( struct ntwdef * ) _14dictionary_fetch ( ( struct dictionary * ) ntw_dict , ( char * ) ( name ) ) ; 


if ( ! sflag && ! ext ) 
fprintf ( stderr , "Parsing network: %s\n" , name ) ; 

if ( ntw == 0 ) { 
 ntw = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwdef ) ) , _1ntwdef_new ( ( struct ntwdef * ) _that , ( char * ) ( name ) ) , ( struct ntwdef * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) ntw_dict , ( char * ) ( ntw -> ntw_name ) , ( char * ) ( ( char * ) ntw ) ) ; 
if ( ! ext ) 
dmkey = dmCheckOut ( dmproject , name , WORKING , 
DONTCARE , CIRCUIT , UPDATE ) ; 
else { 
if ( ( exist = existCell ( name , CIRCUIT ) ) == 0 ) { 
if ( ! noWarnings ) 
fprintf ( stderr , 
"Warning: extern network %s not yet in database\n" , name ) ; 
#line 107 "init_ntw.cls"
doExternTermCheck = 0 ; } 

else { 
projkey = dmFindProjKey ( ( ( exist == 1 ) ? ( LOCAL ) : ( IMPORTED ) ) , 
name , dmproject , & new_name , CIRCUIT ) ; 

dmkey = dmCheckOut ( projkey , new_name , ACTUAL , 
DONTCARE , CIRCUIT , READONLY ) ; 

doExternTermCheck = 1 ; } } } 



else { { _result = 
 ( 0 ) ; goto _return ; } } 


if ( ext && existCell ( name , CIRCUIT ) == 2 ) 
 ntw -> local = 0 ; 
else 
 ntw -> local = 1 ; 

 ntw -> termq = ( struct queue * ) ( 0 ) ; 
 ntw -> orig_termq = ( struct queue * ) ( 0 ) ; 
 ntw -> netq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

 notconnected = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( "notConnected" ) , ( struct stack * ) 0 , ( char ) ( 0x05 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( notconnected -> name ) , ( char * ) ( ( char * ) notconnected ) ) ; 

if ( ! ext ) { 
dsp_term = dmOpenStream ( dmkey , "term" , "w" ) ; 
dsp_mc = dmOpenStream ( dmkey , "mc" , "w" ) ; 
dsp_net = dmOpenStream ( dmkey , "net" , "w" ) ; 
#line 143 "init_ntw.cls"
} 

else if ( doExternTermCheck ) { 
dsp_term = dmOpenStream ( dmkey , "term" , "r" ) ; 

defGlobNets_cnt = 0 ; 
 ntw -> orig_termq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

if ( xs_rn == 0 ) 
 xs_rn = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( 10 ) ) , ( struct stack * ) _that ) ; 

t_cnt = 0 ; 
while ( dmGetDesignData ( dsp_term , CIR_TERM ) > 0 ) { 
 _18stack_reset ( ( struct stack * ) xs_rn ) ; 
for ( i = 0 ; i < cterm . term_dim ; i ++ ) { 

 stkelem = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) ( cterm . term_lower [ i ] ) , ( short ) ( cterm . term_upper [ i ] ) ) , ( struct xelem * ) _that ) ; 
if ( _14stack_push ( ( struct stack * ) xs_rn , ( char * ) ( ( char * ) stkelem ) ) == 0x1 ) 
fprintf ( stderr , "xstack overflow\n" ) ; } 


 _14queue_put ( ( struct queue * ) ntw -> orig_termq , ( struct link * ) ( ( struct link * ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( cterm . term_name ) , ( struct stack * ) ( ( struct stack * ) stackcpy ( xs_rn ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ) ) ; 
t_cnt ++ ; 

if ( ( s = isGlobalNet ( cterm . term_name ) ) && cterm . term_dim == 0 ) { 
defGlobNets [ defGlobNets_cnt ++ ] = s ; } } 



if ( ! noWarnings && t_cnt > 0 ) { 
orig_term_check = ( int * ) calloc ( ( unsigned ) ( t_cnt ) , sizeof ( int ) ) ; 
for ( i = 0 ; i < t_cnt ; i ++ ) { 
orig_term_check [ i ] = 0 ; } } 



dmCloseStream ( dsp_term , COMPLETE ) ; 
dsp_term = 0 ; 
dmCheckIn ( dmkey , COMPLETE ) ; } 

else { 
defGlobNets_cnt = 0 ; } { _result = 


 ( ntw ) ; goto _return ; } _return : return _result ; } /* init_ntw */ 


Network * read_ntw ( name ) char * name ; 

{ int * _that ; struct ntwdef * _result ; 
int i ; 
DM_CELL * dmkey ; 
DM_STREAM * dsp ; 
Network * ntw ; 
Xelem * stkelem ; 
struct stat buf ; 
char * new_name ; 
DM_PROJECT * projkey ; 
int exist ; 
int existCell ( ) ; 

if ( ( exist = existCell ( name , CIRCUIT ) ) == 0 ) { _result = 
 ( 0 ) ; goto _return ; } 

projkey = dmFindProjKey ( ( ( exist == 1 ) ? ( LOCAL ) : ( IMPORTED ) ) , name , 
dmproject , & new_name , CIRCUIT ) ; 

dmkey = dmCheckOut ( projkey , new_name , ACTUAL , 
DONTCARE , CIRCUIT , READONLY ) ; 

if ( dmStat ( dmkey , "term" , & buf ) == 0 ) { 
dsp = dmOpenStream ( dmkey , "term" , "r" ) ; } 

else { 
if ( exist == 2 ) 
dmCloseProject ( projkey , COMPLETE ) ; { _result = 

 ( 0 ) ; goto _return ; } } 



 ntw = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwdef ) ) , _1ntwdef_new ( ( struct ntwdef * ) _that , ( char * ) ( name ) ) , ( struct ntwdef * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) ntw_dict , ( char * ) ( ntw -> ntw_name ) , ( char * ) ( ( char * ) ntw ) ) ; 

if ( exist == 1 ) 
 ntw -> local = 1 ; 
else 
 ntw -> local = 0 ; 

 ntw -> termq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

if ( xs_rn == 0 ) 
 xs_rn = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( 10 ) ) , ( struct stack * ) _that ) ; 

while ( dmGetDesignData ( dsp , CIR_TERM ) > 0 ) { 
 _18stack_reset ( ( struct stack * ) xs_rn ) ; 
for ( i = 0 ; i < cterm . term_dim ; i ++ ) { 

 stkelem = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) ( cterm . term_lower [ i ] ) , ( short ) ( cterm . term_upper [ i ] ) ) , ( struct xelem * ) _that ) ; 
if ( _14stack_push ( ( struct stack * ) xs_rn , ( char * ) ( ( char * ) stkelem ) ) == 0x1 ) 
fprintf ( stderr , "xstack overflow\n" ) ; } 


 _14queue_put ( ( struct queue * ) ntw -> termq , ( struct link * ) ( ( struct link * ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( cterm . term_name ) , ( struct stack * ) ( ( struct stack * ) stackcpy ( xs_rn ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ) ) ; } 


dmCloseStream ( dsp , COMPLETE ) ; 
dmCheckIn ( dmkey , COMPLETE ) ; 

if ( exist == 2 ) 
dmCloseProject ( projkey , COMPLETE ) ; { _result = 

 ( ntw ) ; goto _return ; } _return : return _result ; } /* read_ntw */ 


int checkDbTerm ( term ) struct netelem * term ; 

{ int * _that ; int _result ; 
int j ; 
Netelem * pterm ; 

Queue * termq = curr_ntw -> orig_termq ; 
int termq_len = _15queue_length ( ( struct queue * ) termq ) ; 


if ( doExternTermCheck == 0 ) { _result = 
 ( 0 ) ; goto _return ; } 

if ( termq ) { 
for ( j = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
j < termq_len ; 
 j ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) { 

if ( strcmp ( pterm -> name , term -> name ) == 0 ) { 

if ( pterm -> xs && term -> xs ) { 
if ( chk_bounds ( pterm -> xs , term -> xs ) ) { 
sls_errno = 19 ; 
sls_error ( yylineno , sls_errno , term -> name ) ; { _result = 
 ( - 1 ) ; goto _return ; } } } 


else if ( pterm -> xs && ! term -> xs ) { 
sls_errno = 19 ; 
sls_error ( yylineno , sls_errno , term -> name ) ; { _result = 
 ( - 1 ) ; goto _return ; } } 

else if ( ! pterm -> xs && term -> xs ) { 
sls_errno = 19 ; 
sls_error ( yylineno , sls_errno , term -> name ) ; { _result = 
 ( - 1 ) ; goto _return ; } } 


if ( orig_term_check ) 
orig_term_check [ j ] = 1 ; { _result = 

 ( 0 ) ; goto _return ; } } } } 
#line 304 "init_ntw.cls"
sls_errno = 18 ; 
sls_error ( yylineno , sls_errno , term -> name ) ; { _result = 
 ( - 1 ) ; goto _return ; } _return : return _result ; } /* checkDbTerm */ 


int finalCheckDbTerm ( ) 
{ int * _that ; 
int j ; 
Netelem * pterm ; 

Queue * termq = curr_ntw -> orig_termq ; 
int termq_len = _15queue_length ( ( struct queue * ) termq ) ; 

if ( doExternTermCheck == 0 || noWarnings ) goto _return 
; 

if ( termq ) { 
for ( j = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
j < termq_len ; 
 j ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) { 
if ( orig_term_check [ j ] == 0 && ! isGlobalNet ( pterm -> name ) ) { 
fprintf ( stderr , 
"Warning: terminal %s of netwerk %s not used in extern declaration\n" , 
 pterm -> name , curr_ntw -> ntw_name ) ; } } { _that = ( int * ) 


 orig_term_check ; free ( _that ) ; } 
orig_term_check = 0 ; } _return : return ; } /* finalCheckDbTerm */ 



static IMPCELL * * f_impcell_list = 0 ; 
static char * * f_loccell_list = 0 ; 
static IMPCELL * * c_impcell_list = 0 ; 
static char * * c_loccell_list = 0 ; 

int existCell ( name , view ) char * name ; char * view ; 


{ int * _that ; int _result ; 
int i ; 
IMPCELL * * * impcell_list ; 
char * * * loccell_list ; 

if ( strcmp ( view , "functional" ) == 0 ) { 
impcell_list = & f_impcell_list ; 
loccell_list = & f_loccell_list ; } 

else if ( strcmp ( view , CIRCUIT ) == 0 ) { 
impcell_list = & c_impcell_list ; 
loccell_list = & c_loccell_list ; } 


if ( * impcell_list == 0 ) { 
* impcell_list = ( IMPCELL * * ) dmGetMetaDesignData ( IMPORTEDCELLLIST , 
dmproject , view ) ; } 


if ( * loccell_list == 0 ) { 
* loccell_list = ( char * * ) dmGetMetaDesignData ( CELLLIST , 
dmproject , view ) ; } 


if ( * impcell_list == 0 || * loccell_list == 0 ) { _result = 
 ( 0 ) ; goto _return ; } 

i = 0 ; 
while ( ( * loccell_list ) [ i ] != 0 
&& strcmp ( name , ( * loccell_list ) [ i ] ) != 0 ) { 
i ++ ; } 


if ( ( * loccell_list ) [ i ] != 0 ) { _result = 
 ( 1 ) ; goto _return ; } 

i = 0 ; 
while ( ( * impcell_list ) [ i ] != 0 
&& strcmp ( name , ( * impcell_list ) [ i ] -> alias ) != 0 ) { 
i ++ ; } 


if ( ( * impcell_list ) [ i ] != 0 ) { _result = 
 ( 2 ) ; goto _return ; } { _result = 

 ( 0 ) ; goto _return ; } _return : return _result ; } /* existCell */ 
