static char *SccsId = "@(#)end_ntw.cls 4.8 (TU-Delft) 12/09/92";
/**********************************************************

Name/Version      : sls_mkdb/4.8

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "sys_incl.h"
#class
#include "class.h"
#include "mkdbincl.h"
#include "mkdbdefs.h"

extern Dictionary *ntw_dict;
extern Dictionary *sym_dict;

DM_CELL *dmkey;
extern DM_STREAM *dsp_term;
extern DM_STREAM *dsp_mc;
extern DM_STREAM *dsp_net;
extern DM_STREAM *dsp_sim_mc;
extern int cirflag;

int end_ntw(ntw, ext, orig_mode)
Network *ntw;
int ext;
int orig_mode;
{
    NetworkInstance *pinst;
    Netelem *pnet;
    int mode;

    if (sls_errno)
	mode = QUIT;
    else
	mode = orig_mode;

    if(!ext && !sls_errno && ntw -> netq && mode != QUIT)
	net_to_db (ntw -> netq);
    else if (ntw -> netq) {
	while(!ntw -> netq -> empty()) {
	    pnet = (Netelem *) ntw -> netq -> get();
	    if (pnet -> nmem)
		delete pnet -> nmem;
	    delete pnet;
	}
	delete ntw -> netq;
    }
    delete sym_dict;
    sym_dict = NULL;

    if(ntw->mcq)
    {
        while(!ntw->mcq -> empty()) {
	    pinst = (NetworkInstance *) ntw -> mcq -> get ();
	    delete pinst;
        }
	delete ntw -> mcq;
    }

    if (!ext) {
	if (dsp_term) dmCloseStream(dsp_term, mode);
	if (dsp_mc) dmCloseStream(dsp_mc, mode);
	if (dsp_net) dmCloseStream(dsp_net, mode);
#ifdef FUNCVIEW
	if (!cirflag && dsp_sim_mc)
	    dmCloseStream(dsp_sim_mc, mode);
#endif
	dsp_term = NULL;
	dsp_mc = NULL;
	dsp_net = NULL;
	dsp_sim_mc = NULL;

	dmCheckIn (dmkey, mode);

	if (sls_errno) {
	    sls_errno = BADNETW;
	    return(1);
	}
    }

    return(0);
}
