static char *SccsId = "@(#)write_info.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : cldm/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf, Paul Stravers [ps]
Modification date : 22-Mar-1993


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

/* I like the way these nelsis kids add in-line
 * documentation to their code... @%!*@?&# [ps]
 */

write_info ()
{
    if (!ini_bbbox && !ini_mcbbox) {
	ginfo.bxl = Min (bbnd_xl, mcbb_xl);
	ginfo.bxr = Max (bbnd_xr, mcbb_xr);
	ginfo.byb = Min (bbnd_yb, mcbb_yb);
	ginfo.byt = Max (bbnd_yt, mcbb_yt);
    }
    else
	if (ini_bbbox) {
	    ginfo.bxl = mcbb_xl;
	    ginfo.bxr = mcbb_xr;
	    ginfo.byb = mcbb_yb;
	    ginfo.byt = mcbb_yt;
	    bbnd_xl = bbnd_xr = bbnd_yb = bbnd_yt = 0;
	}
	else {
	    ginfo.bxl = bbnd_xl;
	    ginfo.bxr = bbnd_xr;
	    ginfo.byb = bbnd_yb;
	    ginfo.byt = bbnd_yt;
	    mcbb_xl = mcbb_xr = mcbb_yb = mcbb_yt = 0;
	    /* initialization of the s-o-g bounding box. I think this is the */
	    /* wrong place for initialization, since write_info is only called */
	    /* when an ME (model end) is encountered in the LDM source file. */
	    /* But alas, it seemed to work for mcbb... [ps] */
	    mcNoImage_xl = mcNoImage_xr =
	       mcNoImage_yb = mcNoImage_yt = 0;
	}

    append_tree (ms_name, &mod_tree);
    ALLOC (tree_ptr -> bbox, mod_bbox);
    tree_ptr -> bbox -> xl = ginfo.bxl;
    tree_ptr -> bbox -> xr = ginfo.bxr;
    tree_ptr -> bbox -> yb = ginfo.byb;
    tree_ptr -> bbox -> yt = ginfo.byt;
    tree_ptr -> impcell = 0;

    dmPutDesignData (fp_info, GEO_INFO);

    ginfo.bxl = mcbb_xl;
    ginfo.bxr = mcbb_xr;
    ginfo.byb = mcbb_yb;
    ginfo.byt = mcbb_yt;
    dmPutDesignData (fp_info, GEO_INFO);

    ginfo.bxl = bbnd_xl;
    ginfo.bxr = bbnd_xr;
    ginfo.byb = bbnd_yb;
    ginfo.byt = bbnd_yt;
    dmPutDesignData (fp_info, GEO_INFO);

    /* make sure we have something that makes sense if we never saw an IMAGE: */
    if (mcNoImage_yb == 0 && mcNoImage_yt == 0 &&
	mcNoImage_xl == 0 && mcNoImage_xr == 0)
    {
       mcNoImage_xl = bbnd_xl;
       mcNoImage_xr = bbnd_xr;
       mcNoImage_yb = bbnd_yb;
       mcNoImage_yt = bbnd_yt;
    }
    if (bbnd_xl !=  bbnd_xr)
    {
       mcNoImage_xl = Min(mcNoImage_xl, bbnd_xl);
       mcNoImage_xr = Max(mcNoImage_xr, bbnd_xr);
    }
    if (bbnd_yb !=  bbnd_yt)
    {
       mcNoImage_yb = Min(mcNoImage_yb, bbnd_yb);
       mcNoImage_yt = Max(mcNoImage_yt, bbnd_yt);
    }
    ginfo.bxl = mcNoImage_xl;
    ginfo.bxr = mcNoImage_xr;
    ginfo.byb = mcNoImage_yb;
    ginfo.byt = mcNoImage_yt;
    /* if there is no bbx, don't write it either */
    if (mcNoImage_yb != 0 || mcNoImage_yt != 0 ||
	mcNoImage_xl != 0 || mcNoImage_xr != 0)
       dmPutDesignData (fp_info, GEO_INFO);
}
