static char *SccsId = "@(#)proc_term.c 4.2 (TU-Delft) 08/21/90";
/**********************************************************

Name/Version      : cldm/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 26-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

proc_term (xl, xr, yb, yt)
register int  xl, xr, yb, yt;
{
#ifdef CLDM
    if (xl == xr || yb == yt) {
	pr_exit (014, 30, "terminal"); /* illegal terminal coord's */
	return;
    }
#endif
    if (xl > xr) { tmp_i = xl; xl = xr; xr = tmp_i; }
    if (yb > yt) { tmp_i = yb; yb = yt; yt = tmp_i; }

    /* check for legal terminal layercode */
    if (process -> mask_type[lay_code] != DM_INTCON_MASK) {
	pr_exit (014, 29, layer); /* illegal layercode */
	return;
    }

    strcpy (gterm.term_name, terminal);
    gterm.layer_no = lay_code;
    gterm.xl = xl;
    gterm.xr = xr;
    gterm.yb = yb;
    gterm.yt = yt;

    /* compute bounding box */
    if (nx) {
	if (dx < 0) xl += nx * dx;
	else        xr += nx * dx;
    }
    else dx = 0;

    if (ny) {
	if (dy < 0) yb += ny * dy;
	else        yt += ny * dy;
    }
    else dy = 0;

    gterm.dx = dx;
    gterm.nx = nx;
    gterm.dy = dy;
    gterm.ny = ny;
    gterm.bxl = xl;
    gterm.bxr = xr;
    gterm.byb = yb;
    gterm.byt = yt;

    /* update model-bbox */
    if (ini_bbbox) {
	bbnd_xl = xl;
	bbnd_xr = xr;
	bbnd_yb = yb;
	bbnd_yt = yt;
	ini_bbbox = 0;
    }
    else {
	if (xl < bbnd_xl) bbnd_xl = xl;
	if (xr > bbnd_xr) bbnd_xr = xr;
	if (yb < bbnd_yb) bbnd_yb = yb;
	if (yt > bbnd_yt) bbnd_yt = yt;
    }

    dmPutDesignData (fp_term, GEO_TERM);
}
