static char *SccsId = "@(#)proc_box.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : cldm/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 26-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

proc_box (xl, xr, yb, yt)
register int xl, xr, yb, yt;
{
    if (xl == xr || yb == yt) {
	pr_exit (014, 30, "box"); /* illegal box coord's */
	return;
    }
    if (xl > xr) { tmp_i = xl; xl = xr; xr = tmp_i; }
    if (yb > yt) { tmp_i = yb; yb = yt; yt = tmp_i; }

    gbox.layer_no = lay_code;
    gbox.xl = xl;
    gbox.xr = xr;
    gbox.yb = yb;
    gbox.yt = yt;

    /* compute bounding box */
    if (nx) {
	if ((tmp_i = nx * dx) < 0)
	    xl += tmp_i;
	else       
	    xr += tmp_i;
    }
    if (ny) {
	if ((tmp_i = ny * dy) < 0)
	    yb += tmp_i;
	else       
	    yt += tmp_i;
    }

    gbox.dx = dx;
    gbox.nx = nx;
    gbox.dy = dy;
    gbox.ny = ny;
    gbox.bxl = xl;
    gbox.bxr = xr;
    gbox.byb = yb;
    gbox.byt = yt;

    /* update model-bbox */
    if (ini_bbbox) {
	bbnd_xl = xl;
	bbnd_xr = xr;
	bbnd_yb = yb;
	bbnd_yt = yt;
	ini_bbbox = 0;
    }
    else {
	if (xl < bbnd_xl) bbnd_xl = xl;
	if (xr > bbnd_xr) bbnd_xr = xr;
	if (yb < bbnd_yb) bbnd_yb = yb;
	if (yt > bbnd_yt) bbnd_yt = yt;
    }

    dmPutDesignData (fp_box, GEO_BOX);
}
