#ifndef lint
static char *SccsId = "@(#)man_tree.c 4.4 (TU-Delft) 12/10/91";
#endif
/**********************************************************

Name/Version      : cldm/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 26-Jan-1987
Modification date : 22-Apr-1988
Modification date : 18-Jan-1991
Modification date : 10-Dec-1991 (4.4)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1988, All rights reserved
**********************************************************/
#include "extern.h"

append_tree (name, head)
char   *name;
struct name_tree  **head;
{
    register int    cmp;

    if ((tree_ptr = *head)) {
	cmp = strcmp (name, tree_ptr -> name);
	if (cmp > 0)
	    return (append_tree (name, &(tree_ptr -> rchild)));
	if (cmp < 0)
	    return (append_tree (name, &(tree_ptr -> lchild)));
	return (1); /* found */
    }

    ALLOC (tree_ptr, name_tree);
    strcpy (tree_ptr -> name, name);
    tree_ptr -> errflag = 0;
    tree_ptr -> rchild = tree_ptr -> lchild = NULL;
    *head = tree_ptr;
    return (0); /* not found */
}

check_tree (name, ptr)
char   *name;
struct name_tree *ptr;
{
    register int    cmp;

    if (ptr) {
	cmp = strcmp (name, ptr -> name);
	if (cmp > 0)
	    return (check_tree (name, ptr -> rchild));
	if (cmp < 0)
	    return (check_tree (name, ptr -> lchild));
	tree_ptr = ptr;
	return (1); /* found */
    }
    return (0); /* not found */
}

rm_tree (ptr)
struct name_tree *ptr;
{
    if (ptr) {
	rm_tree (ptr -> lchild);
	rm_tree (ptr -> rchild);
	FREE (ptr);
    }
}

print_tree (s, ptr)
char *s;
struct name_tree *ptr;
{
    if (ptr) {
	    print_tree (s, ptr -> rchild);
	    print_tree (s, ptr -> lchild);
	P_E "tree %s name: %s\n",s, ptr->name);
    }
}
