#ifndef lint
static char *SccsId = "@(#)main.c 4.11 (TU-Delft) 08/12/92";
#endif
/**********************************************************

Name/Version      : cldm/4.11

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 06-Apr-1987
Modification date : 22-Apr-1988
Modification date : 14-May-1990
Modification date : 18-Jan-1991
Modification date : 25-Jan-1991 (4.8)
Modification date : 10-Dec-1991 (4.9)
Modification date : 05-Feb-1992 (4.10)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1988, All rights reserved
**********************************************************/
#include "gdef.h"
#ifdef ESE
#include "eseOption.h"
#include "tversion.h"
#endif

char   *argv0;			/* program name */
#ifndef ESE
char   *use_msg =		/* command line */
#ifdef CLDM
        "\nUsage: %s [-4bfosv] inputfile\n\n";
#else
        "\nUsage: %s [-4bfosv] [-u unit] inputfile\n\n";
#endif
#else
char   *use_msg =		/* command line */
        "\nUsage: %s [options] inputfile\n\n";
#endif

#ifdef ESE
OptionSpec optionSpecs[] = {
    { "", NO, eseHelp, (void *) optionSpecs,
            "Usage:     putcif [options] inputfile.\nOptions (may be abbreviated) are:"},
    { "bell", NO, eseTurnOn, (void *) & b_mode,
            "    -bell:               sound the bell if program has finished"  },
    { "force", NO, eseTurnOn, (void *) & f_mode,
            "    -force:              force cell overwrite"  },
#ifdef CLDM
    { "origin", NO, eseTurnOn, (void *) & o_mode,
            "    -origin:             use the no-origin mode"  },
#else
    { "%origin", NO, eseTurnOn, (void *) & o_mode,
            "    -%origin:            use the origin mode"  },
#endif
    { "slant", NO, eseTurnOn, (void *) & mode45,
            "    -slant:              test non-orthogonal input conform 45 degree." },
    { "syntaxonly", NO, eseTurnOn, (void *) & s_mode,
            "    -syntaxonly:         only check the syntax" },
#ifndef CLDM
    { "unit", YES, eseAssignIntArgument, (void *) & cifunit,
            "    -unit number:        set cif unit of parameters in CIF file, default is 100" },
#endif
    { "verbose", NO, eseTurnOn, (void *) & v_mode,
            "    -verbose:            print run-time information" },
    { "%etext", NO, eseText, (void *) NULL,
            "    -%etext:             print the '(int) & etext' number" },
    { "release", NO, esePrintString, (void *) TOOLVERSION,
            "    -release:            print the release number of this tool"},
    { "%help", NO, eseHelpAll, (void *) optionSpecs,
            "    -%help:              print this list" },
    { "help", NO, eseHelp, (void *) optionSpecs,
            "    -help:               print this list" },
    { (char *) 0, (char) 0, (IFP) 0, (void *) 0, (char *) 0 },
};
#endif

main (argc, argv)
int     argc;
char   *argv[];
{
    FILE * freopen ();
    char * inputfile = NULL;
    int     sig_handler ();
    int     i,
            iarg;
    int     usage = 0;
    char   *rindex ();

    argv0 = rindex (argv[0], '/');
    if (argv0 == 0)
	argv0 = argv[0];
    else
	++argv0;

#ifndef ESE
    for (iarg = 1; iarg < argc && argv[iarg][0] == '-'; iarg++) {
	for (i = 1; argv[iarg][i] != '\0'; i++) {
	    switch (argv[iarg][i]) {
		case '4': 
		    ++mode45;
		    P_E "%s: -4: 45 degree mode\n", argv0);
		    break;
#ifdef CLDM
		case 'o': 
		    ++o_mode;
		    P_E "%s: -o: no model origin mode\n", argv0);
		    break;
#endif
		case 's': 
		    ++s_mode;
		    P_E "%s: -s: syntax check only\n", argv0);
		    break;
		case 'v': 
		    ++v_mode;
		    P_E "%s: -v: verbose\n", argv0);
		    break;
		case 'f': 
		    ++f_mode;	/* force cell overwrite */
		    break;
		case 'b': 
		    ++b_mode;	/* bell on */
		    break;
#ifndef CLDM
		case 'u': 
		    cifunit = atoi (argv[iarg+1]);
		    iarg++;
		    for (i = 1; argv[iarg][i] != '\0'; i++);
		    i--;
		    break;
#endif
		default: 
		    ++usage;
		    P_E "%s: -%c: unknown option\n", argv0, argv[iarg][i]);
	    }
	}
    }

    if (iarg >= argc || usage) {/* only options ? */
	P_E use_msg, argv0);
	exit (1);
    }
    if (iarg + 1 < argc) {
	pr_exit (04, 21, 0);	/* too many arg's */
	P_E use_msg, argv0);
	exit (1);
    }
    inputfile = argv[iarg];
#else
    if (eseOptionHandler (argc, argv, optionSpecs, 1, &inputfile) > 0)
        exit (1);

    if (!inputfile) {/* only options ? */
	P_E use_msg, argv0);
	exit (1);
    }
#endif

    if (stat (inputfile, &stat_buf) == -1)
	pr_exit (0107, 22, inputfile);
    if ((stat_buf.st_mode & S_IFREG) != S_IFREG)
	pr_exit (0107, 23, inputfile);
    if (freopen (inputfile, "r", stdin) == NULL)
	pr_exit (0107, 24, inputfile);

    signal (SIGHUP, SIG_IGN);	/* ignore hangup signal */

    if (signal (SIGINT, SIG_IGN) != SIG_IGN)
	signal (SIGINT, sig_handler);
    if (signal (SIGQUIT, SIG_IGN) != SIG_IGN)
	signal (SIGQUIT, sig_handler);
    if (signal (SIGTERM, SIG_IGN) != SIG_IGN)
	signal (SIGTERM, sig_handler);

    signal (SIGILL, sig_handler);
    signal (SIGFPE, sig_handler);
#ifdef SIGBUS /* [ps] */
    signal (SIGBUS, sig_handler);
#endif
    signal (SIGSEGV, sig_handler);

    if (!s_mode) {

	dmInit (argv0);
	dmproject = dmOpenProject (DEFAULT_PROJECT, DEFAULT_MODE);

    /* get process information */
	process = (DM_PROCDATA *) dmGetMetaDesignData (PROCESS, dmproject);

    /* read model list into the model tree */
	ini_modtree ();
    }

 /* start parsing LDM input */
    yyparse ();

 /* we cannot come here */
}

dmError (s)
char   *s;
{
#if NCF_RELEASE < 400
    P_E "%s: ", argv0);
#endif
    dmPerror (s);
    pr_exit (0107, 0, "error in DMI function");
}

sig_handler (sig)		/* signal handler */
int     sig;
{
    char    buf[6];
    signal (SIGINT, SIG_IGN);	/* ignore intr signal */
    signal (SIGQUIT, SIG_IGN);	/* ignore quit signal */
    sprintf (buf, "%d", sig);
    pr_exit (0107, 6, buf);
}
