%{
/* SccsId = "@(#)ldm_lex.l 4.1 (TU-Delft) 05/24/90" */
/**********************************************************

Name/Version      : cldm/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 13-May-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
/*
**  Redefines of standard lex input/unput macro's
**  Note: No line counter is include here !
*/

/* [ps]
#undef  input()
#define input() (\
((yytchar=(yysptr>yysbuf)?(*--yysptr):getc(yyin)) == EOF)?\
(0):(yytchar))

#undef  unput()
#define unput(c) { *yysptr++ = (c); }

#define GETC() (yysptr>yysbuf)?(*--yysptr):getc(yyin)
*/

#define GETC() input()

#ifdef FLEX_SCANNER
int yylineno = 0;
#undef yywrap() /* because this is defined as a function below */
#endif

extern double my_atof();

%}

%%
ms		{
		    if (n_tok) return (WORD);
                    else {
			if (ms_tok) {
			    pr_exit (014, 1, 0);
			    pr_exit (04, 26, ms_name);
			}
			w_tok = 0;
			n_tok = ms_tok = 1;
			return (MS);
		    }
		}
me		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			}
			w_tok = ms_tok = 0;
			return (ME);
		    }
		}
mc		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = 1;
			return (MC);
		    }
		}
box		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = 1;
			return (BOX);
		    }
		}
sbox		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = 1;
			return (SBOX);
		    }
		}
term		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = t_tok = 1;
			return (TERM);
		    }
		}
poly		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = 1;
			return (POLY);
		   }
		}
wire		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			n_tok = w_tok = 1;
			return (WIRE);
		    }
		}
swire		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = 1;
			return (SWIRE);
		    }
		}
cont		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			if (!w_tok) {
			    pr_exit (014, 3, 0);
			    w_tok = 1;
			}
			return (CONT);
		    }
		}
circle		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = 1;
			return (CIRCLE);
		    }
		}
cpeel		{
		    if (n_tok) return (WORD);
		    else {
			if (!ms_tok) {
			    pr_exit (014, 2, 0);
			    ms_tok = 1;
			}
			w_tok = 0;
			n_tok = 1;
			return (CPEEL);
		    }
		}
cx		{ if (n_tok) return (WORD); else return (CX); }
cy		{ if (n_tok) return (WORD); else return (CY); }
mx		{ if (n_tok) return (WORD); else return (MX); }
my		{ if (n_tok) return (WORD); else return (MY); }
t		{ if (n_tok) return (WORD); else return (TRANS); }
w		{ if (n_tok) return (WORD); else return (WIDTH); }
x		{ if (n_tok) return (WORD); else return (X); }
y		{ if (n_tok) return (WORD); else return (Y); }
r3		{ if (n_tok) return (WORD); else return (R3); }
r6		{ if (n_tok) return (WORD); else return (R6); }
r9		{ if (n_tok) return (WORD); else return (R9); }
sfx		{ if (n_tok) return (WORD); else return (SFX); }
sfy		{ if (n_tok) return (WORD); else return (SFY); }
","		{ return (','); }
"<"		{ return ('<'); }
">"		{ return ('>'); }
\n		{ return (EOL); }
":"		{ read_to_nl (); return (':'); }
[A-Za-z][A-Za-z0-9_]*   { return (WORD); }
[-+]?[0-9]+	|
[-+]?[0-9]+"."	{
		  yylval = atoi (yytext); return (INTEGER);
		}
[-+]?[0-9]*"."[0-9]+ {
		  /* this does not work on Sun: d_f = atof (yytext); */
                  d_f = my_atof(yytext);
		  return (FLOAT);
		}
[ \t]		{ ; }
"\\".*\n	{ ++yylineno; /* ignore newline */ }
.		{ read_to_nl (); return (ILLCHAR); }
%%

read_to_nl ()
{
    int thechar;
    while ((thechar = GETC ()) != '\n' && thechar != EOF) ;
    unput ('\n');
}


yywrap ()
{
    if (feof (yyin)) {
	if (ms_tok) {
	    pr_exit (0114, 1, 0);
	    pr_exit (04, 26, ms_name);
	    pr_exit (07, 7, 0);
        }
	pr_exit (05, 7, 0);
    }
/*  return (0); */
    return 1; /* [ps] */
}


double my_atof(a)
   char *a;
{
   double f;
#ifdef sun /* atof is broken on some Suns... */
   sscanf(a,"%lf",&f);
#else
   f = atof(a);
#endif
   return f;
}
