static char *SccsId = "@(#)main.c 4.6 (TU-Delft) 03/14/91";
/**********************************************************

Name/Version      : cacdcmap/4.6

Language          : C
Operating system  : BSD4.2 | BSD4.3 | SYS5
Host machine      : HP9000s[358]00 | GOULD PN6000 | APOLLO DN[34]000

Author(s)         : P. Bingley
Creation date     : 18-Aug-1988
Modified by       : S. de Graaf
Modification date : 17-Feb-1989


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 781708

        COPYRIGHT (C) 1988-1989, All rights reserved
**********************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include "cacdcmap.h"

#ifdef ESE
#include "eseOption.h"
#include "tversion.h"
#endif /* ESE */

/* External Declarations */
extern  float   _cacdcmap3[];
extern  float   _cacdcmap5[];
extern  float   _cacdcmap7[];

extern	char	*getenv();
extern	int	set_cacd_cmap();

/* Global Declarations */
int		rmv = 0;
int		print = 0;
int		force = 0;
int		silent = 0;
int		verbose = 0;
char	*dispname = NULL;


#ifdef ESE
char *argv0 = "setcmap";
char *usg_msg = "\nUsage: %s [options]\n\n";

int esePlanes = 0;

OptionSpec optionSpecs[] = {
    { "", NO, eseHelp, (void *) optionSpecs,
            "usage:     setcmap [options] \nOptions (may be abbreviated) are:"},
    { "%etext", NO, eseText, (void *) NULL,
            "    -%etext:                   print the '(int) & etext' number" },
    { "%help", NO, eseHelpAll, (void *) optionSpecs,
            "    -%help:                   print this list" },
    { "help", NO, eseHelp, (void *) optionSpecs,
            "    -help:                    print this list" },
    { "release", NO, esePrintString, (void *) TOOLVERSION,
            "    -release:                 print the release number of this tool" },
    { "planes", YES, eseAssignIntArgument, (void *) & esePlanes,
            "    -planes noBits:           set a 'noBits (3, 5 or 7)' bit plane colormap"  },
    { "display", YES, eseAssignArgument, (void *) & dispname,
            "    -display host:dnr[.snr]]: set the display to be used" },
    { "force", NO, eseTurnOn, (void *) & force,
            "    -force:                   force the installation of a new colormap"  },
    { "print", NO, eseTurnOn, (void *) & print,
            "    -print:                   print the current colormap"  },
    { "remove", NO, eseTurnOn, (void *) & rmv,
            "    -remove:                  remove the current colormap"  },
    { "verbose", NO, eseTurnOn, (void *) & verbose,
            "    -verbose:                 print additional status information"  },
    { "silent", NO, eseTurnOn, (void *) & silent,
            "    -silent:                  run in silent mode"  },
    { (char *) 0, (char) 0, (IFP) 0, (void *) 0, (char *) 0 },
};
#endif

/* Local Declarations */

/*********************************************************/


main(argc, argv)
int argc;
char **argv;
{
    Display	*dpy;
    int		s_nr;
    float	*ctab[3];
    int		planes[3];
    int		nplanes = 0;
    int		error = 0;
    int		i;

    /* parse options */
#ifndef ESE
    for(i = 1; i < argc; ++i) {
	if(strcmp("-help", argv[i]) == 0) {
	    error = 1;
	    continue;
	}
	else if(strcmp("-3", argv[i]) == 0) {
	    planes[0] = 3;
	    ctab[0] = _cacdcmap3;
	    nplanes = 1;
	    continue;
	}
	else if(strcmp("-5", argv[i]) == 0) {
	    planes[0] = 5;
	    ctab[0] = _cacdcmap5;
	    nplanes = 1;
	    continue;
	}
	else if(strcmp("-7", argv[i]) == 0) {
	    planes[0] = 7;
	    ctab[0] = _cacdcmap7;
	    nplanes = 1;
	    continue;
	}
	else if(strcmp("-p", argv[i]) == 0) {
	    print = 1;
	    continue;
	}
	else if(strcmp("-r", argv[i]) == 0) {
	    rmv = 1;
	    continue;
	}
	else if(strcmp("-f", argv[i]) == 0) {
	    force = 1;
	    continue;
	}
	else if(strcmp("-v", argv[i]) == 0) {
	    verbose = 1;
	    continue;
	}
	else if(strcmp("-s", argv[i]) == 0) {
	    silent = 1;
	    continue;
	}
	else if(strcmp("-display", argv[i]) == 0) {
	    if(++i >= argc) {
		error = 1;
	    }
	    else {
		dispname = argv[i];
	    }
	    continue;
	}
	else {
	    error = 1;
	}
    }

    if(error) {
	if(!silent) {
	    fprintf(stderr, "Usage: %s [-help] [-display host:dpy] ", argv[0]);
	    fprintf(stderr, "[-3 | -5 | -7] [-p] [-r] [-f] [-s] [-v]\n");
	}
	exit(1);
    }
#else
    if (eseOptionHandler (argc, argv, optionSpecs, 0, NULL) > 0) {
        fprintf(stderr, usg_msg, argv0);
        exit(1);
    }

    switch (esePlanes) {
        case 3:
            planes[0] = 3;
            ctab[0] = _cacdcmap3;
            nplanes = 1;
            break;
        case 5:
            planes[0] = 5;
            ctab[0] = _cacdcmap5;
            nplanes = 1;
            break;
        case 7:
            planes[0] = 7;
            ctab[0] = _cacdcmap7;
            nplanes = 1;
            break;
        case 0:
            nplanes = 0;
            break;
        default:
	    fprintf (stderr, "-planes %d: illegal number of bit planes\n",
		    esePlanes);
            fprintf(stderr, usg_msg, argv0);
	    exit(1);
    }
#endif /* ESE */

    /* force overrides remove */
    if(force) rmv = 0;

    /* silent overrides verbose */
    if(silent) verbose = 0;

    if(!dispname) dispname = getenv("DISPLAY");

    if((dpy = XOpenDisplay(dispname)) == NULL) {
	fprintf(stderr, "Cannot open display %s\n", dispname ? dispname : "");
	exit(1);
    }
    s_nr = DefaultScreen(dpy);

    if(!rmv) {
	/* set up # of planes array that should be tried */
	if(!nplanes) {
	    if(7 < DisplayPlanes(dpy, s_nr)) {
		ctab[nplanes] = _cacdcmap7;
		planes[nplanes++] = 7;
	    }
	    if(5 < DisplayPlanes(dpy, s_nr)) {
		ctab[nplanes] = _cacdcmap5;
		planes[nplanes++] = 5;
	    }
	    if(3 < DisplayPlanes(dpy, s_nr)) {
		ctab[nplanes] = _cacdcmap3;
		planes[nplanes++] = 3;
	    }
	    if(nplanes == 0) {
		if(!silent) {
		    fprintf(stderr, "Not enough bitplanes in your machine\n");
		}
		exit(1);
	    }
	}
    }

    /* set cacd colormap */
    if(set_cacd_cmap(dpy, s_nr, ctab, planes, nplanes,
	    print, rmv, force, silent, verbose)) {
	exit(0);
    }
    else {	/* not ok */
	exit(1);
    }
}
