static char *SccsId = "@(#)dmkey.c 3.10 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 21-Jan-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988 , All rights reserved
**********************************************************/
#include "dmstd.h"

static  DM_CELL * key_admin[DM_MAXKEYS];
static  keyno = -1;

/* 
** This function allocates a structure describing an
** object which is passed to the user and initializes it.
** Information must still be written to this structure.		 
*/
DM_CELL * _dmMk_cellkey ()
{
    DM_CELL * key;

    if (++keyno == DM_MAXKEYS) {
	_dmFatal ("_dmMk_cellkey: too many open cells", "", "");
    }

    if ((key = (DM_CELL *) malloc (sizeof (DM_CELL))) == NULL) {
	_dmFatal ("_dmMk_cellkey: cannot alloc key", "", "");
    }

    key_admin[keyno] = key;
    key -> keyno = keyno;

    return (key);
}

/* 
** This function removes the structure which is passed to
** the user at check_out time and which identificates the
** object checked out.
*/
_dmRm_cellkey (key)
DM_CELL * key;
{
    if (key -> keyno != keyno) {
	key_admin[key -> keyno] = key_admin[keyno];
	key_admin[keyno] -> keyno = key -> keyno;
    }
    --keyno;
    _dmStrFree (key -> cell);
    _dmStrFree (key -> versionstatus);
    _dmStrFree (key -> view);
    dmFree ((char *) key, sizeof(DM_CELL));
}

/* 
** check if some cell is checked out
*/
_dmCh_chkout ()
{
    if (keyno == -1) return (0);
    return (1);
}

/* 
** check if key is valid
*/
_dmCh_key (key)
DM_CELL * key;
{
    if (key == NULL
	    || keyno < 0
	    || key_admin[key -> keyno] != key) {
	dmerrno = DME_BADKEY;
	return (-1);
    }
    return (0);
}

/* Check if the cell identified by 'proj', 'cell' and 'view'
** has already been checked out by this process.
*/
_dmCh_cell (proj, cell, view)
DM_PROJECT * proj;
char  * cell;
char  * view;
{
    int     i;

    for (i = 0; i <= keyno; ++i) {
	if (key_admin[i] -> dmproject == proj &&
	    strcmp (key_admin[i] -> cell, cell) == 0 &&
	    strcmp (key_admin[i] -> view, view) == 0) {
	    dmerrno = DME_LOCK;
	    return (-1);
	}
    }
    return (0);
}

dmCkinAll (mode)
int mode;
{
    int     i;

    for (i = keyno; i >= 0; --i)
	dmCheckIn (key_admin[i], mode);
}
