/* SccsId = "@(#)dmfuncs.h 3.3 (TU-Delft) 04/28/93" */
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    T.G.R. van Leuken
                    N. van der Meijs
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 17-May-1988
Modified by       : P. Bingley
Modification date : 15-Nov-1989


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA Delft
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988, All rights reserved
**********************************************************/
#ifndef __DMPROTO_INCLUDED
#define __DMPROTO_INCLUDED /* allows multiple inclusion */
#  ifdef __STDC__
int _dmAddImportedCell(DM_PROJECT *dmproject, char *cellname, char *alias, char *view, char *dmpath);
char **_dmCellEquivalence(DM_PROJECT *dmproject, char *dom_cell, char *dom_view, char *range_view);
int _dmAddCellEquivalence(DM_PROJECT *dmproject, char *dom_cell, char *dom_view, char *range_cell, char *range_view);
char **_dmCelllist(DM_PROJECT *dmproject, char *view);
DM_STREAM *_dmMk_streamkey(void);
int _dmRm_streamkey(DM_STREAM *key);
int _dm_print_key(DM_CELL *key, char *s);
int _dmCOToDesMan(DM_CELL *cellkey);
int _dmCIToDesMan(DM_CELL *cellkey, int ci_mode);
int _dmOSToDesMan(DM_STREAM *streamkey);
int _dmFailOSToDesMan(DM_STREAM *streamkey);
int _dmCSToDesMan(DM_STREAM *streamkey, int cs_mode);
int _dmDoget(FILE *iop, register char *fmt, ...);
int _dmDoput(FILE *fp, register char *fmt, ...);
int _dmExistCell(DM_PROJECT *dmproject, char *cell, char *view);
int _dmExistView(DM_PROJECT *dmproject, char *view);
int _dmValidView(char *view);
int _dmFatal(char *format, char *arg1, char *arg2);
char *_dmFatherCell(DM_PROJECT *project, char *cellName, char *view);
int _dmGet_geo_data(FILE *fp, int geo_fmt);
int _dmGet_cir_data(FILE *fp, int cir_fmt);
int _dmDoget_net(FILE *fp, struct cir_net *net, int get_atom);
int _dmDoget_fault(FILE *fp, struct cir_fault *fault);
int _dmGet_flp_data(FILE *fp, int flp_fmt);
DM_PROCDATA *_dmGetProcess(DM_PROJECT *dmproject);
DM_PROCDATA *_dmDoGetProcess(int process_id);
DM_PROCDATA *_dmDoGetProcessFile(char *path);
int _dmIfdebug(char *file, int line);
IMPCELL **_dmImportedCelllist(DM_PROJECT *dmproject, char *view);
int _dmCellIsRoot(DM_PROJECT *dmproject, char *cellname, char *viewtype);
int _dmCellIsRoot2(DM_PROJECT *dmproject, char *cellname, char *viewtype, char **celllist_array);
DM_CELL *_dmMk_cellkey(void);
int _dmRm_cellkey(DM_CELL *key);
int _dmCh_chkout(void);
int _dmCh_key(DM_CELL *key);
int _dmCh_cell(DM_PROJECT *proj, char *cell, char *view);
int _dmLockProject(char *project);
int _dmUnlockProject(char *project);
int _dmcorrect_path(char *dmpath);
int _dmPack(FILE *fp, register char *fmt, ...);
int _dmUnpack(FILE *fp, register char *fmt, ...);
int _dmPut_geo_data(FILE *fp, int geo_fmt);
int _dmPut_cir_data(FILE *fp, int cir_fmt);
int _dmDoput_net(FILE *fp, struct cir_net *net, int put_atom);
int _dmDoput_fault(FILE *fp, struct cir_fault *fault);
int _dmPut_flp_data(FILE *fp, int flp_fmt);
DM_PROJECT *_dmMk_projectkey(void);
int _dmRm_projectkey(DM_PROJECT *key);
int _dmCh_opproj(void);
int _dmCh_project(DM_PROJECT *key);
DM_PROJECT *_dmCh_proj(char *path);
int _dmClose_allproj(int mode);
DM_PROCDATA *_dmSearchProcInProjKeys(int processid);
char **_dmProjectlist(DM_PROJECT *dmproject);
char *_dmGetProcPath(DM_PROJECT *dmproject, char *file_name);
char *_dmDoGetProcPath(int process_id, char *file_name);
int _dmRmCell(DM_PROJECT *dmproject, char *cell, char *view);
int _dmRmDir(DM_PROJECT *dmproject, char *path);
int _dmRun(char *path, ...);
int _dmSprintf(register char *ptr, register char *fmt, ...);
char *_dmStrSave(char *string);
int _dmStrFree(char *string);
char  *mnew(int siz);
void  mfree(char **blk, int siz);
char  *cs(char *);
int  fs(char *);
#  else /* not __STDC__ */
int _dmAddImportedCell();
char **_dmCellEquivalence();
int _dmAddCellEquivalence();
char **_dmCelllist();
DM_STREAM *_dmMk_streamkey();
int _dmRm_streamkey();
int _dm_print_key();
int _dmCOToDesMan();
int _dmCIToDesMan();
int _dmOSToDesMan();
int _dmFailOSToDesMan();
int _dmCSToDesMan();
int _dmDoget();
int _dmDoput();
int _dmExistCell();
int _dmExistView();
int _dmValidView();
int _dmFatal();
char *_dmFatherCell();
int _dmGet_geo_data();
int _dmGet_cir_data();
int _dmDoget_net();
int _dmDoget_fault();
int _dmGet_flp_data();
DM_PROCDATA *_dmGetProcess();
DM_PROCDATA *_dmDoGetProcess();
DM_PROCDATA *_dmDoGetProcessFile();
int _dmIfdebug();
IMPCELL **_dmImportedCelllist();
int _dmCellIsRoot();
int _dmCellIsRoot2();
DM_CELL *_dmMk_cellkey();
int _dmRm_cellkey();
int _dmCh_chkout();
int _dmCh_key();
int _dmCh_cell();
int _dmLockProject();
int _dmUnlockProject();
int _dmcorrect_path();
int _dmPack();
int _dmUnpack();
int _dmPut_geo_data();
int _dmPut_cir_data();
int _dmDoput_net();
int _dmDoput_fault();
int _dmPut_flp_data();
DM_PROJECT *_dmMk_projectkey();
int _dmRm_projectkey();
int _dmCh_opproj();
int _dmCh_project();
DM_PROJECT *_dmCh_proj();
int _dmClose_allproj();
DM_PROCDATA *_dmSearchProcInProjKeys();
char **_dmProjectlist();
char *_dmGetProcPath();
char *_dmDoGetProcPath();
int _dmRmCell();
int _dmRmDir();
int _dmRun();
int _dmSprintf();
char *_dmStrSave();
int _dmStrFree();
char  *mnew();
void  mfree();
char  *cs();
int  fs();
#  endif /* else not __STDC__ */
#endif /* __DMPROTO_INCLUDED */
